/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.net.ProtocolException;
import okhttp3.Protocol;
import okhttp3.Response;

public final class StatusLine {
    public static final int HTTP_TEMP_REDIRECT = 307;
    public static final int HTTP_PERM_REDIRECT = 308;
    public static final int HTTP_CONTINUE = 100;
    public final Protocol protocol;
    public final int code;
    public final String message;

    public StatusLine(Protocol protocol, int code, String message) {
        this.protocol = protocol;
        this.code = code;
        this.message = message;
    }

    public static StatusLine get(Response response) {
        return new StatusLine(response.protocol(), response.code(), response.message());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatusLine parse(String statusLine) {
        Protocol protocol;
        int n;
        int n2;
        if (statusLine.startsWith("HTTP/1.")) {
            if (statusLine.length() < 9 || statusLine.charAt(8) != ' ') {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            n2 = statusLine.charAt(7) - 48;
            n = 9;
            if (n2 == 0) {
                protocol = Protocol.HTTP_1_0;
            } else {
                if (n2 != 1) throw new ProtocolException("Unexpected status line: " + statusLine);
                protocol = Protocol.HTTP_1_1;
            }
        } else {
            if (!statusLine.startsWith("ICY ")) throw new ProtocolException("Unexpected status line: " + statusLine);
            protocol = Protocol.HTTP_1_0;
            n = 4;
        }
        if (statusLine.length() < n + 3) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        try {
            n2 = Integer.parseInt(statusLine.substring(n, n + 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        String string = "";
        if (statusLine.length() <= n + 3) return new StatusLine(protocol, n2, string);
        if (statusLine.charAt(n + 3) != ' ') {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        string = statusLine.substring(n + 4);
        return new StatusLine(protocol, n2, string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.protocol == Protocol.HTTP_1_0 ? "HTTP/1.0" : "HTTP/1.1");
        stringBuilder.append(' ').append(this.code);
        if (this.message != null) {
            stringBuilder.append(' ').append(this.message);
        }
        return stringBuilder.toString();
    }
}

