/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.StreamAllocation;
import okhttp3.internal.http.HttpCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealResponseBody;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Http2Codec
implements HttpCodec {
    private static final ByteString CONNECTION = ByteString.encodeUtf8("connection");
    private static final ByteString HOST = ByteString.encodeUtf8("host");
    private static final ByteString KEEP_ALIVE = ByteString.encodeUtf8("keep-alive");
    private static final ByteString PROXY_CONNECTION = ByteString.encodeUtf8("proxy-connection");
    private static final ByteString TRANSFER_ENCODING = ByteString.encodeUtf8("transfer-encoding");
    private static final ByteString TE = ByteString.encodeUtf8("te");
    private static final ByteString ENCODING = ByteString.encodeUtf8("encoding");
    private static final ByteString UPGRADE = ByteString.encodeUtf8("upgrade");
    private static final List<ByteString> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY);
    private static final List<ByteString> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE);
    private final OkHttpClient client;
    private final Interceptor.Chain chain;
    final StreamAllocation streamAllocation;
    private final Http2Connection connection;
    private Http2Stream stream;

    public Http2Codec(OkHttpClient client, Interceptor.Chain chain, StreamAllocation streamAllocation, Http2Connection connection) {
        this.client = client;
        this.chain = chain;
        this.streamAllocation = streamAllocation;
        this.connection = connection;
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request) {
        if (this.stream != null) {
            return;
        }
        boolean bl = request.body() != null;
        List<Header> list = Http2Codec.http2HeadersList(request);
        this.stream = this.connection.newStream(list, bl);
        this.stream.readTimeout().timeout(this.chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout(this.chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() {
        this.connection.flush();
    }

    @Override
    public void finishRequest() {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean expectContinue) {
        List<Header> list = this.stream.takeResponseHeaders();
        Response.Builder builder = Http2Codec.readHttp2HeadersList(list);
        if (expectContinue && Internal.instance.code(builder) == 100) {
            return null;
        }
        return builder;
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.TARGET_METHOD, request.method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        String string = request.header("Host");
        if (string != null) {
            arrayList.add(new Header(Header.TARGET_AUTHORITY, string));
        }
        arrayList.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            ByteString byteString = ByteString.encodeUtf8(headers.name(i).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(byteString)) continue;
            arrayList.add(new Header(byteString, headers.value(i)));
        }
        return arrayList;
    }

    public static Response.Builder readHttp2HeadersList(List<Header> headerBlock) {
        StatusLine statusLine = null;
        Headers.Builder builder = new Headers.Builder();
        int n = headerBlock.size();
        for (int i = 0; i < n; ++i) {
            Header header = headerBlock.get(i);
            if (header == null) {
                if (statusLine == null || statusLine.code != 100) continue;
                statusLine = null;
                builder = new Headers.Builder();
                continue;
            }
            ByteString byteString = header.name;
            String string = header.value.utf8();
            if (byteString.equals(Header.RESPONSE_STATUS)) {
                statusLine = StatusLine.parse("HTTP/1.1 " + string);
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(byteString)) continue;
            Internal.instance.addLenient(builder, byteString.utf8(), string);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        return new Response.Builder().protocol(Protocol.HTTP_2).code(statusLine.code).message(statusLine.message).headers(builder.build());
    }

    @Override
    public ResponseBody openResponseBody(Response response) {
        this.streamAllocation.eventListener.responseBodyStart(this.streamAllocation.call);
        String string = response.header("Content-Type");
        long l = HttpHeaders.contentLength(response);
        StreamFinishingSource streamFinishingSource = new StreamFinishingSource(this.stream.getSource());
        return new RealResponseBody(string, l, Okio.buffer(streamFinishingSource));
    }

    @Override
    public void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    class StreamFinishingSource
    extends ForwardingSource {
        boolean completed;
        long bytesRead;

        StreamFinishingSource(Source delegate) {
            super(delegate);
            this.completed = false;
            this.bytesRead = 0L;
        }

        @Override
        public long read(Buffer sink, long byteCount) {
            try {
                long l = this.delegate().read(sink, byteCount);
                if (l > 0L) {
                    this.bytesRead += l;
                }
                return l;
            }
            catch (IOException iOException) {
                this.endOfInput(iOException);
                throw iOException;
            }
        }

        @Override
        public void close() {
            super.close();
            this.endOfInput(null);
        }

        private void endOfInput(IOException e2) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            Http2Codec.this.streamAllocation.streamFinished(false, Http2Codec.this, this.bytesRead, e2);
        }
    }
}

