/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSink;

final class Http2Writer
implements Closeable {
    private static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    final Hpack.Writer hpackWriter;

    Http2Writer(BufferedSink sink, boolean client) {
        this.sink = sink;
        this.client = client;
        this.hpackBuffer = new Buffer();
        this.hpackWriter = new Hpack.Writer(this.hpackBuffer);
        this.maxFrameSize = 16384;
    }

    public synchronized void connectionPreface() {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!this.client) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Util.format(">> CONNECTION %s", Http2.CONNECTION_PREFACE.hex()));
        }
        this.sink.write(Http2.CONNECTION_PREFACE.toByteArray());
        this.sink.flush();
    }

    public synchronized void applyAndAckSettings(Settings peerSettings) {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.maxFrameSize = peerSettings.getMaxFrameSize(this.maxFrameSize);
        if (peerSettings.getHeaderTableSize() != -1) {
            this.hpackWriter.setHeaderTableSizeSetting(peerSettings.getHeaderTableSize());
        }
        int n = 0;
        byte by = 4;
        byte by2 = 1;
        int n2 = 0;
        this.frameHeader(n2, n, by, by2);
        this.sink.flush();
    }

    public synchronized void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(requestHeaders);
        long l = this.hpackBuffer.size();
        int n = (int)Math.min((long)(this.maxFrameSize - 4), l);
        byte by = 5;
        byte by2 = l == (long)n ? (byte)4 : 0;
        this.frameHeader(streamId, n + 4, by, by2);
        this.sink.writeInt(promisedStreamId & Integer.MAX_VALUE);
        this.sink.write(this.hpackBuffer, (long)n);
        if (l > (long)n) {
            this.writeContinuationFrames(streamId, l - (long)n);
        }
    }

    public synchronized void flush() {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    public synchronized void synStream(boolean outFinished, int streamId, int associatedStreamId, List<Header> headerBlock) {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(outFinished, streamId, headerBlock);
    }

    public synchronized void synReply(boolean outFinished, int streamId, List<Header> headerBlock) {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(outFinished, streamId, headerBlock);
    }

    public synchronized void headers(int streamId, List<Header> headerBlock) {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.headers(false, streamId, headerBlock);
    }

    public synchronized void rstStream(int streamId, ErrorCode errorCode) {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.httpCode == -1) {
            throw new IllegalArgumentException();
        }
        int n = 4;
        byte by = 3;
        byte by2 = 0;
        this.frameHeader(streamId, n, by, by2);
        this.sink.writeInt(errorCode.httpCode);
        this.sink.flush();
    }

    public int maxDataLength() {
        return this.maxFrameSize;
    }

    public synchronized void data(boolean outFinished, int streamId, Buffer source, int byteCount) {
        if (this.closed) {
            throw new IOException("closed");
        }
        byte by = 0;
        if (outFinished) {
            by = (byte)(by | 1);
        }
        this.dataFrame(streamId, by, source, byteCount);
    }

    void dataFrame(int streamId, byte flags, Buffer buffer, int byteCount) {
        byte by = 0;
        this.frameHeader(streamId, byteCount, by, flags);
        if (byteCount > 0) {
            this.sink.write(buffer, (long)byteCount);
        }
    }

    public synchronized void settings(Settings settings) {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n = settings.size() * 6;
        byte by = 4;
        byte by2 = 0;
        int n2 = 0;
        this.frameHeader(n2, n, by, by2);
        for (int i = 0; i < 10; ++i) {
            if (!settings.isSet(i)) continue;
            int n3 = i;
            if (n3 == 4) {
                n3 = 3;
            } else if (n3 == 7) {
                n3 = 4;
            }
            this.sink.writeShort(n3);
            this.sink.writeInt(settings.get(i));
        }
        this.sink.flush();
    }

    public synchronized void ping(boolean ack, int payload1, int payload2) {
        if (this.closed) {
            throw new IOException("closed");
        }
        int n = 8;
        byte by = 6;
        byte by2 = ack ? (byte)1 : 0;
        int n2 = 0;
        this.frameHeader(n2, n, by, by2);
        this.sink.writeInt(payload1);
        this.sink.writeInt(payload2);
        this.sink.flush();
    }

    public synchronized void goAway(int lastGoodStreamId, ErrorCode errorCode, byte[] debugData) {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (errorCode.httpCode == -1) {
            throw Http2.illegalArgument("errorCode.httpCode == -1", new Object[0]);
        }
        int n = 8 + debugData.length;
        byte by = 7;
        byte by2 = 0;
        int n2 = 0;
        this.frameHeader(n2, n, by, by2);
        this.sink.writeInt(lastGoodStreamId);
        this.sink.writeInt(errorCode.httpCode);
        if (debugData.length > 0) {
            this.sink.write(debugData);
        }
        this.sink.flush();
    }

    public synchronized void windowUpdate(int streamId, long windowSizeIncrement) {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (windowSizeIncrement == 0L || windowSizeIncrement > Integer.MAX_VALUE) {
            throw Http2.illegalArgument("windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: %s", windowSizeIncrement);
        }
        int n = 4;
        byte by = 8;
        byte by2 = 0;
        this.frameHeader(streamId, n, by, by2);
        this.sink.writeInt((int)windowSizeIncrement);
        this.sink.flush();
    }

    public void frameHeader(int streamId, int length, byte type, byte flags) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.frameLog(false, streamId, length, type, flags));
        }
        if (length > this.maxFrameSize) {
            throw Http2.illegalArgument("FRAME_SIZE_ERROR length > %d: %d", this.maxFrameSize, length);
        }
        if ((streamId & Integer.MIN_VALUE) != 0) {
            throw Http2.illegalArgument("reserved bit set: %s", streamId);
        }
        Http2Writer.writeMedium(this.sink, length);
        this.sink.writeByte(type & 0xFF);
        this.sink.writeByte(flags & 0xFF);
        this.sink.writeInt(streamId & Integer.MAX_VALUE);
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.sink.close();
    }

    private static void writeMedium(BufferedSink sink, int i) {
        sink.writeByte(i >>> 16 & 0xFF);
        sink.writeByte(i >>> 8 & 0xFF);
        sink.writeByte(i & 0xFF);
    }

    private void writeContinuationFrames(int streamId, long byteCount) {
        while (byteCount > 0L) {
            int n;
            this.frameHeader(streamId, n, (byte)9, (byteCount -= (long)(n = (int)Math.min((long)this.maxFrameSize, byteCount))) == 0L ? (byte)4 : 0);
            this.sink.write(this.hpackBuffer, (long)n);
        }
    }

    void headers(boolean outFinished, int streamId, List<Header> headerBlock) {
        byte by;
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(headerBlock);
        long l = this.hpackBuffer.size();
        int n = (int)Math.min((long)this.maxFrameSize, l);
        byte by2 = 1;
        byte by3 = by = l == (long)n ? (byte)4 : 0;
        if (outFinished) {
            by = (byte)(by | 1);
        }
        this.frameHeader(streamId, n, by2, by);
        this.sink.write(this.hpackBuffer, (long)n);
        if (l > (long)n) {
            this.writeContinuationFrames(streamId, l - (long)n);
        }
    }
}

