/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.OptionalMethod;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();

    AndroidPlatform(Class<?> sslParametersClass, OptionalMethod<Socket> setUseSessionTickets, OptionalMethod<Socket> setHostname, OptionalMethod<Socket> getAlpnSelectedProtocol, OptionalMethod<Socket> setAlpnProtocols) {
        this.sslParametersClass = sslParametersClass;
        this.setUseSessionTickets = setUseSessionTickets;
        this.setHostname = setHostname;
        this.getAlpnSelectedProtocol = getAlpnSelectedProtocol;
        this.setAlpnProtocols = setAlpnProtocols;
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) {
        try {
            socket.connect(address, connectTimeout);
        }
        catch (AssertionError assertionError) {
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)((Object)assertionError));
            }
            throw assertionError;
        }
        catch (SecurityException securityException) {
            IOException iOException = new IOException("Exception in connect");
            iOException.initCause(securityException);
            throw iOException;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                IOException iOException = new IOException("Exception in connect");
                iOException.initCause(classCastException);
                throw iOException;
            }
            throw classCastException;
        }
    }

    @Override
    protected X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        Object object;
        Object object2 = AndroidPlatform.readFieldOrNull(sslSocketFactory, this.sslParametersClass, "sslParameters");
        if (object2 == null) {
            try {
                object = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sslSocketFactory.getClass().getClassLoader());
                object2 = AndroidPlatform.readFieldOrNull(sslSocketFactory, object, "sslParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager(sslSocketFactory);
            }
        }
        if ((object = AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, "x509TrustManager")) != null) {
            return object;
        }
        return AndroidPlatform.readFieldOrNull(object2, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        if (hostname != null) {
            this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sslSocket, true);
            this.setHostname.invokeOptionalWithoutCheckedException(sslSocket, hostname);
        }
        if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sslSocket)) {
            Object[] objectArray = new Object[]{AndroidPlatform.concatLengthPrefixed(protocols)};
            this.setAlpnProtocols.invokeWithoutCheckedException(sslSocket, objectArray);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket socket) {
        if (this.getAlpnSelectedProtocol == null) {
            return null;
        }
        if (!this.getAlpnSelectedProtocol.isSupported(socket)) {
            return null;
        }
        byte[] byArray = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException(socket, new Object[0]);
        return byArray != null ? new String(byArray, Util.UTF_8) : null;
    }

    @Override
    public void log(int level, String message, Throwable t) {
        int n;
        int n2 = n = level == 5 ? 5 : 3;
        if (t != null) {
            message = message + '\n' + Log.getStackTraceString((Throwable)t);
        }
        int n3 = message.length();
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = message.indexOf(10, i);
            n5 = n5 != -1 ? n5 : n3;
            do {
                n4 = Math.min(n5, i + 4000);
                Log.println((int)n, (String)"OkHttp", (String)message.substring(i, n4));
            } while ((i = n4) < n5);
        }
    }

    @Override
    public Object getStackTraceForCloseable(String closer) {
        return this.closeGuard.createAndOpen(closer);
    }

    @Override
    public void logCloseableLeak(String message, Object stackTrace) {
        boolean bl = this.closeGuard.warnIfOpen(stackTrace);
        if (!bl) {
            this.log(5, message, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(String hostname) {
        try {
            Class<?> clazz = Class.forName("android.security.NetworkSecurityPolicy");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            return this.api24IsCleartextTrafficPermitted(hostname, clazz, object);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return super.isCleartextTrafficPermitted(hostname);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw Util.assertionError("unable to determine cleartext support", exception);
        }
    }

    private boolean api24IsCleartextTrafficPermitted(String hostname, Class<?> networkPolicyClass, Object networkSecurityPolicy) {
        try {
            Method method = networkPolicyClass.getMethod("isCleartextTrafficPermitted", String.class);
            return (Boolean)method.invoke(networkSecurityPolicy, hostname);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.api23IsCleartextTrafficPermitted(hostname, networkPolicyClass, networkSecurityPolicy);
        }
    }

    private boolean api23IsCleartextTrafficPermitted(String hostname, Class<?> networkPolicyClass, Object networkSecurityPolicy) {
        try {
            Method method = networkPolicyClass.getMethod("isCleartextTrafficPermitted", new Class[0]);
            return (Boolean)method.invoke(networkSecurityPolicy, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(hostname);
        }
    }

    private static boolean supportsAlpn() {
        if (Security.getProvider("GMSCore_OpenSSL") != null) {
            return true;
        }
        try {
            Class.forName("android.net.Network");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        try {
            Class<?> clazz = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = clazz.getConstructor(X509TrustManager.class);
            Object obj = constructor.newInstance(trustManager);
            Method method = clazz.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(obj, method);
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(trustManager);
        }
    }

    public static Platform buildIfSupported() {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod<Socket> optionalMethod = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> optionalMethod2 = new OptionalMethod<Socket>(null, "setHostname", String.class);
            OptionalMethod<Socket> optionalMethod3 = null;
            OptionalMethod optionalMethod4 = null;
            if (AndroidPlatform.supportsAlpn()) {
                optionalMethod3 = new OptionalMethod<Socket>(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                optionalMethod4 = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
            }
            return new AndroidPlatform(clazz, optionalMethod, optionalMethod2, optionalMethod3, optionalMethod4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        try {
            Method method = trustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
            method.setAccessible(true);
            return new AndroidTrustRootIndex(trustManager, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(trustManager);
        }
    }

    static final class AndroidTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        AndroidTrustRootIndex(X509TrustManager trustManager, Method findByIssuerAndSignatureMethod) {
            this.findByIssuerAndSignatureMethod = findByIssuerAndSignatureMethod;
            this.trustManager = trustManager;
        }

        @Override
        public X509Certificate findByIssuerAndSignature(X509Certificate cert) {
            try {
                TrustAnchor trustAnchor = (TrustAnchor)this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, cert);
                return trustAnchor != null ? trustAnchor.getTrustedCert() : null;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw Util.assertionError("unable to get issues and signature", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                return null;
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AndroidTrustRootIndex)) {
                return false;
            }
            AndroidTrustRootIndex androidTrustRootIndex = (AndroidTrustRootIndex)obj;
            return this.trustManager.equals(androidTrustRootIndex.trustManager) && this.findByIssuerAndSignatureMethod.equals(androidTrustRootIndex.findByIssuerAndSignatureMethod);
        }

        public int hashCode() {
            return this.trustManager.hashCode() + 31 * this.findByIssuerAndSignatureMethod.hashCode();
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method getMethod, Method openMethod, Method warnIfOpenMethod) {
            this.getMethod = getMethod;
            this.openMethod = openMethod;
            this.warnIfOpenMethod = warnIfOpenMethod;
        }

        Object createAndOpen(String closer) {
            if (this.getMethod != null) {
                try {
                    Object object = this.getMethod.invoke(null, new Object[0]);
                    this.openMethod.invoke(object, closer);
                    return object;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        boolean warnIfOpen(Object closeGuardInstance) {
            boolean bl = false;
            if (closeGuardInstance != null) {
                try {
                    this.warnIfOpenMethod.invoke(closeGuardInstance, new Object[0]);
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }

        static CloseGuard get() {
            Method method;
            Method method2;
            Method method3;
            try {
                Class<?> clazz = Class.forName("dalvik.system.CloseGuard");
                method3 = clazz.getMethod("get", new Class[0]);
                method2 = clazz.getMethod("open", String.class);
                method = clazz.getMethod("warnIfOpen", new Class[0]);
            }
            catch (Exception exception) {
                method3 = null;
                method2 = null;
                method = null;
            }
            return new CloseGuard(method3, method2, method);
        }
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        AndroidCertificateChainCleaner(Object x509TrustManagerExtensions, Method checkServerTrusted) {
            this.x509TrustManagerExtensions = x509TrustManagerExtensions;
            this.checkServerTrusted = checkServerTrusted;
        }

        @Override
        public List<Certificate> clean(List<Certificate> chain, String hostname) {
            try {
                X509Certificate[] x509CertificateArray = chain.toArray(new X509Certificate[chain.size()]);
                return (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, x509CertificateArray, "RSA", hostname);
            }
            catch (InvocationTargetException invocationTargetException) {
                SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(invocationTargetException.getMessage());
                sSLPeerUnverifiedException.initCause(invocationTargetException);
                throw sSLPeerUnverifiedException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        public boolean equals(Object other) {
            return other instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }
}

