/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;

final class Jdk9Platform
extends Platform {
    final Method setProtocolMethod;
    final Method getProtocolMethod;

    Jdk9Platform(Method setProtocolMethod, Method getProtocolMethod) {
        this.setProtocolMethod = setProtocolMethod;
        this.getProtocolMethod = getProtocolMethod;
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        try {
            SSLParameters sSLParameters = sslSocket.getSSLParameters();
            List<String> list = Jdk9Platform.alpnProtocolNames(protocols);
            this.setProtocolMethod.invoke((Object)sSLParameters, new Object[]{list.toArray(new String[list.size()])});
            sslSocket.setSSLParameters(sSLParameters);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw Util.assertionError("unable to set ssl parameters", reflectiveOperationException);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket socket) {
        try {
            String string = (String)this.getProtocolMethod.invoke((Object)socket, new Object[0]);
            if (string == null || string.equals("")) {
                return null;
            }
            return string;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw Util.assertionError("unable to get selected protocols", reflectiveOperationException);
        }
    }

    @Override
    public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        throw new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on JDK 9+");
    }

    public static Jdk9Platform buildIfSupported() {
        try {
            Method method = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            Method method2 = SSLSocket.class.getMethod("getApplicationProtocol", new Class[0]);
            return new Jdk9Platform(method, method2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

