/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.net.ssl.SSLSocket;
import okhttp3.Protocol;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;

class JdkWithJettyBootPlatform
extends Platform {
    private final Method putMethod;
    private final Method getMethod;
    private final Method removeMethod;
    private final Class<?> clientProviderClass;
    private final Class<?> serverProviderClass;

    JdkWithJettyBootPlatform(Method putMethod, Method getMethod, Method removeMethod, Class<?> clientProviderClass, Class<?> serverProviderClass) {
        this.putMethod = putMethod;
        this.getMethod = getMethod;
        this.removeMethod = removeMethod;
        this.clientProviderClass = clientProviderClass;
        this.serverProviderClass = serverProviderClass;
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        List<String> list = JdkWithJettyBootPlatform.alpnProtocolNames(protocols);
        try {
            Object object = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JettyNegoProvider(list));
            this.putMethod.invoke(null, sslSocket, object);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw Util.assertionError("unable to set alpn", reflectiveOperationException);
        }
    }

    @Override
    public void afterHandshake(SSLSocket sslSocket) {
        try {
            this.removeMethod.invoke(null, sslSocket);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw Util.assertionError("unable to remove alpn", reflectiveOperationException);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket socket) {
        try {
            JettyNegoProvider jettyNegoProvider = (JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, socket));
            if (!jettyNegoProvider.unsupported && jettyNegoProvider.selected == null) {
                Platform.get().log(4, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", null);
                return null;
            }
            return jettyNegoProvider.unsupported ? null : jettyNegoProvider.selected;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw Util.assertionError("unable to get selected protocol", reflectiveOperationException);
        }
    }

    public static Platform buildIfSupported() {
        try {
            String string = "org.eclipse.jetty.alpn.ALPN";
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = Class.forName(string + "$Provider");
            Class<?> clazz3 = Class.forName(string + "$ClientProvider");
            Class<?> clazz4 = Class.forName(string + "$ServerProvider");
            Method method = clazz.getMethod("put", SSLSocket.class, clazz2);
            Method method2 = clazz.getMethod("get", SSLSocket.class);
            Method method3 = clazz.getMethod("remove", SSLSocket.class);
            return new JdkWithJettyBootPlatform(method, method2, method3, clazz3, clazz4);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }

    private static class JettyNegoProvider
    implements InvocationHandler {
        private final List<String> protocols;
        boolean unsupported;
        String selected;

        JettyNegoProvider(List<String> protocols) {
            this.protocols = protocols;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String string = method.getName();
            Class<?> clazz = method.getReturnType();
            if (args == null) {
                args = Util.EMPTY_STRING_ARRAY;
            }
            if (string.equals("supports") && Boolean.TYPE == clazz) {
                return true;
            }
            if (string.equals("unsupported") && Void.TYPE == clazz) {
                this.unsupported = true;
                return null;
            }
            if (string.equals("protocols") && args.length == 0) {
                return this.protocols;
            }
            if ((string.equals("selectProtocol") || string.equals("select")) && String.class == clazz && args.length == 1 && args[0] instanceof List) {
                List list = (List)args[0];
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (!this.protocols.contains(list.get(i))) continue;
                    this.selected = (String)list.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((string.equals("protocolSelected") || string.equals("selected")) && args.length == 1) {
                this.selected = (String)args[0];
                return null;
            }
            return method.invoke((Object)this, args);
        }
    }
}

