/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class OptionalMethod<T> {
    private final Class<?> returnType;
    private final String methodName;
    private final Class[] methodParams;

    OptionalMethod(Class<?> returnType, String methodName, Class ... methodParams) {
        this.returnType = returnType;
        this.methodName = methodName;
        this.methodParams = methodParams;
    }

    public boolean isSupported(T target) {
        return this.getMethod(target.getClass()) != null;
    }

    public Object invokeOptional(T target, Object ... args) {
        Method method = this.getMethod(target.getClass());
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public Object invokeOptionalWithoutCheckedException(T target, Object ... args) {
        try {
            return this.invokeOptional(target, args);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            AssertionError assertionError = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)assertionError)).initCause(throwable);
            throw assertionError;
        }
    }

    public Object invoke(T target, Object ... args) {
        Method method = this.getMethod(target.getClass());
        if (method == null) {
            throw new AssertionError((Object)("Method " + this.methodName + " not supported for object " + target));
        }
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException illegalAccessException) {
            AssertionError assertionError = new AssertionError((Object)("Unexpectedly could not call: " + method));
            ((Throwable)((Object)assertionError)).initCause(illegalAccessException);
            throw assertionError;
        }
    }

    public Object invokeWithoutCheckedException(T target, Object ... args) {
        try {
            return this.invoke(target, args);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            AssertionError assertionError = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)assertionError)).initCause(throwable);
            throw assertionError;
        }
    }

    private Method getMethod(Class<?> clazz) {
        Method method = null;
        if (this.methodName != null && (method = OptionalMethod.getPublicMethod(clazz, this.methodName, this.methodParams)) != null && this.returnType != null && !this.returnType.isAssignableFrom(method.getReturnType())) {
            method = null;
        }
        return method;
    }

    private static Method getPublicMethod(Class<?> clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
            if ((method.getModifiers() & 1) == 0) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }
}

