/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.platform.JdkWithJettyBootPlatform;
import okhttp3.internal.tls.BasicCertificateChainCleaner;
import okhttp3.internal.tls.BasicTrustRootIndex;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import okio.Buffer;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    public static final int INFO = 4;
    public static final int WARN = 5;
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    protected X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        try {
            Class<?> clazz = Class.forName("sun.security.ssl.SSLContextImpl");
            Object obj = Platform.readFieldOrNull(sslSocketFactory, clazz, "context");
            if (obj == null) {
                return null;
            }
            return Platform.readFieldOrNull(obj, X509TrustManager.class, "trustManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
    }

    public void afterHandshake(SSLSocket sslSocket) {
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) {
        socket.connect(address, connectTimeout);
    }

    public void log(int level, String message, Throwable t) {
        Level level2 = level == 5 ? Level.WARNING : Level.INFO;
        logger.log(level2, message, t);
    }

    public boolean isCleartextTrafficPermitted(String hostname) {
        return true;
    }

    public Object getStackTraceForCloseable(String closer) {
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(closer);
        }
        return null;
    }

    public void logCloseableLeak(String message, Object stackTrace) {
        if (stackTrace == null) {
            message = message + " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);";
        }
        this.log(5, message, (Throwable)stackTrace);
    }

    public static List<String> alpnProtocolNames(List<Protocol> protocols) {
        ArrayList<String> arrayList = new ArrayList<String>(protocols.size());
        int n = protocols.size();
        for (int i = 0; i < n; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            arrayList.add(protocol.toString());
        }
        return arrayList;
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(trustManager));
    }

    public CertificateChainCleaner buildCertificateChainCleaner(SSLSocketFactory sslSocketFactory) {
        X509TrustManager x509TrustManager = this.trustManager(sslSocketFactory);
        if (x509TrustManager == null) {
            throw new IllegalStateException("Unable to extract the trust manager on " + Platform.get() + ", sslSocketFactory is " + sslSocketFactory.getClass());
        }
        return this.buildCertificateChainCleaner(x509TrustManager);
    }

    private static Platform findPlatform() {
        Platform platform = AndroidPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        Jdk9Platform jdk9Platform = Jdk9Platform.buildIfSupported();
        if (jdk9Platform != null) {
            return jdk9Platform;
        }
        Platform platform2 = JdkWithJettyBootPlatform.buildIfSupported();
        if (platform2 != null) {
            return platform2;
        }
        return new Platform();
    }

    static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        Buffer buffer = new Buffer();
        int n = protocols.size();
        for (int i = 0; i < n; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            buffer.writeByte(protocol.toString().length());
            buffer.writeUtf8(protocol.toString());
        }
        return buffer.readByteArray();
    }

    static <T> T readFieldOrNull(Object instance, Class<T> fieldType, String fieldName) {
        Object object;
        for (object = instance.getClass(); object != Object.class; object = ((Class)object).getSuperclass()) {
            try {
                Field field = ((Class)object).getDeclaredField(fieldName);
                field.setAccessible(true);
                Object object2 = field.get(instance);
                if (object2 == null || !fieldType.isInstance(object2)) {
                    return null;
                }
                return fieldType.cast(object2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
        if (!fieldName.equals("delegate") && (object = Platform.readFieldOrNull(instance, Object.class, "delegate")) != null) {
            return Platform.readFieldOrNull(object, fieldType, fieldName);
        }
        return null;
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        return new BasicTrustRootIndex(trustManager.getAcceptedIssuers());
    }
}

