/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;

public final class PublicSuffixDatabase {
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    private static final byte[] WILDCARD_LABEL = new byte[]{42};
    private static final String[] EMPTY_RULE = new String[0];
    private static final String[] PREVAILING_RULE = new String[]{"*"};
    private static final byte EXCEPTION_MARKER = 33;
    private static final PublicSuffixDatabase instance = new PublicSuffixDatabase();
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;

    public static PublicSuffixDatabase get() {
        return instance;
    }

    public String getEffectiveTldPlusOne(String domain) {
        String[] stringArray;
        if (domain == null) {
            throw new NullPointerException("domain == null");
        }
        String string = IDN.toUnicode(domain);
        String[] stringArray2 = string.split("\\.");
        if (stringArray2.length == (stringArray = this.findMatchingRule(stringArray2)).length && stringArray[0].charAt(0) != '!') {
            return null;
        }
        int n = stringArray[0].charAt(0) == '!' ? stringArray2.length - stringArray.length : stringArray2.length - (stringArray.length + 1);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray3 = domain.split("\\.");
        for (int i = n; i < stringArray3.length; ++i) {
            stringBuilder.append(stringArray3[i]).append('.');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findMatchingRule(String[] domainLabels) {
        Object object;
        int n;
        Object object2;
        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
            this.readTheListUninterruptibly();
        } else {
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Object object3 = this;
        synchronized (object3) {
            if (this.publicSuffixListBytes == null) {
                throw new IllegalStateException("Unable to load publicsuffixes.gz resource from the classpath.");
            }
        }
        object3 = new byte[domainLabels.length][];
        for (int i = 0; i < domainLabels.length; ++i) {
            object3[i] = domainLabels[i].getBytes(Util.UTF_8);
        }
        String string = null;
        for (int i = 0; i < ((Object)object3).length; ++i) {
            object2 = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, (byte[][])object3, i);
            if (object2 == null) continue;
            string = object2;
            break;
        }
        Object object4 = null;
        if (((Object)object3).length > 1) {
            object2 = (byte[][])object3.clone();
            for (n = 0; n < ((Object)object2).length - 1; ++n) {
                object2[n] = WILDCARD_LABEL;
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, (byte[][])object2, n);
                if (object == null) continue;
                object4 = object;
                break;
            }
        }
        object2 = null;
        if (object4 != null) {
            for (n = 0; n < ((Object)object3).length - 1; ++n) {
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixExceptionListBytes, (byte[][])object3, n);
                if (object == null) continue;
                object2 = object;
                break;
            }
        }
        if (object2 != null) {
            object2 = "!" + (String)object2;
            return object2.split("\\.");
        }
        if (string == null && object4 == null) {
            return PREVAILING_RULE;
        }
        String[] stringArray = string != null ? string.split("\\.") : EMPTY_RULE;
        object = object4 != null ? object4.split("\\.") : EMPTY_RULE;
        return stringArray.length > ((String[])object).length ? stringArray : object;
    }

    private static String binarySearchBytes(byte[] bytesToSearch, byte[][] labels, int labelIndex) {
        int n = 0;
        int n2 = bytesToSearch.length;
        String string = null;
        while (n < n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            for (n6 = (n + n2) / 2; n6 > -1 && bytesToSearch[n6] != 10; --n6) {
            }
            ++n6;
            int n7 = 1;
            while (bytesToSearch[n6 + n7] != 10) {
                ++n7;
            }
            int n8 = n6 + n7 - n6;
            int n9 = labelIndex;
            int n10 = 0;
            int n11 = 0;
            boolean bl = false;
            while (true) {
                if (bl) {
                    n5 = 46;
                    bl = false;
                } else {
                    n5 = labels[n9][n10] & 0xFF;
                }
                n4 = bytesToSearch[n6 + n11] & 0xFF;
                n3 = n5 - n4;
                if (n3 != 0) break;
                ++n10;
                if (++n11 == n8) break;
                if (labels[n9].length != n10) continue;
                if (n9 == labels.length - 1) break;
                ++n9;
                n10 = -1;
                bl = true;
            }
            if (n3 < 0) {
                n2 = n6 - 1;
                continue;
            }
            if (n3 > 0) {
                n = n6 + n7 + 1;
                continue;
            }
            n5 = n8 - n11;
            n4 = labels[n9].length - n10;
            for (int i = n9 + 1; i < labels.length; ++i) {
                n4 += labels[i].length;
            }
            if (n4 < n5) {
                n2 = n6 - 1;
                continue;
            }
            if (n4 > n5) {
                n = n6 + n7 + 1;
                continue;
            }
            string = new String(bytesToSearch, n6, n8, Util.UTF_8);
            break;
        }
        return string;
    }

    private void readTheListUninterruptibly() {
        boolean bl = false;
        while (true) {
            try {
                this.readTheList();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                bl = true;
                continue;
            }
            catch (IOException iOException) {
                Platform.get().log(5, "Failed to read public suffix list", iOException);
                return;
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTheList() {
        byte[] byArray;
        byte[] byArray2;
        InputStream inputStream = PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
        if (inputStream == null) {
            return;
        }
        BufferedSource bufferedSource = Okio.buffer(new GzipSource(Okio.source(inputStream)));
        try {
            int n = bufferedSource.readInt();
            byArray2 = new byte[n];
            bufferedSource.readFully(byArray2);
            int n2 = bufferedSource.readInt();
            byArray = new byte[n2];
            bufferedSource.readFully(byArray);
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
        PublicSuffixDatabase publicSuffixDatabase = this;
        synchronized (publicSuffixDatabase) {
            this.publicSuffixListBytes = byArray2;
            this.publicSuffixExceptionListBytes = byArray;
        }
        this.readCompleteLatch.countDown();
    }

    void setListBytes(byte[] publicSuffixListBytes, byte[] publicSuffixExceptionListBytes) {
        this.publicSuffixListBytes = publicSuffixListBytes;
        this.publicSuffixExceptionListBytes = publicSuffixExceptionListBytes;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }
}

