/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import okhttp3.internal.tls.TrustRootIndex;

public final class BasicTrustRootIndex
implements TrustRootIndex {
    private final Map<X500Principal, Set<X509Certificate>> subjectToCaCerts = new LinkedHashMap<X500Principal, Set<X509Certificate>>();

    public BasicTrustRootIndex(X509Certificate ... caCerts) {
        for (X509Certificate x509Certificate : caCerts) {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            Set<X509Certificate> set = this.subjectToCaCerts.get(x500Principal);
            if (set == null) {
                set = new LinkedHashSet<X509Certificate>(1);
                this.subjectToCaCerts.put(x500Principal, set);
            }
            set.add(x509Certificate);
        }
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate cert) {
        X500Principal x500Principal = cert.getIssuerX500Principal();
        Set<X509Certificate> set = this.subjectToCaCerts.get(x500Principal);
        if (set == null) {
            return null;
        }
        for (X509Certificate x509Certificate : set) {
            PublicKey publicKey = x509Certificate.getPublicKey();
            try {
                cert.verify(publicKey);
                return x509Certificate;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof BasicTrustRootIndex && ((BasicTrustRootIndex)other).subjectToCaCerts.equals(this.subjectToCaCerts);
    }

    public int hashCode() {
        return this.subjectToCaCerts.hashCode();
    }
}

