/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import javax.security.auth.x500.X500Principal;

final class DistinguishedNameParser {
    private final String dn;
    private final int length;
    private int pos;
    private int beg;
    private int end;
    private int cur;
    private char[] chars;

    DistinguishedNameParser(X500Principal principal) {
        this.dn = principal.getName("RFC2253");
        this.length = this.dn.length();
    }

    private String nextAT() {
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.pos == this.length) {
            return null;
        }
        this.beg = this.pos++;
        while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] != ' ') {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        this.end = this.pos;
        if (this.chars[this.pos] == ' ') {
            while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] == ' ') {
                ++this.pos;
            }
            if (this.chars[this.pos] != '=' || this.pos == this.length) {
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
        }
        ++this.pos;
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (!(this.end - this.beg <= 4 || this.chars[this.beg + 3] != '.' || this.chars[this.beg] != 'O' && this.chars[this.beg] != 'o' || this.chars[this.beg + 1] != 'I' && this.chars[this.beg + 1] != 'i' || this.chars[this.beg + 2] != 'D' && this.chars[this.beg + 2] != 'd')) {
            this.beg += 4;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String quotedAV() {
        ++this.pos;
        this.end = this.beg = this.pos;
        while (true) {
            if (this.pos == this.length) {
                throw new IllegalStateException("Unexpected end of DN: " + this.dn);
            }
            if (this.chars[this.pos] == '\"') {
                ++this.pos;
                break;
            }
            this.chars[this.end] = this.chars[this.pos] == '\\' ? this.getEscaped() : this.chars[this.pos];
            ++this.pos;
            ++this.end;
        }
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String hexAV() {
        if (this.pos + 4 >= this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        this.beg = this.pos++;
        while (true) {
            if (this.pos == this.length || this.chars[this.pos] == '+' || this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                this.end = this.pos;
                break;
            }
            if (this.chars[this.pos] == ' ') {
                this.end = this.pos++;
                while (this.pos < this.length && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
                break;
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                int n = this.pos;
                this.chars[n] = (char)(this.chars[n] + 32);
            }
            ++this.pos;
        }
        int n = this.end - this.beg;
        if (n < 5 || (n & 1) == 0) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        byte[] byArray = new byte[n / 2];
        int n2 = this.beg + 1;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)this.getByte(n2);
            n2 += 2;
        }
        return new String(this.chars, this.beg, n);
    }

    private String escapedAV() {
        this.beg = this.pos;
        this.end = this.pos;
        block5: while (this.pos < this.length) {
            switch (this.chars[this.pos]) {
                case '+': 
                case ',': 
                case ';': {
                    return new String(this.chars, this.beg, this.end - this.beg);
                }
                case '\\': {
                    this.chars[this.end++] = this.getEscaped();
                    ++this.pos;
                    continue block5;
                }
                case ' ': {
                    this.cur = this.end;
                    ++this.pos;
                    this.chars[this.end++] = 32;
                    while (this.pos < this.length && this.chars[this.pos] == ' ') {
                        this.chars[this.end++] = 32;
                        ++this.pos;
                    }
                    if (this.pos != this.length && this.chars[this.pos] != ',' && this.chars[this.pos] != '+' && this.chars[this.pos] != ';') continue block5;
                    return new String(this.chars, this.beg, this.cur - this.beg);
                }
            }
            this.chars[this.end++] = this.chars[this.pos];
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private char getEscaped() {
        ++this.pos;
        if (this.pos == this.length) {
            throw new IllegalStateException("Unexpected end of DN: " + this.dn);
        }
        switch (this.chars[this.pos]) {
            case ' ': 
            case '\"': 
            case '#': 
            case '%': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': 
            case '_': {
                return this.chars[this.pos];
            }
        }
        return this.getUTF8();
    }

    private char getUTF8() {
        int n = this.getByte(this.pos);
        ++this.pos;
        if (n < 128) {
            return (char)n;
        }
        if (n >= 192 && n <= 247) {
            int n2;
            if (n <= 223) {
                n2 = 1;
                n &= 0x1F;
            } else if (n <= 239) {
                n2 = 2;
                n &= 0xF;
            } else {
                n2 = 3;
                n &= 7;
            }
            for (int i = 0; i < n2; ++i) {
                ++this.pos;
                if (this.pos == this.length || this.chars[this.pos] != '\\') {
                    return '?';
                }
                ++this.pos;
                int n3 = this.getByte(this.pos);
                ++this.pos;
                if ((n3 & 0xC0) != 128) {
                    return '?';
                }
                n = (n << 6) + (n3 & 0x3F);
            }
            return (char)n;
        }
        return '?';
    }

    private int getByte(int position) {
        if (position + 1 >= this.length) {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        int n = this.chars[position];
        if (n >= 48 && n <= 57) {
            n -= 48;
        } else if (n >= 97 && n <= 102) {
            n -= 87;
        } else if (n >= 65 && n <= 70) {
            n -= 55;
        } else {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        int n2 = this.chars[position + 1];
        if (n2 >= 48 && n2 <= 57) {
            n2 -= 48;
        } else if (n2 >= 97 && n2 <= 102) {
            n2 -= 87;
        } else if (n2 >= 65 && n2 <= 70) {
            n2 -= 55;
        } else {
            throw new IllegalStateException("Malformed DN: " + this.dn);
        }
        return (n << 4) + n2;
    }

    public String findMostSpecific(String attributeType) {
        this.pos = 0;
        this.beg = 0;
        this.end = 0;
        this.cur = 0;
        this.chars = this.dn.toCharArray();
        String string = this.nextAT();
        if (string == null) {
            return null;
        }
        do {
            String string2 = "";
            if (this.pos == this.length) {
                return null;
            }
            switch (this.chars[this.pos]) {
                case '\"': {
                    string2 = this.quotedAV();
                    break;
                }
                case '#': {
                    string2 = this.hexAV();
                    break;
                }
                case '+': 
                case ',': 
                case ';': {
                    break;
                }
                default: {
                    string2 = this.escapedAV();
                }
            }
            if (attributeType.equalsIgnoreCase(string)) {
                return string2;
            }
            if (this.pos >= this.length) {
                return null;
            }
            if (this.chars[this.pos] != ',' && this.chars[this.pos] != ';' && this.chars[this.pos] != '+') {
                throw new IllegalStateException("Malformed DN: " + this.dn);
            }
            ++this.pos;
        } while ((string = this.nextAT()) != null);
        throw new IllegalStateException("Malformed DN: " + this.dn);
    }
}

