/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import okhttp3.internal.Util;
import okhttp3.internal.tls.DistinguishedNameParser;

public final class OkHostnameVerifier
implements HostnameVerifier {
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    private OkHostnameVerifier() {
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        try {
            Certificate[] certificateArray = session.getPeerCertificates();
            return this.verify(host, (X509Certificate)certificateArray[0]);
        }
        catch (SSLException sSLException) {
            return false;
        }
    }

    public boolean verify(String host, X509Certificate certificate) {
        return Util.verifyAsIpAddress(host) ? this.verifyIpAddress(host, certificate) : this.verifyHostname(host, certificate);
    }

    private boolean verifyIpAddress(String ipAddress, X509Certificate certificate) {
        List<String> list = OkHostnameVerifier.getSubjectAltNames(certificate, 7);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!ipAddress.equalsIgnoreCase(list.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean verifyHostname(String hostname, X509Certificate certificate) {
        X500Principal x500Principal;
        String string;
        hostname = hostname.toLowerCase(Locale.US);
        boolean bl = false;
        List<String> list = OkHostnameVerifier.getSubjectAltNames(certificate, 2);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            bl = true;
            if (!this.verifyHostname(hostname, list.get(i))) continue;
            return true;
        }
        if (!bl && (string = new DistinguishedNameParser(x500Principal = certificate.getSubjectX500Principal()).findMostSpecific("cn")) != null) {
            return this.verifyHostname(hostname, string);
        }
        return false;
    }

    public static List<String> allSubjectAltNames(X509Certificate certificate) {
        List<String> list = OkHostnameVerifier.getSubjectAltNames(certificate, 7);
        List<String> list2 = OkHostnameVerifier.getSubjectAltNames(certificate, 2);
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    private static List<String> getSubjectAltNames(X509Certificate certificate, int type) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Collection<List<?>> collection = certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return Collections.emptyList();
            }
            for (List<?> list : collection) {
                String string;
                Integer n;
                List<?> list2 = list;
                if (list2 == null || list2.size() < 2 || (n = (Integer)list2.get(0)) == null || n != type || (string = (String)list2.get(1)) == null) continue;
                arrayList.add(string);
            }
            return arrayList;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    public boolean verifyHostname(String hostname, String pattern) {
        if (hostname == null || hostname.length() == 0 || hostname.startsWith(".") || hostname.endsWith("..")) {
            return false;
        }
        if (pattern == null || pattern.length() == 0 || pattern.startsWith(".") || pattern.endsWith("..")) {
            return false;
        }
        if (!hostname.endsWith(".")) {
            hostname = hostname + '.';
        }
        if (!pattern.endsWith(".")) {
            pattern = pattern + '.';
        }
        if (!(pattern = pattern.toLowerCase(Locale.US)).contains("*")) {
            return hostname.equals(pattern);
        }
        if (!pattern.startsWith("*.") || pattern.indexOf(42, 1) != -1) {
            return false;
        }
        if (hostname.length() < pattern.length()) {
            return false;
        }
        if ("*.".equals(pattern)) {
            return false;
        }
        String string = pattern.substring(1);
        if (!hostname.endsWith(string)) {
            return false;
        }
        int n = hostname.length() - string.length();
        return n <= 0 || hostname.lastIndexOf(46, n - 1) == -1;
    }
}

