/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.connection.StreamAllocation;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader;
import okhttp3.internal.ws.WebSocketWriter;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;

public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    private static final List<Protocol> ONLY_HTTP1 = Collections.singletonList(Protocol.HTTP_1_1);
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    private final Request originalRequest;
    final WebSocketListener listener;
    private final Random random;
    private final String key;
    private Call call;
    private final Runnable writerRunnable;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private ScheduledExecutorService executor;
    private Streams streams;
    private final ArrayDeque<ByteString> pongQueue = new ArrayDeque();
    private final ArrayDeque<Object> messageAndCloseQueue = new ArrayDeque();
    private long queueSize;
    private boolean enqueuedClose;
    private ScheduledFuture<?> cancelFuture;
    private int receivedCloseCode = -1;
    private String receivedCloseReason;
    private boolean failed;
    int pingCount;
    int pongCount;

    public RealWebSocket(Request request, WebSocketListener listener, Random random) {
        if (!"GET".equals(request.method())) {
            throw new IllegalArgumentException("Request must be GET: " + request.method());
        }
        this.originalRequest = request;
        this.listener = listener;
        this.random = random;
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        this.key = ByteString.of(byArray).base64();
        this.writerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    while (RealWebSocket.this.writeOneFrame()) {
                    }
                }
                catch (IOException iOException) {
                    RealWebSocket.this.failWebSocket(iOException, null);
                }
            }
        };
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    public void connect(OkHttpClient client) {
        client = client.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        final int n = client.pingIntervalMillis();
        final Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        this.call = Internal.instance.newWebSocketCall(client, request);
        this.call.enqueue(new Callback(){

            @Override
            public void onResponse(Call call, Response response) {
                try {
                    RealWebSocket.this.checkResponse(response);
                }
                catch (ProtocolException protocolException) {
                    RealWebSocket.this.failWebSocket(protocolException, response);
                    Util.closeQuietly(response);
                    return;
                }
                StreamAllocation streamAllocation = Internal.instance.streamAllocation(call);
                streamAllocation.noNewStreams();
                Streams streams = streamAllocation.connection().newWebSocketStreams(streamAllocation);
                try {
                    RealWebSocket.this.listener.onOpen(RealWebSocket.this, response);
                    String string = "OkHttp WebSocket " + request.url().redact();
                    RealWebSocket.this.initReaderAndWriter(string, n, streams);
                    streamAllocation.connection().socket().setSoTimeout(0);
                    RealWebSocket.this.loopReader();
                }
                catch (Exception exception) {
                    RealWebSocket.this.failWebSocket(exception, null);
                }
            }

            @Override
            public void onFailure(Call call, IOException e2) {
                RealWebSocket.this.failWebSocket(e2, null);
            }
        });
    }

    void checkResponse(Response response) {
        if (response.code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + response.code() + " " + response.message() + "'");
        }
        String string = response.header("Connection");
        if (!"Upgrade".equalsIgnoreCase(string)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + string + "'");
        }
        String string2 = response.header("Upgrade");
        if (!"websocket".equalsIgnoreCase(string2)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + string2 + "'");
        }
        String string3 = response.header("Sec-WebSocket-Accept");
        String string4 = ByteString.encodeUtf8(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
        if (!string4.equals(string3)) {
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + string4 + "' but was '" + string3 + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initReaderAndWriter(String name, long pingIntervalMillis, Streams streams) {
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            this.streams = streams;
            this.writer = new WebSocketWriter(streams.client, streams.sink, this.random);
            this.executor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(name, false));
            if (pingIntervalMillis != 0L) {
                this.executor.scheduleAtFixedRate(new PingRunnable(), pingIntervalMillis, pingIntervalMillis, TimeUnit.MILLISECONDS);
            }
            if (!this.messageAndCloseQueue.isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(streams.client, streams.source, this);
    }

    public void loopReader() {
        while (this.receivedCloseCode == -1) {
            this.reader.processNextFrame();
        }
    }

    boolean processNextFrame() {
        try {
            this.reader.processNextFrame();
            return this.receivedCloseCode == -1;
        }
        catch (Exception exception) {
            this.failWebSocket(exception, null);
            return false;
        }
    }

    void awaitTermination(int timeout, TimeUnit timeUnit) {
        this.executor.awaitTermination(timeout, timeUnit);
    }

    void tearDown() {
        if (this.cancelFuture != null) {
            this.cancelFuture.cancel(false);
        }
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    synchronized int pingCount() {
        return this.pingCount;
    }

    synchronized int pongCount() {
        return this.pongCount;
    }

    @Override
    public void onReadMessage(String text) {
        this.listener.onMessage((WebSocket)this, text);
    }

    @Override
    public void onReadMessage(ByteString bytes) {
        this.listener.onMessage((WebSocket)this, bytes);
    }

    @Override
    public synchronized void onReadPing(ByteString payload) {
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add(payload);
        this.runWriter();
        ++this.pingCount;
    }

    @Override
    public synchronized void onReadPong(ByteString buffer) {
        ++this.pongCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadClose(int code, String reason) {
        if (code == -1) {
            throw new IllegalArgumentException();
        }
        Streams streams = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.receivedCloseCode != -1) {
                throw new IllegalStateException("already closed");
            }
            this.receivedCloseCode = code;
            this.receivedCloseReason = reason;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                streams = this.streams;
                this.streams = null;
                if (this.cancelFuture != null) {
                    this.cancelFuture.cancel(false);
                }
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onClosing(this, code, reason);
            if (streams != null) {
                this.listener.onClosed(this, code, reason);
            }
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    @Override
    public boolean send(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        return this.send(ByteString.encodeUtf8(text), 1);
    }

    @Override
    public boolean send(ByteString bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        return this.send(bytes, 2);
    }

    private synchronized boolean send(ByteString data, int formatOpcode) {
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)data.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)data.size();
        this.messageAndCloseQueue.add(new Message(formatOpcode, data));
        this.runWriter();
        return true;
    }

    synchronized boolean pong(ByteString payload) {
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return false;
        }
        this.pongQueue.add(payload);
        this.runWriter();
        return true;
    }

    @Override
    public boolean close(int code, String reason) {
        return this.close(code, reason, 60000L);
    }

    synchronized boolean close(int code, String reason, long cancelAfterCloseMillis) {
        WebSocketProtocol.validateCloseCode(code);
        ByteString byteString = null;
        if (reason != null && (long)(byteString = ByteString.encodeUtf8(reason)).size() > 123L) {
            throw new IllegalArgumentException("reason.size() > 123: " + reason);
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new Close(code, byteString, cancelAfterCloseMillis));
        this.runWriter();
        return true;
    }

    private void runWriter() {
        assert (Thread.holdsLock(this));
        if (this.executor != null) {
            this.executor.execute(this.writerRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeOneFrame() {
        ByteString byteString;
        WebSocketWriter webSocketWriter;
        Object object = null;
        int n = -1;
        String string = null;
        Streams streams = null;
        Object object2 = this;
        synchronized (object2) {
            if (this.failed) {
                return false;
            }
            webSocketWriter = this.writer;
            byteString = this.pongQueue.poll();
            if (byteString == null) {
                object = this.messageAndCloseQueue.poll();
                if (object instanceof Close) {
                    n = this.receivedCloseCode;
                    string = this.receivedCloseReason;
                    if (n != -1) {
                        streams = this.streams;
                        this.streams = null;
                        this.executor.shutdown();
                    } else {
                        this.cancelFuture = this.executor.schedule(new CancelRunnable(), ((Close)object).cancelAfterCloseMillis, TimeUnit.MILLISECONDS);
                    }
                } else if (object == null) {
                    return false;
                }
            }
        }
        try {
            if (byteString != null) {
                webSocketWriter.writePong(byteString);
            } else if (object instanceof Message) {
                object2 = ((Message)object).data;
                BufferedSink bufferedSink = Okio.buffer(webSocketWriter.newMessageSink(((Message)object).formatOpcode, ((ByteString)object2).size()));
                bufferedSink.write((ByteString)object2);
                bufferedSink.close();
                RealWebSocket realWebSocket = this;
                synchronized (realWebSocket) {
                    this.queueSize -= (long)((ByteString)object2).size();
                }
            } else if (object instanceof Close) {
                object2 = (Close)object;
                webSocketWriter.writeClose(((Close)object2).code, ((Close)object2).reason);
                if (streams != null) {
                    this.listener.onClosed(this, n, string);
                }
            } else {
                throw new AssertionError();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePingFrame() {
        WebSocketWriter webSocketWriter;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            webSocketWriter = this.writer;
        }
        try {
            webSocketWriter.writePing(ByteString.EMPTY);
        }
        catch (IOException iOException) {
            this.failWebSocket(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failWebSocket(Exception e2, @Nullable Response response) {
        Streams streams;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            this.failed = true;
            streams = this.streams;
            this.streams = null;
            if (this.cancelFuture != null) {
                this.cancelFuture.cancel(false);
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        try {
            this.listener.onFailure(this, e2, response);
        }
        finally {
            Util.closeQuietly(streams);
        }
    }

    final class CancelRunnable
    implements Runnable {
        CancelRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.cancel();
        }
    }

    public static abstract class Streams
    implements Closeable {
        public final boolean client;
        public final BufferedSource source;
        public final BufferedSink sink;

        public Streams(boolean client, BufferedSource source, BufferedSink sink) {
            this.client = client;
            this.source = source;
            this.sink = sink;
        }
    }

    static final class Close {
        final int code;
        final ByteString reason;
        final long cancelAfterCloseMillis;

        Close(int code, ByteString reason, long cancelAfterCloseMillis) {
            this.code = code;
            this.reason = reason;
            this.cancelAfterCloseMillis = cancelAfterCloseMillis;
        }
    }

    static final class Message {
        final int formatOpcode;
        final ByteString data;

        Message(int formatOpcode, ByteString data) {
            this.formatOpcode = formatOpcode;
            this.data = data;
        }
    }

    private final class PingRunnable
    implements Runnable {
        PingRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.writePingFrame();
        }
    }
}

