/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

final class WebSocketReader {
    final boolean isClient;
    final BufferedSource source;
    final FrameCallback frameCallback;
    boolean closed;
    int opcode;
    long frameLength;
    long frameBytesRead;
    boolean isFinalFrame;
    boolean isControlFrame;
    boolean isMasked;
    final byte[] maskKey = new byte[4];
    final byte[] maskBuffer = new byte[8192];

    WebSocketReader(boolean isClient, BufferedSource source, FrameCallback frameCallback) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (frameCallback == null) {
            throw new NullPointerException("frameCallback == null");
        }
        this.isClient = isClient;
        this.source = source;
        this.frameCallback = frameCallback;
    }

    void processNextFrame() {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
        } else {
            this.readMessageFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHeader() {
        boolean bl;
        int n;
        if (this.closed) {
            throw new IOException("closed");
        }
        long l = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            n = this.source.readByte() & 0xFF;
        }
        finally {
            this.source.timeout().timeout(l, TimeUnit.NANOSECONDS);
        }
        this.opcode = n & 0xF;
        this.isFinalFrame = (n & 0x80) != 0;
        boolean bl2 = this.isControlFrame = (n & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean bl3 = (n & 0x40) != 0;
        boolean bl4 = (n & 0x20) != 0;
        boolean bl5 = bl = (n & 0x10) != 0;
        if (bl3 || bl4 || bl) {
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        int n2 = this.source.readByte() & 0xFF;
        boolean bl6 = this.isMasked = (n2 & 0x80) != 0;
        if (this.isMasked == this.isClient) {
            throw new ProtocolException(this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.frameLength = n2 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = (long)this.source.readShort() & 0xFFFFL;
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException("Frame length 0x" + Long.toHexString(this.frameLength) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        this.frameBytesRead = 0L;
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (this.isMasked) {
            this.source.readFully(this.maskKey);
        }
    }

    private void readControlFrame() {
        int n;
        Buffer buffer = new Buffer();
        if (this.frameBytesRead < this.frameLength) {
            if (this.isClient) {
                this.source.readFully(buffer, this.frameLength);
            } else {
                while (this.frameBytesRead < this.frameLength) {
                    n = (int)Math.min(this.frameLength - this.frameBytesRead, (long)this.maskBuffer.length);
                    int n2 = this.source.read(this.maskBuffer, 0, n);
                    if (n2 == -1) {
                        throw new EOFException();
                    }
                    WebSocketProtocol.toggleMask(this.maskBuffer, n2, this.maskKey, this.frameBytesRead);
                    buffer.write(this.maskBuffer, 0, n2);
                    this.frameBytesRead += (long)n2;
                }
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(buffer.readByteString());
                break;
            }
            case 10: {
                this.frameCallback.onReadPong(buffer.readByteString());
                break;
            }
            case 8: {
                n = 1005;
                String string = "";
                long l = buffer.size();
                if (l == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (l != 0L) {
                    n = buffer.readShort();
                    string = buffer.readUtf8();
                    String string2 = WebSocketProtocol.closeCodeExceptionMessage(n);
                    if (string2 != null) {
                        throw new ProtocolException(string2);
                    }
                }
                this.frameCallback.onReadClose(n, string);
                this.closed = true;
                break;
            }
            default: {
                throw new ProtocolException("Unknown control opcode: " + Integer.toHexString(this.opcode));
            }
        }
    }

    private void readMessageFrame() {
        int n = this.opcode;
        if (n != 1 && n != 2) {
            throw new ProtocolException("Unknown opcode: " + Integer.toHexString(n));
        }
        Buffer buffer = new Buffer();
        this.readMessage(buffer);
        if (n == 1) {
            this.frameCallback.onReadMessage(buffer.readUtf8());
        } else {
            this.frameCallback.onReadMessage(buffer.readByteString());
        }
    }

    void readUntilNonControlFrame() {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private void readMessage(Buffer sink) {
        while (true) {
            long l;
            if (this.closed) {
                throw new IOException("closed");
            }
            if (this.frameBytesRead == this.frameLength) {
                if (this.isFinalFrame) {
                    return;
                }
                this.readUntilNonControlFrame();
                if (this.opcode != 0) {
                    throw new ProtocolException("Expected continuation opcode. Got: " + Integer.toHexString(this.opcode));
                }
                if (this.isFinalFrame && this.frameLength == 0L) {
                    return;
                }
            }
            long l2 = this.frameLength - this.frameBytesRead;
            if (this.isMasked) {
                l = this.source.read(this.maskBuffer, 0, (int)(l2 = Math.min(l2, (long)this.maskBuffer.length)));
                if (l == -1L) {
                    throw new EOFException();
                }
                WebSocketProtocol.toggleMask(this.maskBuffer, l, this.maskKey, this.frameBytesRead);
                sink.write(this.maskBuffer, 0, (int)l);
            } else {
                l = this.source.read(sink, l2);
                if (l == -1L) {
                    throw new EOFException();
                }
            }
            this.frameBytesRead += l;
        }
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1);

        public void onReadMessage(ByteString var1);

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

