/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.util.Random;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Sink;
import okio.Timeout;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    boolean writerClosed;
    final Buffer buffer = new Buffer();
    final FrameSink frameSink = new FrameSink();
    boolean activeWriter;
    final byte[] maskKey;
    final byte[] maskBuffer;

    WebSocketWriter(boolean isClient, BufferedSink sink, Random random) {
        if (sink == null) {
            throw new NullPointerException("sink == null");
        }
        if (random == null) {
            throw new NullPointerException("random == null");
        }
        this.isClient = isClient;
        this.sink = sink;
        this.random = random;
        this.maskKey = isClient ? new byte[4] : null;
        this.maskBuffer = isClient ? new byte[8192] : null;
    }

    void writePing(ByteString payload) {
        this.writeControlFrame(9, payload);
    }

    void writePong(ByteString payload) {
        this.writeControlFrame(10, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClose(int code, ByteString reason) {
        ByteString byteString = ByteString.EMPTY;
        if (code != 0 || reason != null) {
            if (code != 0) {
                WebSocketProtocol.validateCloseCode(code);
            }
            Buffer buffer = new Buffer();
            buffer.writeShort(code);
            if (reason != null) {
                buffer.write(reason);
            }
            byteString = buffer.readByteString();
        }
        try {
            this.writeControlFrame(8, byteString);
        }
        finally {
            this.writerClosed = true;
        }
    }

    private void writeControlFrame(int opcode, ByteString payload) {
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n = payload.size();
        if ((long)n > 125L) {
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        int n2 = 0x80 | opcode;
        this.sink.writeByte(n2);
        int n3 = n;
        if (this.isClient) {
            this.sink.writeByte(n3 |= 0x80);
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            byte[] byArray = payload.toByteArray();
            WebSocketProtocol.toggleMask(byArray, byArray.length, this.maskKey, 0L);
            this.sink.write(byArray);
        } else {
            this.sink.writeByte(n3);
            this.sink.write(payload);
        }
        this.sink.flush();
    }

    Sink newMessageSink(int formatOpcode, long contentLength) {
        if (this.activeWriter) {
            throw new IllegalStateException("Another message writer is active. Did you call close()?");
        }
        this.activeWriter = true;
        this.frameSink.formatOpcode = formatOpcode;
        this.frameSink.contentLength = contentLength;
        this.frameSink.isFirstFrame = true;
        this.frameSink.closed = false;
        return this.frameSink;
    }

    void writeMessageFrame(int formatOpcode, long byteCount, boolean isFirstFrame, boolean isFinal) {
        int n;
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int n2 = n = isFirstFrame ? formatOpcode : 0;
        if (isFinal) {
            n |= 0x80;
        }
        this.sink.writeByte(n);
        int n3 = 0;
        if (this.isClient) {
            n3 |= 0x80;
        }
        if (byteCount <= 125L) {
            this.sink.writeByte(n3 |= (int)byteCount);
        } else if (byteCount <= 65535L) {
            this.sink.writeByte(n3 |= 0x7E);
            this.sink.writeShort((int)byteCount);
        } else {
            this.sink.writeByte(n3 |= 0x7F);
            this.sink.writeLong(byteCount);
        }
        if (this.isClient) {
            int n4;
            this.random.nextBytes(this.maskKey);
            this.sink.write(this.maskKey);
            for (long i = 0L; i < byteCount; i += (long)n4) {
                int n5 = (int)Math.min(byteCount, (long)this.maskBuffer.length);
                n4 = this.buffer.read(this.maskBuffer, 0, n5);
                if (n4 == -1) {
                    throw new AssertionError();
                }
                WebSocketProtocol.toggleMask(this.maskBuffer, n4, this.maskKey, i);
                this.sink.write(this.maskBuffer, 0, n4);
            }
        } else {
            this.sink.write(this.buffer, byteCount);
        }
        this.sink.emit();
    }

    final class FrameSink
    implements Sink {
        int formatOpcode;
        long contentLength;
        boolean isFirstFrame;
        boolean closed;

        FrameSink() {
        }

        @Override
        public void write(Buffer source, long byteCount) {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.buffer.write(source, byteCount);
            boolean bl = this.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
            long l = WebSocketWriter.this.buffer.completeSegmentByteCount();
            if (l > 0L && !bl) {
                WebSocketWriter.this.writeMessageFrame(this.formatOpcode, l, this.isFirstFrame, false);
                this.isFirstFrame = false;
            }
        }

        @Override
        public void flush() {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, false);
            this.isFirstFrame = false;
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        @Override
        public void close() {
            if (this.closed) {
                throw new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.buffer.size(), this.isFirstFrame, true);
            this.closed = true;
            WebSocketWriter.this.activeWriter = false;
        }
    }
}

