/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.Segment;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

public class AsyncTimeout
extends Timeout {
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final long IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    @Nullable
    static AsyncTimeout head;
    private boolean inQueue;
    @Nullable
    private AsyncTimeout next;
    private long timeoutAt;

    public final void enter() {
        if (this.inQueue) {
            throw new IllegalStateException("Unbalanced enter/exit");
        }
        long l = this.timeoutNanos();
        boolean bl = this.hasDeadline();
        if (l == 0L && !bl) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.scheduleTimeout(this, l, bl);
    }

    private static synchronized void scheduleTimeout(AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
        if (head == null) {
            head = new AsyncTimeout();
            new Watchdog().start();
        }
        long l = System.nanoTime();
        if (timeoutNanos != 0L && hasDeadline) {
            node.timeoutAt = l + Math.min(timeoutNanos, node.deadlineNanoTime() - l);
        } else if (timeoutNanos != 0L) {
            node.timeoutAt = l + timeoutNanos;
        } else if (hasDeadline) {
            node.timeoutAt = node.deadlineNanoTime();
        } else {
            throw new AssertionError();
        }
        long l2 = node.remainingNanos(l);
        AsyncTimeout asyncTimeout = head;
        while (true) {
            if (asyncTimeout.next == null || l2 < asyncTimeout.next.remainingNanos(l)) {
                node.next = asyncTimeout.next;
                asyncTimeout.next = node;
                if (asyncTimeout != head) break;
                AsyncTimeout.class.notify();
                break;
            }
            asyncTimeout = asyncTimeout.next;
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    private static synchronized boolean cancelScheduledTimeout(AsyncTimeout node) {
        AsyncTimeout asyncTimeout = head;
        while (asyncTimeout != null) {
            if (asyncTimeout.next == node) {
                asyncTimeout.next = node.next;
                node.next = null;
                return false;
            }
            asyncTimeout = asyncTimeout.next;
        }
        return true;
    }

    private long remainingNanos(long now) {
        return this.timeoutAt - now;
    }

    protected void timedOut() {
    }

    public final Sink sink(final Sink sink) {
        return new Sink(){

            @Override
            public void write(Buffer source, long byteCount) {
                Util.checkOffsetAndCount(source.size, 0L, byteCount);
                while (byteCount > 0L) {
                    long l = 0L;
                    Segment segment = source.head;
                    while (l < 65536L) {
                        int n = source.head.limit - source.head.pos;
                        if ((l += (long)n) >= byteCount) {
                            l = byteCount;
                            break;
                        }
                        segment = segment.next;
                    }
                    boolean bl = false;
                    AsyncTimeout.this.enter();
                    try {
                        sink.write(source, l);
                        byteCount -= l;
                        bl = true;
                    }
                    catch (IOException iOException) {
                        throw AsyncTimeout.this.exit(iOException);
                    }
                    finally {
                        AsyncTimeout.this.exit(bl);
                    }
                }
            }

            @Override
            public void flush() {
                boolean bl = false;
                AsyncTimeout.this.enter();
                try {
                    sink.flush();
                    bl = true;
                }
                catch (IOException iOException) {
                    throw AsyncTimeout.this.exit(iOException);
                }
                finally {
                    AsyncTimeout.this.exit(bl);
                }
            }

            @Override
            public void close() {
                boolean bl = false;
                AsyncTimeout.this.enter();
                try {
                    sink.close();
                    bl = true;
                }
                catch (IOException iOException) {
                    throw AsyncTimeout.this.exit(iOException);
                }
                finally {
                    AsyncTimeout.this.exit(bl);
                }
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return "AsyncTimeout.sink(" + sink + ")";
            }
        };
    }

    public final Source source(final Source source) {
        return new Source(){

            @Override
            public long read(Buffer sink, long byteCount) {
                boolean bl = false;
                AsyncTimeout.this.enter();
                try {
                    long l = source.read(sink, byteCount);
                    bl = true;
                    long l2 = l;
                    return l2;
                }
                catch (IOException iOException) {
                    throw AsyncTimeout.this.exit(iOException);
                }
                finally {
                    AsyncTimeout.this.exit(bl);
                }
            }

            @Override
            public void close() {
                boolean bl = false;
                try {
                    source.close();
                    bl = true;
                }
                catch (IOException iOException) {
                    throw AsyncTimeout.this.exit(iOException);
                }
                finally {
                    AsyncTimeout.this.exit(bl);
                }
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return "AsyncTimeout.source(" + source + ")";
            }
        };
    }

    final void exit(boolean throwOnTimeout) {
        boolean bl = this.exit();
        if (bl && throwOnTimeout) {
            throw this.newTimeoutException(null);
        }
    }

    final IOException exit(IOException cause) {
        if (!this.exit()) {
            return cause;
        }
        return this.newTimeoutException(cause);
    }

    protected IOException newTimeoutException(@Nullable IOException cause) {
        InterruptedIOException interruptedIOException = new InterruptedIOException("timeout");
        if (cause != null) {
            interruptedIOException.initCause(cause);
        }
        return interruptedIOException;
    }

    @Nullable
    static AsyncTimeout awaitTimeout() {
        AsyncTimeout asyncTimeout = AsyncTimeout.head.next;
        if (asyncTimeout == null) {
            long l = System.nanoTime();
            AsyncTimeout.class.wait(IDLE_TIMEOUT_MILLIS);
            return AsyncTimeout.head.next == null && System.nanoTime() - l >= IDLE_TIMEOUT_NANOS ? head : null;
        }
        long l = asyncTimeout.remainingNanos(System.nanoTime());
        if (l > 0L) {
            long l2 = l / 1000000L;
            AsyncTimeout.class.wait(l2, (int)(l -= l2 * 1000000L));
            return null;
        }
        AsyncTimeout.head.next = asyncTimeout.next;
        asyncTimeout.next = null;
        return asyncTimeout;
    }

    private static final class Watchdog
    extends Thread {
        Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Class<AsyncTimeout> clazz = AsyncTimeout.class;
                        // MONITORENTER : okio.AsyncTimeout.class
                        AsyncTimeout asyncTimeout = AsyncTimeout.awaitTimeout();
                        if (asyncTimeout == null) {
                            // MONITOREXIT : clazz
                            continue;
                        }
                        if (asyncTimeout == head) {
                            head = null;
                            // MONITOREXIT : clazz
                            return;
                        }
                        // MONITOREXIT : clazz
                        asyncTimeout.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

