/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.UnsupportedEncodingException;

final class Base64 {
    private static final byte[] MAP = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_MAP = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};

    private Base64() {
    }

    public static byte[] decode(String in) {
        int n;
        char c2;
        int n2;
        for (n2 = in.length(); n2 > 0 && ((c2 = in.charAt(n2 - 1)) == '=' || c2 == '\n' || c2 == '\r' || c2 == ' ' || c2 == '\t'); --n2) {
        }
        byte[] byArray = new byte[(int)((long)n2 * 6L / 8L)];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            int n6;
            char c3 = in.charAt(n);
            if (c3 >= 'A' && c3 <= 'Z') {
                n6 = c3 - 65;
            } else if (c3 >= 'a' && c3 <= 'z') {
                n6 = c3 - 71;
            } else if (c3 >= '0' && c3 <= '9') {
                n6 = c3 + 4;
            } else if (c3 == '+' || c3 == '-') {
                n6 = 62;
            } else if (c3 == '/' || c3 == '_') {
                n6 = 63;
            } else {
                if (c3 == '\n' || c3 == '\r' || c3 == ' ' || c3 == '\t') continue;
                return null;
            }
            n5 = n5 << 6 | (byte)n6;
            if (++n4 % 4 != 0) continue;
            byArray[n3++] = (byte)(n5 >> 16);
            byArray[n3++] = (byte)(n5 >> 8);
            byArray[n3++] = (byte)n5;
        }
        n = n4 % 4;
        if (n == 1) {
            return null;
        }
        if (n == 2) {
            byArray[n3++] = (byte)((n5 <<= 12) >> 16);
        } else if (n == 3) {
            byArray[n3++] = (byte)((n5 <<= 6) >> 16);
            byArray[n3++] = (byte)(n5 >> 8);
        }
        if (n3 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public static String encode(byte[] in) {
        return Base64.encode(in, MAP);
    }

    public static String encodeUrl(byte[] in) {
        return Base64.encode(in, URL_MAP);
    }

    private static String encode(byte[] in, byte[] map) {
        int n = (in.length + 2) / 3 * 4;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = in.length - in.length % 3;
        for (int i = 0; i < n3; i += 3) {
            byArray[n2++] = map[(in[i] & 0xFF) >> 2];
            byArray[n2++] = map[(in[i] & 3) << 4 | (in[i + 1] & 0xFF) >> 4];
            byArray[n2++] = map[(in[i + 1] & 0xF) << 2 | (in[i + 2] & 0xFF) >> 6];
            byArray[n2++] = map[in[i + 2] & 0x3F];
        }
        switch (in.length % 3) {
            case 1: {
                byArray[n2++] = map[(in[n3] & 0xFF) >> 2];
                byArray[n2++] = map[(in[n3] & 3) << 4];
                byArray[n2++] = 61;
                byArray[n2++] = 61;
                break;
            }
            case 2: {
                byArray[n2++] = map[(in[n3] & 0xFF) >> 2];
                byArray[n2++] = map[(in[n3] & 3) << 4 | (in[n3 + 1] & 0xFF) >> 4];
                byArray[n2++] = map[(in[n3 + 1] & 0xF) << 2];
                byArray[n2++] = 61;
            }
        }
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }
}

