/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Segment;
import okio.SegmentPool;
import okio.SegmentedByteString;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

public final class Buffer
implements Cloneable,
BufferedSink,
BufferedSource {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int REPLACEMENT_CHARACTER = 65533;
    @Nullable
    Segment head;
    long size;

    public long size() {
        return this.size;
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int b2) {
                Buffer.this.writeByte((byte)b2);
            }

            @Override
            public void write(byte[] data, int offset, int byteCount) {
                Buffer.this.write(data, offset, byteCount);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".outputStream()";
            }
        };
    }

    @Override
    public Buffer emitCompleteSegments() {
        return this;
    }

    @Override
    public BufferedSink emit() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long byteCount) {
        if (this.size < byteCount) {
            throw new EOFException();
        }
    }

    @Override
    public boolean request(long byteCount) {
        return this.size >= byteCount;
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() {
                if (Buffer.this.size > 0L) {
                    return Buffer.this.readByte() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] sink, int offset, int byteCount) {
                return Buffer.this.read(sink, offset, byteCount);
            }

            @Override
            public int available() {
                return (int)Math.min(Buffer.this.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".inputStream()";
            }
        };
    }

    public Buffer copyTo(OutputStream out) {
        return this.copyTo(out, 0L, this.size);
    }

    public Buffer copyTo(OutputStream out, long offset, long byteCount) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, offset, byteCount);
        if (byteCount == 0L) {
            return this;
        }
        Segment segment = this.head;
        while (offset >= (long)(segment.limit - segment.pos)) {
            offset -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (byteCount > 0L) {
            int n = (int)((long)segment.pos + offset);
            int n2 = (int)Math.min((long)(segment.limit - n), byteCount);
            out.write(segment.data, n, n2);
            byteCount -= (long)n2;
            offset = 0L;
            segment = segment.next;
        }
        return this;
    }

    public Buffer copyTo(Buffer out, long offset, long byteCount) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, offset, byteCount);
        if (byteCount == 0L) {
            return this;
        }
        out.size += byteCount;
        Segment segment = this.head;
        while (offset >= (long)(segment.limit - segment.pos)) {
            offset -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (byteCount > 0L) {
            Segment segment2 = new Segment(segment);
            segment2.pos = (int)((long)segment2.pos + offset);
            segment2.limit = Math.min(segment2.pos + (int)byteCount, segment2.limit);
            if (out.head == null) {
                segment2.next = segment2.prev = segment2;
                out.head = segment2.prev;
            } else {
                out.head.prev.push(segment2);
            }
            byteCount -= (long)(segment2.limit - segment2.pos);
            offset = 0L;
            segment = segment.next;
        }
        return this;
    }

    public Buffer writeTo(OutputStream out) {
        return this.writeTo(out, this.size);
    }

    public Buffer writeTo(OutputStream out, long byteCount) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        Segment segment = this.head;
        while (byteCount > 0L) {
            int n = (int)Math.min(byteCount, (long)(segment.limit - segment.pos));
            out.write(segment.data, segment.pos, n);
            segment.pos += n;
            this.size -= (long)n;
            byteCount -= (long)n;
            if (segment.pos != segment.limit) continue;
            Segment segment2 = segment;
            this.head = segment = segment2.pop();
            SegmentPool.recycle(segment2);
        }
        return this;
    }

    public Buffer readFrom(InputStream in) {
        this.readFrom(in, Long.MAX_VALUE, true);
        return this;
    }

    public Buffer readFrom(InputStream in, long byteCount) {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        this.readFrom(in, byteCount, false);
        return this;
    }

    private void readFrom(InputStream in, long byteCount, boolean forever) {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        while (byteCount > 0L || forever) {
            Segment segment = this.writableSegment(1);
            int n = (int)Math.min(byteCount, (long)(8192 - segment.limit));
            int n2 = in.read(segment.data, segment.limit, n);
            if (n2 == -1) {
                if (forever) {
                    return;
                }
                throw new EOFException();
            }
            segment.limit += n2;
            this.size += (long)n2;
            byteCount -= (long)n2;
        }
    }

    public long completeSegmentByteCount() {
        long l = this.size;
        if (l == 0L) {
            return 0L;
        }
        Segment segment = this.head.prev;
        if (segment.limit < 8192 && segment.owner) {
            l -= (long)(segment.limit - segment.pos);
        }
        return l;
    }

    @Override
    public byte readByte() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        Segment segment = this.head;
        int n = segment.pos;
        int n2 = segment.limit;
        byte[] byArray = segment.data;
        byte by = byArray[n++];
        --this.size;
        if (n == n2) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n;
        }
        return by;
    }

    public byte getByte(long pos) {
        Util.checkOffsetAndCount(this.size, pos, 1L);
        Segment segment = this.head;
        int n;
        while (pos >= (long)(n = segment.limit - segment.pos)) {
            pos -= (long)n;
            segment = segment.next;
        }
        return segment.data[segment.pos + (int)pos];
    }

    @Override
    public short readShort() {
        if (this.size < 2L) {
            throw new IllegalStateException("size < 2: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 2) {
            int n3 = (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            return (short)n3;
        }
        byte[] byArray = segment.data;
        int n4 = (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.size -= 2L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return (short)n4;
    }

    @Override
    public int readInt() {
        if (this.size < 4L) {
            throw new IllegalStateException("size < 4: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] byArray = segment.data;
        int n3 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.size -= 4L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return n3;
    }

    @Override
    public long readLong() {
        if (this.size < 8L) {
            throw new IllegalStateException("size < 8: " + this.size);
        }
        Segment segment = this.head;
        int n = segment.limit;
        int n2 = segment.pos;
        if (n - n2 < 8) {
            return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        byte[] byArray = segment.data;
        long l = ((long)byArray[n2++] & 0xFFL) << 56 | ((long)byArray[n2++] & 0xFFL) << 48 | ((long)byArray[n2++] & 0xFFL) << 40 | ((long)byArray[n2++] & 0xFFL) << 32 | ((long)byArray[n2++] & 0xFFL) << 24 | ((long)byArray[n2++] & 0xFFL) << 16 | ((long)byArray[n2++] & 0xFFL) << 8 | (long)byArray[n2++] & 0xFFL;
        this.size -= 8L;
        if (n2 == n) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return l;
    }

    @Override
    public short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public long readDecimalLong() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        long l = 0L;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        long l2 = -922337203685477580L;
        long l3 = -7L;
        do {
            Segment segment = this.head;
            byte[] byArray = segment.data;
            int n2 = segment.pos;
            int n3 = segment.limit;
            while (n2 < n3) {
                byte by = byArray[n2];
                if (by >= 48 && by <= 57) {
                    int n4 = 48 - by;
                    if (l < l2 || l == l2 && (long)n4 < l3) {
                        Buffer buffer = new Buffer().writeDecimalLong(l).writeByte(by);
                        if (!bl) {
                            buffer.readByte();
                        }
                        throw new NumberFormatException("Number too large: " + buffer.readUtf8());
                    }
                    l *= 10L;
                    l += (long)n4;
                } else if (by == 45 && n == 0) {
                    bl = true;
                    --l3;
                } else {
                    if (n == 0) {
                        throw new NumberFormatException("Expected leading [0-9] or '-' character but was 0x" + Integer.toHexString(by));
                    }
                    bl2 = true;
                    break;
                }
                ++n2;
                ++n;
            }
            if (n2 == n3) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n2;
        } while (!bl2 && this.head != null);
        this.size -= (long)n;
        return bl ? l : -l;
    }

    @Override
    public long readHexadecimalUnsignedLong() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        long l = 0L;
        int n = 0;
        boolean bl = false;
        do {
            Segment segment = this.head;
            byte[] byArray = segment.data;
            int n2 = segment.pos;
            int n3 = segment.limit;
            while (n2 < n3) {
                int n4;
                byte by = byArray[n2];
                if (by >= 48 && by <= 57) {
                    n4 = by - 48;
                } else if (by >= 97 && by <= 102) {
                    n4 = by - 97 + 10;
                } else if (by >= 65 && by <= 70) {
                    n4 = by - 65 + 10;
                } else {
                    if (n == 0) {
                        throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + Integer.toHexString(by));
                    }
                    bl = true;
                    break;
                }
                if ((l & 0xF000000000000000L) != 0L) {
                    Buffer buffer = new Buffer().writeHexadecimalUnsignedLong(l).writeByte(by);
                    throw new NumberFormatException("Number too large: " + buffer.readUtf8());
                }
                l <<= 4;
                l |= (long)n4;
                ++n2;
                ++n;
            }
            if (n2 == n3) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
                continue;
            }
            segment.pos = n2;
        } while (!bl && this.head != null);
        this.size -= (long)n;
        return l;
    }

    @Override
    public ByteString readByteString() {
        return new ByteString(this.readByteArray());
    }

    @Override
    public ByteString readByteString(long byteCount) {
        return new ByteString(this.readByteArray(byteCount));
    }

    @Override
    public int select(Options options) {
        Segment segment = this.head;
        if (segment == null) {
            return options.indexOf(ByteString.EMPTY);
        }
        ByteString[] byteStringArray = options.byteStrings;
        int n = byteStringArray.length;
        for (int i = 0; i < n; ++i) {
            ByteString byteString = byteStringArray[i];
            if (this.size < (long)byteString.size() || !this.rangeEquals(segment, segment.pos, byteString, 0, byteString.size())) continue;
            try {
                this.skip(byteString.size());
                return i;
            }
            catch (EOFException eOFException) {
                throw new AssertionError((Object)eOFException);
            }
        }
        return -1;
    }

    int selectPrefix(Options options) {
        Segment segment = this.head;
        ByteString[] byteStringArray = options.byteStrings;
        int n = byteStringArray.length;
        for (int i = 0; i < n; ++i) {
            ByteString byteString = byteStringArray[i];
            int n2 = (int)Math.min(this.size, (long)byteString.size());
            if (n2 != 0 && !this.rangeEquals(segment, segment.pos, byteString, 0, n2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void readFully(Buffer sink, long byteCount) {
        if (this.size < byteCount) {
            sink.write(this, this.size);
            throw new EOFException();
        }
        sink.write(this, byteCount);
    }

    @Override
    public long readAll(Sink sink) {
        long l = this.size;
        if (l > 0L) {
            sink.write(this, l);
        }
        return l;
    }

    @Override
    public String readUtf8() {
        try {
            return this.readString(this.size, Util.UTF_8);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readUtf8(long byteCount) {
        return this.readString(byteCount, Util.UTF_8);
    }

    @Override
    public String readString(Charset charset) {
        try {
            return this.readString(this.size, charset);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readString(long byteCount, Charset charset) {
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + byteCount);
        }
        if (byteCount == 0L) {
            return "";
        }
        Segment segment = this.head;
        if ((long)segment.pos + byteCount > (long)segment.limit) {
            return new String(this.readByteArray(byteCount), charset);
        }
        String string = new String(segment.data, segment.pos, (int)byteCount, charset);
        segment.pos = (int)((long)segment.pos + byteCount);
        this.size -= byteCount;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return string;
    }

    @Override
    @Nullable
    public String readUtf8Line() {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            return this.size != 0L ? this.readUtf8(this.size) : null;
        }
        return this.readUtf8Line(l);
    }

    @Override
    public String readUtf8LineStrict() {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit < 0: " + limit);
        }
        long l = limit == Long.MAX_VALUE ? Long.MAX_VALUE : limit + 1L;
        long l2 = this.indexOf((byte)10, 0L, l);
        if (l2 != -1L) {
            return this.readUtf8Line(l2);
        }
        if (l < this.size() && this.getByte(l - 1L) == 13 && this.getByte(l) == 10) {
            return this.readUtf8Line(l);
        }
        Buffer buffer = new Buffer();
        this.copyTo(buffer, 0L, Math.min(32L, this.size()));
        throw new EOFException("\\n not found: limit=" + Math.min(this.size(), limit) + " content=" + buffer.readByteString().hex() + '\u2026');
    }

    String readUtf8Line(long newline) {
        if (newline > 0L && this.getByte(newline - 1L) == 13) {
            String string = this.readUtf8(newline - 1L);
            this.skip(2L);
            return string;
        }
        String string = this.readUtf8(newline);
        this.skip(1L);
        return string;
    }

    @Override
    public int readUtf8CodePoint() {
        int n;
        int n2;
        int n3;
        if (this.size == 0L) {
            throw new EOFException();
        }
        byte by = this.getByte(0L);
        if ((by & 0x80) == 0) {
            n3 = by & 0x7F;
            n2 = 1;
            n = 0;
        } else if ((by & 0xE0) == 192) {
            n3 = by & 0x1F;
            n2 = 2;
            n = 128;
        } else if ((by & 0xF0) == 224) {
            n3 = by & 0xF;
            n2 = 3;
            n = 2048;
        } else if ((by & 0xF8) == 240) {
            n3 = by & 7;
            n2 = 4;
            n = 65536;
        } else {
            this.skip(1L);
            return 65533;
        }
        if (this.size < (long)n2) {
            throw new EOFException("size < " + n2 + ": " + this.size + " (to read code point prefixed 0x" + Integer.toHexString(by) + ")");
        }
        for (int i = 1; i < n2; ++i) {
            byte by2 = this.getByte(i);
            if ((by2 & 0xC0) == 128) {
                n3 <<= 6;
                n3 |= by2 & 0x3F;
                continue;
            }
            this.skip(i);
            return 65533;
        }
        this.skip(n2);
        if (n3 > 0x10FFFF) {
            return 65533;
        }
        if (n3 >= 55296 && n3 <= 57343) {
            return 65533;
        }
        if (n3 < n) {
            return 65533;
        }
        return n3;
    }

    @Override
    public byte[] readByteArray() {
        try {
            return this.readByteArray(this.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public byte[] readByteArray(long byteCount) {
        Util.checkOffsetAndCount(this.size, 0L, byteCount);
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + byteCount);
        }
        byte[] byArray = new byte[(int)byteCount];
        this.readFully(byArray);
        return byArray;
    }

    @Override
    public int read(byte[] sink) {
        return this.read(sink, 0, sink.length);
    }

    @Override
    public void readFully(byte[] sink) {
        int n;
        for (int i = 0; i < sink.length; i += n) {
            n = this.read(sink, i, sink.length - i);
            if (n != -1) continue;
            throw new EOFException();
        }
    }

    @Override
    public int read(byte[] sink, int offset, int byteCount) {
        Util.checkOffsetAndCount(sink.length, offset, byteCount);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        int n = Math.min(byteCount, segment.limit - segment.pos);
        System.arraycopy(segment.data, segment.pos, sink, offset, n);
        segment.pos += n;
        this.size -= (long)n;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n;
    }

    public void clear() {
        try {
            this.skip(this.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public void skip(long byteCount) {
        while (byteCount > 0L) {
            if (this.head == null) {
                throw new EOFException();
            }
            int n = (int)Math.min(byteCount, (long)(this.head.limit - this.head.pos));
            this.size -= (long)n;
            byteCount -= (long)n;
            this.head.pos += n;
            if (this.head.pos != this.head.limit) continue;
            Segment segment = this.head;
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    @Override
    public Buffer write(ByteString byteString) {
        if (byteString == null) {
            throw new IllegalArgumentException("byteString == null");
        }
        byteString.write(this);
        return this;
    }

    @Override
    public Buffer writeUtf8(String string) {
        return this.writeUtf8(string, 0, string.length());
    }

    @Override
    public Buffer writeUtf8(String string, int beginIndex, int endIndex) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0: " + beginIndex);
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + endIndex + " < " + beginIndex);
        }
        if (endIndex > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + endIndex + " > " + string.length());
        }
        int n = beginIndex;
        while (n < endIndex) {
            char c2;
            char c3 = string.charAt(n);
            if (c3 < '\u0080') {
                Segment segment = this.writableSegment(1);
                byte[] byArray = segment.data;
                int n2 = segment.limit - n;
                int n3 = Math.min(endIndex, 8192 - n2);
                byArray[n2 + n++] = (byte)c3;
                while (n < n3 && (c3 = string.charAt(n)) < '\u0080') {
                    byArray[n2 + n++] = (byte)c3;
                }
                int n4 = n + n2 - segment.limit;
                segment.limit += n4;
                this.size += (long)n4;
                continue;
            }
            if (c3 < '\u0800') {
                this.writeByte(c3 >> 6 | 0xC0);
                this.writeByte(c3 & 0x3F | 0x80);
                ++n;
                continue;
            }
            if (c3 < '\ud800' || c3 > '\udfff') {
                this.writeByte(c3 >> 12 | 0xE0);
                this.writeByte(c3 >> 6 & 0x3F | 0x80);
                this.writeByte(c3 & 0x3F | 0x80);
                ++n;
                continue;
            }
            char c4 = c2 = n + 1 < endIndex ? string.charAt(n + 1) : (char)'\u0000';
            if (c3 > '\udbff' || c2 < '\udc00' || c2 > '\udfff') {
                this.writeByte(63);
                ++n;
                continue;
            }
            int n5 = 65536 + ((c3 & 0xFFFF27FF) << 10 | c2 & 0xFFFF23FF);
            this.writeByte(n5 >> 18 | 0xF0);
            this.writeByte(n5 >> 12 & 0x3F | 0x80);
            this.writeByte(n5 >> 6 & 0x3F | 0x80);
            this.writeByte(n5 & 0x3F | 0x80);
            n += 2;
        }
        return this;
    }

    @Override
    public Buffer writeUtf8CodePoint(int codePoint) {
        if (codePoint < 128) {
            this.writeByte(codePoint);
        } else if (codePoint < 2048) {
            this.writeByte(codePoint >> 6 | 0xC0);
            this.writeByte(codePoint & 0x3F | 0x80);
        } else if (codePoint < 65536) {
            if (codePoint >= 55296 && codePoint <= 57343) {
                this.writeByte(63);
            } else {
                this.writeByte(codePoint >> 12 | 0xE0);
                this.writeByte(codePoint >> 6 & 0x3F | 0x80);
                this.writeByte(codePoint & 0x3F | 0x80);
            }
        } else if (codePoint <= 0x10FFFF) {
            this.writeByte(codePoint >> 18 | 0xF0);
            this.writeByte(codePoint >> 12 & 0x3F | 0x80);
            this.writeByte(codePoint >> 6 & 0x3F | 0x80);
            this.writeByte(codePoint & 0x3F | 0x80);
        } else {
            throw new IllegalArgumentException("Unexpected code point: " + Integer.toHexString(codePoint));
        }
        return this;
    }

    @Override
    public Buffer writeString(String string, Charset charset) {
        return this.writeString(string, 0, string.length(), charset);
    }

    @Override
    public Buffer writeString(String string, int beginIndex, int endIndex, Charset charset) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (beginIndex < 0) {
            throw new IllegalAccessError("beginIndex < 0: " + beginIndex);
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + endIndex + " < " + beginIndex);
        }
        if (endIndex > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + endIndex + " > " + string.length());
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (charset.equals(Util.UTF_8)) {
            return this.writeUtf8(string, beginIndex, endIndex);
        }
        byte[] byArray = string.substring(beginIndex, endIndex).getBytes(charset);
        return this.write(byArray, 0, byArray.length);
    }

    @Override
    public Buffer write(byte[] source) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        return this.write(source, 0, source.length);
    }

    @Override
    public Buffer write(byte[] source, int offset, int byteCount) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        Util.checkOffsetAndCount(source.length, offset, byteCount);
        int n = offset + byteCount;
        while (offset < n) {
            Segment segment = this.writableSegment(1);
            int n2 = Math.min(n - offset, 8192 - segment.limit);
            System.arraycopy(source, offset, segment.data, segment.limit, n2);
            offset += n2;
            segment.limit += n2;
        }
        this.size += (long)byteCount;
        return this;
    }

    @Override
    public long writeAll(Source source) {
        long l;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long l2 = 0L;
        while ((l = source.read(this, 8192L)) != -1L) {
            l2 += l;
        }
        return l2;
    }

    @Override
    public BufferedSink write(Source source, long byteCount) {
        while (byteCount > 0L) {
            long l = source.read(this, byteCount);
            if (l == -1L) {
                throw new EOFException();
            }
            byteCount -= l;
        }
        return this;
    }

    @Override
    public Buffer writeByte(int b2) {
        Segment segment = this.writableSegment(1);
        segment.data[segment.limit++] = (byte)b2;
        ++this.size;
        return this;
    }

    @Override
    public Buffer writeShort(int s) {
        Segment segment = this.writableSegment(2);
        byte[] byArray = segment.data;
        int n = segment.limit;
        byArray[n++] = (byte)(s >>> 8 & 0xFF);
        byArray[n++] = (byte)(s & 0xFF);
        segment.limit = n;
        this.size += 2L;
        return this;
    }

    @Override
    public Buffer writeShortLe(int s) {
        return this.writeShort(Util.reverseBytesShort((short)s));
    }

    @Override
    public Buffer writeInt(int i) {
        Segment segment = this.writableSegment(4);
        byte[] byArray = segment.data;
        int n = segment.limit;
        byArray[n++] = (byte)(i >>> 24 & 0xFF);
        byArray[n++] = (byte)(i >>> 16 & 0xFF);
        byArray[n++] = (byte)(i >>> 8 & 0xFF);
        byArray[n++] = (byte)(i & 0xFF);
        segment.limit = n;
        this.size += 4L;
        return this;
    }

    @Override
    public Buffer writeIntLe(int i) {
        return this.writeInt(Util.reverseBytesInt(i));
    }

    @Override
    public Buffer writeLong(long v) {
        Segment segment = this.writableSegment(8);
        byte[] byArray = segment.data;
        int n = segment.limit;
        byArray[n++] = (byte)(v >>> 56 & 0xFFL);
        byArray[n++] = (byte)(v >>> 48 & 0xFFL);
        byArray[n++] = (byte)(v >>> 40 & 0xFFL);
        byArray[n++] = (byte)(v >>> 32 & 0xFFL);
        byArray[n++] = (byte)(v >>> 24 & 0xFFL);
        byArray[n++] = (byte)(v >>> 16 & 0xFFL);
        byArray[n++] = (byte)(v >>> 8 & 0xFFL);
        byArray[n++] = (byte)(v & 0xFFL);
        segment.limit = n;
        this.size += 8L;
        return this;
    }

    @Override
    public Buffer writeLongLe(long v) {
        return this.writeLong(Util.reverseBytesLong(v));
    }

    @Override
    public Buffer writeDecimalLong(long v) {
        int n;
        if (v == 0L) {
            return this.writeByte(48);
        }
        boolean bl = false;
        if (v < 0L) {
            if ((v = -v) < 0L) {
                return this.writeUtf8("-9223372036854775808");
            }
            bl = true;
        }
        int n2 = v < 100000000L ? (v < 10000L ? (v < 100L ? (v < 10L ? 1 : 2) : (v < 1000L ? 3 : 4)) : (v < 1000000L ? (v < 100000L ? 5 : 6) : (v < 10000000L ? 7 : 8))) : (v < 1000000000000L ? (v < 10000000000L ? (v < 1000000000L ? 9 : 10) : (v < 100000000000L ? 11 : 12)) : (v < 1000000000000000L ? (v < 10000000000000L ? 13 : (v < 100000000000000L ? 14 : 15)) : (v < 100000000000000000L ? (v < 10000000000000000L ? 16 : 17) : (n = v < 1000000000000000000L ? 18 : 19))));
        if (bl) {
            ++n;
        }
        Segment segment = this.writableSegment(n);
        byte[] byArray = segment.data;
        int n3 = segment.limit + n;
        while (v != 0L) {
            int n4 = (int)(v % 10L);
            byArray[--n3] = DIGITS[n4];
            v /= 10L;
        }
        if (bl) {
            byArray[--n3] = 45;
        }
        segment.limit += n;
        this.size += (long)n;
        return this;
    }

    @Override
    public Buffer writeHexadecimalUnsignedLong(long v) {
        if (v == 0L) {
            return this.writeByte(48);
        }
        int n = Long.numberOfTrailingZeros(Long.highestOneBit(v)) / 4 + 1;
        Segment segment = this.writableSegment(n);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        for (int i = segment.limit + n - 1; i >= n2; --i) {
            byArray[i] = DIGITS[(int)(v & 0xFL)];
            v >>>= 4;
        }
        segment.limit += n;
        this.size += (long)n;
        return this;
    }

    Segment writableSegment(int minimumCapacity) {
        if (minimumCapacity < 1 || minimumCapacity > 8192) {
            throw new IllegalArgumentException();
        }
        if (this.head == null) {
            this.head.next = this.head.prev = (this.head = SegmentPool.take());
            return this.head.prev;
        }
        Segment segment = this.head.prev;
        if (segment.limit + minimumCapacity > 8192 || !segment.owner) {
            segment = segment.push(SegmentPool.take());
        }
        return segment;
    }

    @Override
    public void write(Buffer source, long byteCount) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (source == this) {
            throw new IllegalArgumentException("source == this");
        }
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        while (byteCount > 0L) {
            Segment segment;
            if (byteCount < (long)(source.head.limit - source.head.pos)) {
                Segment segment2 = segment = this.head != null ? this.head.prev : null;
                if (segment != null && segment.owner && byteCount + (long)segment.limit - (long)(segment.shared ? 0 : segment.pos) <= 8192L) {
                    source.head.writeTo(segment, (int)byteCount);
                    source.size -= byteCount;
                    this.size += byteCount;
                    return;
                }
                source.head = source.head.split((int)byteCount);
            }
            segment = source.head;
            long l = segment.limit - segment.pos;
            source.head = segment.pop();
            if (this.head == null) {
                this.head.next = this.head.prev = (this.head = segment);
            } else {
                Segment segment3 = this.head.prev;
                segment3 = segment3.push(segment);
                segment3.compact();
            }
            source.size -= l;
            this.size += l;
            byteCount -= l;
        }
    }

    @Override
    public long read(Buffer sink, long byteCount) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (this.size == 0L) {
            return -1L;
        }
        if (byteCount > this.size) {
            byteCount = this.size;
        }
        sink.write(this, byteCount);
        return byteCount;
    }

    @Override
    public long indexOf(byte b2) {
        return this.indexOf(b2, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte b2, long fromIndex) {
        return this.indexOf(b2, fromIndex, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte b2, long fromIndex, long toIndex) {
        long l;
        if (fromIndex < 0L || toIndex < fromIndex) {
            throw new IllegalArgumentException(String.format("size=%s fromIndex=%s toIndex=%s", this.size, fromIndex, toIndex));
        }
        if (toIndex > this.size) {
            toIndex = this.size;
        }
        if (fromIndex == toIndex) {
            return -1L;
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - fromIndex < fromIndex) {
            for (l = this.size; l > fromIndex; l -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l2;
            l = 0L;
            while ((l2 = l + (long)(segment.limit - segment.pos)) < fromIndex) {
                segment = segment.next;
                l = l2;
            }
        }
        while (l < toIndex) {
            byte[] byArray = segment.data;
            int n = (int)Math.min((long)segment.limit, (long)segment.pos + toIndex - l);
            for (int i = (int)((long)segment.pos + fromIndex - l); i < n; ++i) {
                if (byArray[i] != b2) continue;
                return (long)(i - segment.pos) + l;
            }
            fromIndex = l += (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        return -1L;
    }

    @Override
    public long indexOf(ByteString bytes) {
        return this.indexOf(bytes, 0L);
    }

    @Override
    public long indexOf(ByteString bytes, long fromIndex) {
        long l;
        if (bytes.size() == 0) {
            throw new IllegalArgumentException("bytes is empty");
        }
        if (fromIndex < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - fromIndex < fromIndex) {
            for (l = this.size; l > fromIndex; l -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l2;
            l = 0L;
            while ((l2 = l + (long)(segment.limit - segment.pos)) < fromIndex) {
                segment = segment.next;
                l = l2;
            }
        }
        byte by = bytes.getByte(0);
        int n = bytes.size();
        long l3 = this.size - (long)n + 1L;
        while (l < l3) {
            byte[] byArray = segment.data;
            int n2 = (int)Math.min((long)segment.limit, (long)segment.pos + l3 - l);
            for (int i = (int)((long)segment.pos + fromIndex - l); i < n2; ++i) {
                if (byArray[i] != by || !this.rangeEquals(segment, i + 1, bytes, 1, n)) continue;
                return (long)(i - segment.pos) + l;
            }
            fromIndex = l += (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        return -1L;
    }

    @Override
    public long indexOfElement(ByteString targetBytes) {
        return this.indexOfElement(targetBytes, 0L);
    }

    @Override
    public long indexOfElement(ByteString targetBytes, long fromIndex) {
        long l;
        if (fromIndex < 0L) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        if (this.size - fromIndex < fromIndex) {
            for (l = this.size; l > fromIndex; l -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
        } else {
            long l2;
            l = 0L;
            while ((l2 = l + (long)(segment.limit - segment.pos)) < fromIndex) {
                segment = segment.next;
                l = l2;
            }
        }
        if (targetBytes.size() == 2) {
            byte by = targetBytes.getByte(0);
            byte by2 = targetBytes.getByte(1);
            while (l < this.size) {
                byte[] byArray = segment.data;
                int n = segment.limit;
                for (int i = (int)((long)segment.pos + fromIndex - l); i < n; ++i) {
                    byte by3 = byArray[i];
                    if (by3 != by && by3 != by2) continue;
                    return (long)(i - segment.pos) + l;
                }
                fromIndex = l += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        } else {
            byte[] byArray = targetBytes.internalArray();
            while (l < this.size) {
                byte[] byArray2 = segment.data;
                int n = segment.limit;
                for (int i = (int)((long)segment.pos + fromIndex - l); i < n; ++i) {
                    byte by = byArray2[i];
                    for (byte by4 : byArray) {
                        if (by != by4) continue;
                        return (long)(i - segment.pos) + l;
                    }
                }
                fromIndex = l += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        }
        return -1L;
    }

    @Override
    public boolean rangeEquals(long offset, ByteString bytes) {
        return this.rangeEquals(offset, bytes, 0, bytes.size());
    }

    @Override
    public boolean rangeEquals(long offset, ByteString bytes, int bytesOffset, int byteCount) {
        if (offset < 0L || bytesOffset < 0 || byteCount < 0 || this.size - offset < (long)byteCount || bytes.size() - bytesOffset < byteCount) {
            return false;
        }
        for (int i = 0; i < byteCount; ++i) {
            if (this.getByte(offset + (long)i) == bytes.getByte(bytesOffset + i)) continue;
            return false;
        }
        return true;
    }

    private boolean rangeEquals(Segment segment, int segmentPos, ByteString bytes, int bytesOffset, int bytesLimit) {
        int n = segment.limit;
        byte[] byArray = segment.data;
        for (int i = bytesOffset; i < bytesLimit; ++i) {
            if (segmentPos == n) {
                segment = segment.next;
                byArray = segment.data;
                segmentPos = segment.pos;
                n = segment.limit;
            }
            if (byArray[segmentPos] != bytes.getByte(i)) {
                return false;
            }
            ++segmentPos;
        }
        return true;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    List<Integer> segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.head.limit - this.head.pos);
        Segment segment = this.head.next;
        while (segment != this.head) {
            arrayList.add(segment.limit - segment.pos);
            segment = segment.next;
        }
        return arrayList;
    }

    public ByteString md5() {
        return this.digest("MD5");
    }

    public ByteString sha1() {
        return this.digest("SHA-1");
    }

    public ByteString sha256() {
        return this.digest("SHA-256");
    }

    public ByteString sha512() {
        return this.digest("SHA-512");
    }

    private ByteString digest(String algorithm) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            if (this.head != null) {
                messageDigest.update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
                Segment segment = this.head.next;
                while (segment != this.head) {
                    messageDigest.update(segment.data, segment.pos, segment.limit - segment.pos);
                    segment = segment.next;
                }
            }
            return ByteString.of(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    public ByteString hmacSha1(ByteString key) {
        return this.hmac("HmacSHA1", key);
    }

    public ByteString hmacSha256(ByteString key) {
        return this.hmac("HmacSHA256", key);
    }

    public ByteString hmacSha512(ByteString key) {
        return this.hmac("HmacSHA512", key);
    }

    private ByteString hmac(String algorithm, ByteString key) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            if (this.head != null) {
                mac.update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
                Segment segment = this.head.next;
                while (segment != this.head) {
                    mac.update(segment.data, segment.pos, segment.limit - segment.pos);
                    segment = segment.next;
                }
            }
            return ByteString.of(mac.doFinal());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    public boolean equals(Object o) {
        long l;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Buffer)) {
            return false;
        }
        Buffer buffer = (Buffer)o;
        if (this.size != buffer.size) {
            return false;
        }
        if (this.size == 0L) {
            return true;
        }
        Segment segment = this.head;
        Segment segment2 = buffer.head;
        int n = segment.pos;
        int n2 = segment2.pos;
        for (long i = 0L; i < this.size; i += l) {
            l = Math.min(segment.limit - n, segment2.limit - n2);
            int n3 = 0;
            while ((long)n3 < l) {
                if (segment.data[n++] != segment2.data[n2++]) {
                    return false;
                }
                ++n3;
            }
            if (n == segment.limit) {
                segment = segment.next;
                n = segment.pos;
            }
            if (n2 != segment2.limit) continue;
            segment2 = segment2.next;
            n2 = segment2.pos;
        }
        return true;
    }

    public int hashCode() {
        Segment segment = this.head;
        if (segment == null) {
            return 0;
        }
        int n = 1;
        do {
            int n2 = segment.limit;
            for (int i = segment.pos; i < n2; ++i) {
                n = 31 * n + segment.data[i];
            }
        } while ((segment = segment.next) != this.head);
        return n;
    }

    public String toString() {
        return this.snapshot().toString();
    }

    public Buffer clone() {
        Buffer buffer = new Buffer();
        if (this.size == 0L) {
            return buffer;
        }
        buffer.head.next = buffer.head.prev = (buffer.head = new Segment(this.head));
        Segment segment = this.head.next;
        while (segment != this.head) {
            buffer.head.prev.push(new Segment(segment));
            segment = segment.next;
        }
        buffer.size = this.size;
        return buffer;
    }

    public ByteString snapshot() {
        if (this.size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + this.size);
        }
        return this.snapshot((int)this.size);
    }

    public ByteString snapshot(int byteCount) {
        if (byteCount == 0) {
            return ByteString.EMPTY;
        }
        return new SegmentedByteString(this, byteCount);
    }
}

