/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Base64;
import okio.Buffer;
import okio.Util;

public class ByteString
implements Serializable,
Comparable<ByteString> {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = 1L;
    public static final ByteString EMPTY = ByteString.of(new byte[0]);
    final byte[] data;
    transient int hashCode;
    transient String utf8;

    ByteString(byte[] data) {
        this.data = data;
    }

    public static ByteString of(byte ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        return new ByteString((byte[])data.clone());
    }

    public static ByteString of(byte[] data, int offset, int byteCount) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        Util.checkOffsetAndCount(data.length, offset, byteCount);
        byte[] byArray = new byte[byteCount];
        System.arraycopy(data, offset, byArray, 0, byteCount);
        return new ByteString(byArray);
    }

    public static ByteString of(ByteBuffer data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        byte[] byArray = new byte[data.remaining()];
        data.get(byArray);
        return new ByteString(byArray);
    }

    public static ByteString encodeUtf8(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        ByteString byteString = new ByteString(s.getBytes(Util.UTF_8));
        byteString.utf8 = s;
        return byteString;
    }

    public static ByteString encodeString(String s, Charset charset) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return new ByteString(s.getBytes(charset));
    }

    public String utf8() {
        String string = this.utf8;
        return string != null ? string : (this.utf8 = new String(this.data, Util.UTF_8));
    }

    public String string(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return new String(this.data, charset);
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public ByteString md5() {
        return this.digest("MD5");
    }

    public ByteString sha1() {
        return this.digest("SHA-1");
    }

    public ByteString sha256() {
        return this.digest("SHA-256");
    }

    public ByteString sha512() {
        return this.digest("SHA-512");
    }

    private ByteString digest(String algorithm) {
        try {
            return ByteString.of(MessageDigest.getInstance(algorithm).digest(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public ByteString hmacSha1(ByteString key) {
        return this.hmac("HmacSHA1", key);
    }

    public ByteString hmacSha256(ByteString key) {
        return this.hmac("HmacSHA256", key);
    }

    public ByteString hmacSha512(ByteString key) {
        return this.hmac("HmacSHA512", key);
    }

    private ByteString hmac(String algorithm, ByteString key) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            return ByteString.of(mac.doFinal(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    public String base64Url() {
        return Base64.encodeUrl(this.data);
    }

    @Nullable
    public static ByteString decodeBase64(String base64) {
        if (base64 == null) {
            throw new IllegalArgumentException("base64 == null");
        }
        byte[] byArray = Base64.decode(base64);
        return byArray != null ? new ByteString(byArray) : null;
    }

    public String hex() {
        char[] cArray = new char[this.data.length * 2];
        int n = 0;
        for (byte by : this.data) {
            cArray[n++] = HEX_DIGITS[by >> 4 & 0xF];
            cArray[n++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static ByteString decodeHex(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("hex == null");
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Unexpected hex string: " + hex);
        }
        byte[] byArray = new byte[hex.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = ByteString.decodeHexDigit(hex.charAt(i * 2)) << 4;
            int n2 = ByteString.decodeHexDigit(hex.charAt(i * 2 + 1));
            byArray[i] = (byte)(n + n2);
        }
        return ByteString.of(byArray);
    }

    private static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c2);
    }

    public static ByteString read(InputStream in, int byteCount) {
        int n;
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (byteCount < 0) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        byte[] byArray = new byte[byteCount];
        for (int i = 0; i < byteCount; i += n) {
            n = in.read(byArray, i, byteCount - i);
            if (n != -1) continue;
            throw new EOFException();
        }
        return new ByteString(byArray);
    }

    public ByteString toAsciiLowercase() {
        for (int i = 0; i < this.data.length; ++i) {
            byte by = this.data[i];
            if (by < 65 || by > 90) continue;
            byte[] byArray = (byte[])this.data.clone();
            byArray[i++] = (byte)(by - -32);
            while (i < byArray.length) {
                by = byArray[i];
                if (by >= 65 && by <= 90) {
                    byArray[i] = (byte)(by - -32);
                }
                ++i;
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public ByteString toAsciiUppercase() {
        for (int i = 0; i < this.data.length; ++i) {
            byte by = this.data[i];
            if (by < 97 || by > 122) continue;
            byte[] byArray = (byte[])this.data.clone();
            byArray[i++] = (byte)(by - 32);
            while (i < byArray.length) {
                by = byArray[i];
                if (by >= 97 && by <= 122) {
                    byArray[i] = (byte)(by - 32);
                }
                ++i;
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public ByteString substring(int beginIndex) {
        return this.substring(beginIndex, this.data.length);
    }

    public ByteString substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0");
        }
        if (endIndex > this.data.length) {
            throw new IllegalArgumentException("endIndex > length(" + this.data.length + ")");
        }
        int n = endIndex - beginIndex;
        if (n < 0) {
            throw new IllegalArgumentException("endIndex < beginIndex");
        }
        if (beginIndex == 0 && endIndex == this.data.length) {
            return this;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, beginIndex, byArray, 0, n);
        return new ByteString(byArray);
    }

    public byte getByte(int pos) {
        return this.data[pos];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    byte[] internalArray() {
        return this.data;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public void write(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        out.write(this.data);
    }

    void write(Buffer buffer) {
        buffer.write(this.data, 0, this.data.length);
    }

    public boolean rangeEquals(int offset, ByteString other, int otherOffset, int byteCount) {
        return other.rangeEquals(otherOffset, this.data, offset, byteCount);
    }

    public boolean rangeEquals(int offset, byte[] other, int otherOffset, int byteCount) {
        return offset >= 0 && offset <= this.data.length - byteCount && otherOffset >= 0 && otherOffset <= other.length - byteCount && Util.arrayRangeEquals(this.data, offset, other, otherOffset, byteCount);
    }

    public final boolean startsWith(ByteString prefix) {
        return this.rangeEquals(0, prefix, 0, prefix.size());
    }

    public final boolean startsWith(byte[] prefix) {
        return this.rangeEquals(0, prefix, 0, prefix.length);
    }

    public final boolean endsWith(ByteString suffix) {
        return this.rangeEquals(this.size() - suffix.size(), suffix, 0, suffix.size());
    }

    public final boolean endsWith(byte[] suffix) {
        return this.rangeEquals(this.size() - suffix.length, suffix, 0, suffix.length);
    }

    public final int indexOf(ByteString other) {
        return this.indexOf(other.internalArray(), 0);
    }

    public final int indexOf(ByteString other, int fromIndex) {
        return this.indexOf(other.internalArray(), fromIndex);
    }

    public final int indexOf(byte[] other) {
        return this.indexOf(other, 0);
    }

    public int indexOf(byte[] other, int fromIndex) {
        int n = this.data.length - other.length;
        for (int i = fromIndex = Math.max(fromIndex, 0); i <= n; ++i) {
            if (!Util.arrayRangeEquals(this.data, i, other, 0, other.length)) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(ByteString other) {
        return this.lastIndexOf(other.internalArray(), this.size());
    }

    public final int lastIndexOf(ByteString other, int fromIndex) {
        return this.lastIndexOf(other.internalArray(), fromIndex);
    }

    public final int lastIndexOf(byte[] other) {
        return this.lastIndexOf(other, this.size());
    }

    public int lastIndexOf(byte[] other, int fromIndex) {
        for (int i = fromIndex = Math.min(fromIndex, this.data.length - other.length); i >= 0; --i) {
            if (!Util.arrayRangeEquals(this.data, i, other, 0, other.length)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ByteString && ((ByteString)o).size() == this.data.length && ((ByteString)o).rangeEquals(0, this.data, 0, this.data.length);
    }

    public int hashCode() {
        int n = this.hashCode;
        return n != 0 ? n : (this.hashCode = Arrays.hashCode(this.data));
    }

    @Override
    public int compareTo(ByteString byteString) {
        int n = this.size();
        int n2 = byteString.size();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = this.getByte(i) & 0xFF;
            if (n5 == (n4 = byteString.getByte(i) & 0xFF)) continue;
            return n5 < n4 ? -1 : 1;
        }
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }

    public String toString() {
        if (this.data.length == 0) {
            return "[size=0]";
        }
        String string = this.utf8();
        int n = ByteString.codePointIndexToCharIndex(string, 64);
        if (n == -1) {
            return this.data.length <= 64 ? "[hex=" + this.hex() + "]" : "[size=" + this.data.length + " hex=" + this.substring(0, 64).hex() + "\u2026]";
        }
        String string2 = string.substring(0, n).replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        return n < string.length() ? "[size=" + this.data.length + " text=" + string2 + "\u2026]" : "[text=" + string2 + "]";
    }

    static int codePointIndexToCharIndex(String s, int codePointCount) {
        int n;
        int n2 = 0;
        int n3 = s.length();
        for (int i = 0; i < n3; i += Character.charCount(n)) {
            if (n2 == codePointCount) {
                return i;
            }
            n = s.codePointAt(i);
            if (Character.isISOControl(n) && n != 10 && n != 13 || n == 65533) {
                return -1;
            }
            ++n2;
        }
        return s.length();
    }

    private void readObject(ObjectInputStream in) {
        int n = in.readInt();
        ByteString byteString = ByteString.read(in, n);
        try {
            Field field = ByteString.class.getDeclaredField("data");
            field.setAccessible(true);
            field.set(this, byteString.data);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream out) {
        out.writeInt(this.data.length);
        out.write(this.data);
    }
}

