/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import okio.Buffer;
import okio.BufferedSource;
import okio.InflaterSource;
import okio.Okio;
import okio.Segment;
import okio.Source;
import okio.Timeout;

public final class GzipSource
implements Source {
    private static final byte FHCRC = 1;
    private static final byte FEXTRA = 2;
    private static final byte FNAME = 3;
    private static final byte FCOMMENT = 4;
    private static final byte SECTION_HEADER = 0;
    private static final byte SECTION_BODY = 1;
    private static final byte SECTION_TRAILER = 2;
    private static final byte SECTION_DONE = 3;
    private int section = 0;
    private final BufferedSource source;
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private final CRC32 crc = new CRC32();

    public GzipSource(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        this.inflater = new Inflater(true);
        this.source = Okio.buffer(source);
        this.inflaterSource = new InflaterSource(this.source, this.inflater);
    }

    @Override
    public long read(Buffer sink, long byteCount) {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (byteCount == 0L) {
            return 0L;
        }
        if (this.section == 0) {
            this.consumeHeader();
            this.section = 1;
        }
        if (this.section == 1) {
            long l = sink.size;
            long l2 = this.inflaterSource.read(sink, byteCount);
            if (l2 != -1L) {
                this.updateCrc(sink, l, l2);
                return l2;
            }
            this.section = 2;
        }
        if (this.section == 2) {
            this.consumeTrailer();
            this.section = 3;
            if (!this.source.exhausted()) {
                throw new IOException("gzip finished without exhausting source");
            }
        }
        return -1L;
    }

    private void consumeHeader() {
        boolean bl;
        this.source.require(10L);
        byte by = this.source.buffer().getByte(3L);
        boolean bl2 = bl = (by >> 1 & 1) == 1;
        if (bl) {
            this.updateCrc(this.source.buffer(), 0L, 10L);
        }
        short s = this.source.readShort();
        this.checkEqual("ID1ID2", 8075, s);
        this.source.skip(8L);
        if ((by >> 2 & 1) == 1) {
            this.source.require(2L);
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, 2L);
            }
            short s2 = this.source.buffer().readShortLe();
            this.source.require(s2);
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, s2);
            }
            this.source.skip(s2);
        }
        if ((by >> 3 & 1) == 1) {
            long l = this.source.indexOf((byte)0);
            if (l == -1L) {
                throw new EOFException();
            }
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, l + 1L);
            }
            this.source.skip(l + 1L);
        }
        if ((by >> 4 & 1) == 1) {
            long l = this.source.indexOf((byte)0);
            if (l == -1L) {
                throw new EOFException();
            }
            if (bl) {
                this.updateCrc(this.source.buffer(), 0L, l + 1L);
            }
            this.source.skip(l + 1L);
        }
        if (bl) {
            this.checkEqual("FHCRC", this.source.readShortLe(), (short)this.crc.getValue());
            this.crc.reset();
        }
    }

    private void consumeTrailer() {
        this.checkEqual("CRC", this.source.readIntLe(), (int)this.crc.getValue());
        this.checkEqual("ISIZE", this.source.readIntLe(), (int)this.inflater.getBytesWritten());
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() {
        this.inflaterSource.close();
    }

    private void updateCrc(Buffer buffer, long offset, long byteCount) {
        Segment segment = buffer.head;
        while (offset >= (long)(segment.limit - segment.pos)) {
            offset -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (byteCount > 0L) {
            int n = (int)((long)segment.pos + offset);
            int n2 = (int)Math.min((long)(segment.limit - n), byteCount);
            this.crc.update(segment.data, n, n2);
            byteCount -= (long)n2;
            offset = 0L;
            segment = segment.next;
        }
    }

    private void checkEqual(String name, int expected, int actual) {
        if (actual != expected) {
            throw new IOException(String.format("%s: actual 0x%08x != expected 0x%08x", name, actual, expected));
        }
    }
}

