/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSink;
import okio.Segment;
import okio.Sink;
import okio.Util;

public final class HashingSink
extends ForwardingSink {
    @Nullable
    private final MessageDigest messageDigest;
    @Nullable
    private final Mac mac;

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, "MD5");
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, "SHA-1");
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, "SHA-256");
    }

    public static HashingSink sha512(Sink sink) {
        return new HashingSink(sink, "SHA-512");
    }

    public static HashingSink hmacSha1(Sink sink, ByteString key) {
        return new HashingSink(sink, key, "HmacSHA1");
    }

    public static HashingSink hmacSha256(Sink sink, ByteString key) {
        return new HashingSink(sink, key, "HmacSHA256");
    }

    public static HashingSink hmacSha512(Sink sink, ByteString key) {
        return new HashingSink(sink, key, "HmacSHA512");
    }

    private HashingSink(Sink sink, String algorithm) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
            this.mac = null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSink(Sink sink, ByteString key, String algorithm) {
        super(sink);
        try {
            this.mac = Mac.getInstance(algorithm);
            this.mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            this.messageDigest = null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    @Override
    public void write(Buffer source, long byteCount) {
        int n;
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        Segment segment = source.head;
        for (long i = 0L; i < byteCount; i += (long)n) {
            n = (int)Math.min(byteCount - i, (long)(segment.limit - segment.pos));
            if (this.messageDigest != null) {
                this.messageDigest.update(segment.data, segment.pos, n);
            } else {
                this.mac.update(segment.data, segment.pos, n);
            }
            segment = segment.next;
        }
        super.write(source, byteCount);
    }

    public ByteString hash() {
        byte[] byArray = this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal();
        return ByteString.of(byArray);
    }
}

