/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSource;
import okio.Segment;
import okio.Source;

public final class HashingSource
extends ForwardingSource {
    private final MessageDigest messageDigest;
    private final Mac mac;

    public static HashingSource md5(Source source) {
        return new HashingSource(source, "MD5");
    }

    public static HashingSource sha1(Source source) {
        return new HashingSource(source, "SHA-1");
    }

    public static HashingSource sha256(Source source) {
        return new HashingSource(source, "SHA-256");
    }

    public static HashingSource hmacSha1(Source source, ByteString key) {
        return new HashingSource(source, key, "HmacSHA1");
    }

    public static HashingSource hmacSha256(Source source, ByteString key) {
        return new HashingSource(source, key, "HmacSHA256");
    }

    private HashingSource(Source source, String algorithm) {
        super(source);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
            this.mac = null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSource(Source source, ByteString key, String algorithm) {
        super(source);
        try {
            this.mac = Mac.getInstance(algorithm);
            this.mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            this.messageDigest = null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    @Override
    public long read(Buffer sink, long byteCount) {
        long l = super.read(sink, byteCount);
        if (l != -1L) {
            long l2;
            long l3 = sink.size - l;
            Segment segment = sink.head;
            for (l2 = sink.size; l2 > l3; l2 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
            while (l2 < sink.size) {
                int n = (int)((long)segment.pos + l3 - l2);
                if (this.messageDigest != null) {
                    this.messageDigest.update(segment.data, n, segment.limit - n);
                } else {
                    this.mac.update(segment.data, n, segment.limit - n);
                }
                l3 = l2 += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        }
        return l;
    }

    public ByteString hash() {
        byte[] byArray = this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal();
        return ByteString.of(byArray);
    }
}

