/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.RealBufferedSink;
import okio.RealBufferedSource;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class Okio {
    static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream out) {
        return Okio.sink(out, new Timeout());
    }

    private static Sink sink(final OutputStream out, final Timeout timeout) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Sink(){

            @Override
            public void write(Buffer source, long byteCount) {
                Util.checkOffsetAndCount(source.size, 0L, byteCount);
                while (byteCount > 0L) {
                    timeout.throwIfReached();
                    Segment segment = source.head;
                    int n = (int)Math.min(byteCount, (long)(segment.limit - segment.pos));
                    out.write(segment.data, segment.pos, n);
                    segment.pos += n;
                    byteCount -= (long)n;
                    source.size -= (long)n;
                    if (segment.pos != segment.limit) continue;
                    source.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
            }

            @Override
            public void flush() {
                out.flush();
            }

            @Override
            public void close() {
                out.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "sink(" + out + ")";
            }
        };
    }

    public static Sink sink(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("socket == null");
        }
        AsyncTimeout asyncTimeout = Okio.timeout(socket);
        Sink sink = Okio.sink(socket.getOutputStream(), asyncTimeout);
        return asyncTimeout.sink(sink);
    }

    public static Source source(InputStream in) {
        return Okio.source(in, new Timeout());
    }

    private static Source source(final InputStream in, final Timeout timeout) {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (timeout == null) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Source(){

            @Override
            public long read(Buffer sink, long byteCount) {
                if (byteCount < 0L) {
                    throw new IllegalArgumentException("byteCount < 0: " + byteCount);
                }
                if (byteCount == 0L) {
                    return 0L;
                }
                try {
                    timeout.throwIfReached();
                    Segment segment = sink.writableSegment(1);
                    int n = (int)Math.min(byteCount, (long)(8192 - segment.limit));
                    int n2 = in.read(segment.data, segment.limit, n);
                    if (n2 == -1) {
                        return -1L;
                    }
                    segment.limit += n2;
                    sink.size += (long)n2;
                    return n2;
                }
                catch (AssertionError assertionError) {
                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                        throw new IOException((Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
            }

            @Override
            public void close() {
                in.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "source(" + in + ")";
            }
        };
    }

    public static Source source(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.source(new FileInputStream(file));
    }

    @IgnoreJRERequirement
    public static Source source(Path path, OpenOption ... options) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.source(Files.newInputStream(path, options));
    }

    public static Sink sink(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink(new FileOutputStream(file));
    }

    public static Sink appendingSink(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return Okio.sink(new FileOutputStream(file, true));
    }

    @IgnoreJRERequirement
    public static Sink sink(Path path, OpenOption ... options) {
        if (path == null) {
            throw new IllegalArgumentException("path == null");
        }
        return Okio.sink(Files.newOutputStream(path, options));
    }

    public static Sink blackhole() {
        return new Sink(){

            @Override
            public void write(Buffer source, long byteCount) {
                source.skip(byteCount);
            }

            @Override
            public void flush() {
            }

            @Override
            public Timeout timeout() {
                return Timeout.NONE;
            }

            @Override
            public void close() {
            }
        };
    }

    public static Source source(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("socket == null");
        }
        AsyncTimeout asyncTimeout = Okio.timeout(socket);
        Source source = Okio.source(socket.getInputStream(), asyncTimeout);
        return asyncTimeout.source(source);
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){

            @Override
            protected IOException newTimeoutException(@Nullable IOException cause) {
                SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
                if (cause != null) {
                    socketTimeoutException.initCause(cause);
                }
                return socketTimeoutException;
            }

            @Override
            protected void timedOut() {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Failed to close timed out socket " + socket, exception);
                }
                catch (AssertionError assertionError) {
                    if (Okio.isAndroidGetsocknameError(assertionError)) {
                        logger.log(Level.WARNING, "Failed to close timed out socket " + socket, (Throwable)((Object)assertionError));
                    }
                    throw assertionError;
                }
            }
        };
    }

    static boolean isAndroidGetsocknameError(AssertionError e2) {
        return ((Throwable)((Object)e2)).getCause() != null && ((Throwable)((Object)e2)).getMessage() != null && ((Throwable)((Object)e2)).getMessage().contains("getsockname failed");
    }
}

