/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer = new Buffer();
    public final Source source;
    boolean closed;

    RealBufferedSource(Source source) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        this.source = source;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public long read(Buffer sink, long byteCount) {
        long l;
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size == 0L && (l = this.source.read(this.buffer, 8192L)) == -1L) {
            return -1L;
        }
        l = Math.min(byteCount, this.buffer.size);
        return this.buffer.read(sink, l);
    }

    @Override
    public boolean exhausted() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        return this.buffer.exhausted() && this.source.read(this.buffer, 8192L) == -1L;
    }

    @Override
    public void require(long byteCount) {
        if (!this.request(byteCount)) {
            throw new EOFException();
        }
    }

    @Override
    public boolean request(long byteCount) {
        if (byteCount < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + byteCount);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (this.buffer.size < byteCount) {
            if (this.source.read(this.buffer, 8192L) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte readByte() {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public ByteString readByteString() {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteString();
    }

    @Override
    public ByteString readByteString(long byteCount) {
        this.require(byteCount);
        return this.buffer.readByteString(byteCount);
    }

    @Override
    public int select(Options options) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        do {
            int n;
            if ((n = this.buffer.selectPrefix(options)) == -1) {
                return -1;
            }
            int n2 = options.byteStrings[n].size();
            if ((long)n2 > this.buffer.size) continue;
            this.buffer.skip(n2);
            return n;
        } while (this.source.read(this.buffer, 8192L) != -1L);
        return -1;
    }

    @Override
    public byte[] readByteArray() {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteArray();
    }

    @Override
    public byte[] readByteArray(long byteCount) {
        this.require(byteCount);
        return this.buffer.readByteArray(byteCount);
    }

    @Override
    public int read(byte[] sink) {
        return this.read(sink, 0, sink.length);
    }

    @Override
    public void readFully(byte[] sink) {
        try {
            this.require(sink.length);
        }
        catch (EOFException eOFException) {
            int n = 0;
            while (this.buffer.size > 0L) {
                int n2 = this.buffer.read(sink, n, (int)this.buffer.size);
                if (n2 == -1) {
                    throw new AssertionError();
                }
                n += n2;
            }
            throw eOFException;
        }
        this.buffer.readFully(sink);
    }

    @Override
    public int read(byte[] sink, int offset, int byteCount) {
        long l;
        Util.checkOffsetAndCount(sink.length, offset, byteCount);
        if (this.buffer.size == 0L && (l = this.source.read(this.buffer, 8192L)) == -1L) {
            return -1;
        }
        int n = (int)Math.min((long)byteCount, this.buffer.size);
        return this.buffer.read(sink, offset, n);
    }

    @Override
    public void readFully(Buffer sink, long byteCount) {
        try {
            this.require(byteCount);
        }
        catch (EOFException eOFException) {
            sink.writeAll(this.buffer);
            throw eOFException;
        }
        this.buffer.readFully(sink, byteCount);
    }

    @Override
    public long readAll(Sink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        long l = 0L;
        while (this.source.read(this.buffer, 8192L) != -1L) {
            long l2 = this.buffer.completeSegmentByteCount();
            if (l2 <= 0L) continue;
            l += l2;
            sink.write(this.buffer, l2);
        }
        if (this.buffer.size() > 0L) {
            l += this.buffer.size();
            sink.write(this.buffer, this.buffer.size());
        }
        return l;
    }

    @Override
    public String readUtf8() {
        this.buffer.writeAll(this.source);
        return this.buffer.readUtf8();
    }

    @Override
    public String readUtf8(long byteCount) {
        this.require(byteCount);
        return this.buffer.readUtf8(byteCount);
    }

    @Override
    public String readString(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        this.buffer.writeAll(this.source);
        return this.buffer.readString(charset);
    }

    @Override
    public String readString(long byteCount, Charset charset) {
        this.require(byteCount);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return this.buffer.readString(byteCount, charset);
    }

    @Override
    @Nullable
    public String readUtf8Line() {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            return this.buffer.size != 0L ? this.readUtf8(this.buffer.size) : null;
        }
        return this.buffer.readUtf8Line(l);
    }

    @Override
    public String readUtf8LineStrict() {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit < 0: " + limit);
        }
        long l = limit == Long.MAX_VALUE ? Long.MAX_VALUE : limit + 1L;
        long l2 = this.indexOf((byte)10, 0L, l);
        if (l2 != -1L) {
            return this.buffer.readUtf8Line(l2);
        }
        if (l < Long.MAX_VALUE && this.request(l) && this.buffer.getByte(l - 1L) == 13 && this.request(l + 1L) && this.buffer.getByte(l) == 10) {
            return this.buffer.readUtf8Line(l);
        }
        Buffer buffer = new Buffer();
        this.buffer.copyTo(buffer, 0L, Math.min(32L, this.buffer.size()));
        throw new EOFException("\\n not found: limit=" + Math.min(this.buffer.size(), limit) + " content=" + buffer.readByteString().hex() + '\u2026');
    }

    @Override
    public int readUtf8CodePoint() {
        this.require(1L);
        byte by = this.buffer.getByte(0L);
        if ((by & 0xE0) == 192) {
            this.require(2L);
        } else if ((by & 0xF0) == 224) {
            this.require(3L);
        } else if ((by & 0xF8) == 240) {
            this.require(4L);
        }
        return this.buffer.readUtf8CodePoint();
    }

    @Override
    public short readShort() {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLe() {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public int readInt() {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLe() {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public long readLong() {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLe() {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    @Override
    public long readDecimalLong() {
        this.require(1L);
        int n = 0;
        while (this.request(n + 1)) {
            byte by = this.buffer.getByte(n);
            if (!(by >= 48 && by <= 57 || n == 0 && by == 45)) {
                if (n != 0) break;
                throw new NumberFormatException(String.format("Expected leading [0-9] or '-' character but was %#x", by));
            }
            ++n;
        }
        return this.buffer.readDecimalLong();
    }

    @Override
    public long readHexadecimalUnsignedLong() {
        this.require(1L);
        int n = 0;
        while (this.request(n + 1)) {
            byte by = this.buffer.getByte(n);
            if (!(by >= 48 && by <= 57 || by >= 97 && by <= 102 || by >= 65 && by <= 70)) {
                if (n != 0) break;
                throw new NumberFormatException(String.format("Expected leading [0-9a-fA-F] character but was %#x", by));
            }
            ++n;
        }
        return this.buffer.readHexadecimalUnsignedLong();
    }

    @Override
    public void skip(long byteCount) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (byteCount > 0L) {
            if (this.buffer.size == 0L && this.source.read(this.buffer, 8192L) == -1L) {
                throw new EOFException();
            }
            long l = Math.min(byteCount, this.buffer.size());
            this.buffer.skip(l);
            byteCount -= l;
        }
    }

    @Override
    public long indexOf(byte b2) {
        return this.indexOf(b2, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte b2, long fromIndex) {
        return this.indexOf(b2, fromIndex, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte b2, long fromIndex, long toIndex) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (fromIndex < 0L || toIndex < fromIndex) {
            throw new IllegalArgumentException(String.format("fromIndex=%s toIndex=%s", fromIndex, toIndex));
        }
        while (fromIndex < toIndex) {
            long l = this.buffer.indexOf(b2, fromIndex, toIndex);
            if (l != -1L) {
                return l;
            }
            long l2 = this.buffer.size;
            if (l2 >= toIndex || this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            fromIndex = Math.max(fromIndex, l2);
        }
        return -1L;
    }

    @Override
    public long indexOf(ByteString bytes) {
        return this.indexOf(bytes, 0L);
    }

    @Override
    public long indexOf(ByteString bytes, long fromIndex) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l;
        while ((l = this.buffer.indexOf(bytes, fromIndex)) == -1L) {
            long l2 = this.buffer.size;
            if (this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            fromIndex = Math.max(fromIndex, l2 - (long)bytes.size() + 1L);
        }
        return l;
    }

    @Override
    public long indexOfElement(ByteString targetBytes) {
        return this.indexOfElement(targetBytes, 0L);
    }

    @Override
    public long indexOfElement(ByteString targetBytes, long fromIndex) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l;
        while ((l = this.buffer.indexOfElement(targetBytes, fromIndex)) == -1L) {
            long l2 = this.buffer.size;
            if (this.source.read(this.buffer, 8192L) == -1L) {
                return -1L;
            }
            fromIndex = Math.max(fromIndex, l2);
        }
        return l;
    }

    @Override
    public boolean rangeEquals(long offset, ByteString bytes) {
        return this.rangeEquals(offset, bytes, 0, bytes.size());
    }

    @Override
    public boolean rangeEquals(long offset, ByteString bytes, int bytesOffset, int byteCount) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (offset < 0L || bytesOffset < 0 || byteCount < 0 || bytes.size() - bytesOffset < byteCount) {
            return false;
        }
        for (int i = 0; i < byteCount; ++i) {
            long l = offset + (long)i;
            if (!this.request(l + 1L)) {
                return false;
            }
            if (this.buffer.getByte(l) == bytes.getByte(bytesOffset + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() {
                long l;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                if (RealBufferedSource.this.buffer.size == 0L && (l = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] data, int offset, int byteCount) {
                long l;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                Util.checkOffsetAndCount(data.length, offset, byteCount);
                if (RealBufferedSource.this.buffer.size == 0L && (l = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 8192L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.read(data, offset, byteCount);
            }

            @Override
            public int available() {
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                return (int)Math.min(RealBufferedSource.this.buffer.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + ".inputStream()";
            }
        };
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    public String toString() {
        return "buffer(" + this.source + ")";
    }
}

