/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import okio.Util;

final class SegmentedByteString
extends ByteString {
    final transient byte[][] segments;
    final transient int[] directory;

    SegmentedByteString(Buffer buffer, int byteCount) {
        super(null);
        Util.checkOffsetAndCount(buffer.size, 0L, byteCount);
        int n = 0;
        int n2 = 0;
        Segment segment = buffer.head;
        while (n < byteCount) {
            if (segment.limit == segment.pos) {
                throw new AssertionError((Object)"s.limit == s.pos");
            }
            n += segment.limit - segment.pos;
            ++n2;
            segment = segment.next;
        }
        this.segments = new byte[n2][];
        this.directory = new int[n2 * 2];
        n = 0;
        n2 = 0;
        segment = buffer.head;
        while (n < byteCount) {
            this.segments[n2] = segment.data;
            if ((n += segment.limit - segment.pos) > byteCount) {
                n = byteCount;
            }
            this.directory[n2] = n;
            this.directory[n2 + this.segments.length] = segment.pos;
            segment.shared = true;
            ++n2;
            segment = segment.next;
        }
    }

    @Override
    public String utf8() {
        return this.toByteString().utf8();
    }

    @Override
    public String string(Charset charset) {
        return this.toByteString().string(charset);
    }

    @Override
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    @Override
    public ByteString md5() {
        return this.toByteString().md5();
    }

    @Override
    public ByteString sha1() {
        return this.toByteString().sha1();
    }

    @Override
    public ByteString sha256() {
        return this.toByteString().sha256();
    }

    @Override
    public ByteString hmacSha1(ByteString key) {
        return this.toByteString().hmacSha1(key);
    }

    @Override
    public ByteString hmacSha256(ByteString key) {
        return this.toByteString().hmacSha256(key);
    }

    @Override
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    @Override
    public ByteString substring(int beginIndex) {
        return this.toByteString().substring(beginIndex);
    }

    @Override
    public ByteString substring(int beginIndex, int endIndex) {
        return this.toByteString().substring(beginIndex, endIndex);
    }

    @Override
    public byte getByte(int pos) {
        Util.checkOffsetAndCount(this.directory[this.segments.length - 1], pos, 1L);
        int n = this.segment(pos);
        int n2 = n == 0 ? 0 : this.directory[n - 1];
        int n3 = this.directory[n + this.segments.length];
        return this.segments[n][pos - n2 + n3];
    }

    private int segment(int pos) {
        int n = Arrays.binarySearch(this.directory, 0, this.segments.length, pos + 1);
        return n >= 0 ? n : ~n;
    }

    @Override
    public int size() {
        return this.directory[this.segments.length - 1];
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = new byte[this.directory[this.segments.length - 1]];
        int n = 0;
        int n2 = this.segments.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.directory[n2 + i];
            int n4 = this.directory[i];
            System.arraycopy(this.segments[i], n3, byArray, n, n4 - n);
            n = n4;
        }
        return byArray;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
    }

    @Override
    public void write(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        int n = 0;
        int n2 = this.segments.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.directory[n2 + i];
            int n4 = this.directory[i];
            out.write(this.segments[i], n3, n4 - n);
            n = n4;
        }
    }

    @Override
    void write(Buffer buffer) {
        int n = 0;
        int n2 = this.segments.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.directory[n2 + i];
            int n4 = this.directory[i];
            Segment segment = new Segment(this.segments[i], n3, n3 + n4 - n);
            if (buffer.head == null) {
                segment.next = segment.prev = segment;
                buffer.head = segment.prev;
            } else {
                buffer.head.prev.push(segment);
            }
            n = n4;
        }
        buffer.size += (long)n;
    }

    @Override
    public boolean rangeEquals(int offset, ByteString other, int otherOffset, int byteCount) {
        if (offset < 0 || offset > this.size() - byteCount) {
            return false;
        }
        int n = this.segment(offset);
        while (byteCount > 0) {
            int n2;
            int n3;
            int n4;
            int n5 = n == 0 ? 0 : this.directory[n - 1];
            int n6 = offset - n5 + (n4 = this.directory[this.segments.length + n]);
            if (!other.rangeEquals(otherOffset, this.segments[n], n6, n3 = Math.min(byteCount, n5 + (n2 = this.directory[n] - n5) - offset))) {
                return false;
            }
            offset += n3;
            otherOffset += n3;
            byteCount -= n3;
            ++n;
        }
        return true;
    }

    @Override
    public boolean rangeEquals(int offset, byte[] other, int otherOffset, int byteCount) {
        if (offset < 0 || offset > this.size() - byteCount || otherOffset < 0 || otherOffset > other.length - byteCount) {
            return false;
        }
        int n = this.segment(offset);
        while (byteCount > 0) {
            int n2;
            int n3;
            int n4;
            int n5 = n == 0 ? 0 : this.directory[n - 1];
            int n6 = offset - n5 + (n4 = this.directory[this.segments.length + n]);
            if (!Util.arrayRangeEquals(this.segments[n], n6, other, otherOffset, n3 = Math.min(byteCount, n5 + (n2 = this.directory[n] - n5) - offset))) {
                return false;
            }
            offset += n3;
            otherOffset += n3;
            byteCount -= n3;
            ++n;
        }
        return true;
    }

    @Override
    public int indexOf(byte[] other, int fromIndex) {
        return this.toByteString().indexOf(other, fromIndex);
    }

    @Override
    public int lastIndexOf(byte[] other, int fromIndex) {
        return this.toByteString().lastIndexOf(other, fromIndex);
    }

    private ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    @Override
    byte[] internalArray() {
        return this.toByteArray();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ByteString && ((ByteString)o).size() == this.size() && this.rangeEquals(0, (ByteString)o, 0, this.size());
    }

    @Override
    public int hashCode() {
        int n = this.hashCode;
        if (n != 0) {
            return n;
        }
        n = 1;
        int n2 = 0;
        int n3 = this.segments.length;
        for (int i = 0; i < n3; ++i) {
            byte[] byArray = this.segments[i];
            int n4 = this.directory[n3 + i];
            int n5 = this.directory[i];
            int n6 = n5 - n2;
            int n7 = n4 + n6;
            for (int j = n4; j < n7; ++j) {
                n = 31 * n + byArray[j];
            }
            n2 = n5;
        }
        this.hashCode = n;
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toByteString().toString();
    }

    private Object writeReplace() {
        return this.toByteString();
    }
}

