/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static final Timeout NONE = new Timeout(){

        @Override
        public Timeout timeout(long timeout, TimeUnit unit) {
            return this;
        }

        @Override
        public Timeout deadlineNanoTime(long deadlineNanoTime) {
            return this;
        }

        @Override
        public void throwIfReached() {
        }
    };
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;

    public Timeout timeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0: " + timeout);
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        this.timeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (!this.hasDeadline) {
            throw new IllegalStateException("No deadline");
        }
        return this.deadlineNanoTime;
    }

    public Timeout deadlineNanoTime(long deadlineNanoTime) {
        this.hasDeadline = true;
        this.deadlineNanoTime = deadlineNanoTime;
        return this;
    }

    public final Timeout deadline(long duration, TimeUnit unit) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration <= 0: " + duration);
        }
        if (unit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        return this.deadlineNanoTime(System.nanoTime() + unit.toNanos(duration));
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() {
        if (Thread.interrupted()) {
            throw new InterruptedIOException("thread interrupted");
        }
        if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
            throw new InterruptedIOException("deadline reached");
        }
    }

    public final void waitUntilNotified(Object monitor) {
        try {
            long l;
            long l2;
            boolean bl = this.hasDeadline();
            long l3 = this.timeoutNanos();
            if (!bl && l3 == 0L) {
                monitor.wait();
                return;
            }
            long l4 = System.nanoTime();
            if (bl && l3 != 0L) {
                l2 = this.deadlineNanoTime() - l4;
                l = Math.min(l3, l2);
            } else {
                l = bl ? this.deadlineNanoTime() - l4 : l3;
            }
            l2 = 0L;
            if (l > 0L) {
                long l5 = l / 1000000L;
                monitor.wait(l5, (int)(l - l5 * 1000000L));
                l2 = System.nanoTime() - l4;
            }
            if (l2 >= l) {
                throw new InterruptedIOException("timeout");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("interrupted");
        }
    }
}

