/*
 * Decompiled with CFR 0.152.
 */
package okio;

public final class Utf8 {
    private Utf8() {
    }

    public static long size(String string) {
        return Utf8.size(string, 0, string.length());
    }

    public static long size(String string, int beginIndex, int endIndex) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0: " + beginIndex);
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + endIndex + " < " + beginIndex);
        }
        if (endIndex > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + endIndex + " > " + string.length());
        }
        long l = 0L;
        int n = beginIndex;
        while (n < endIndex) {
            char c2;
            char c3 = string.charAt(n);
            if (c3 < '\u0080') {
                ++l;
                ++n;
                continue;
            }
            if (c3 < '\u0800') {
                l += 2L;
                ++n;
                continue;
            }
            if (c3 < '\ud800' || c3 > '\udfff') {
                l += 3L;
                ++n;
                continue;
            }
            char c4 = c2 = n + 1 < endIndex ? string.charAt(n + 1) : (char)'\u0000';
            if (c3 > '\udbff' || c2 < '\udc00' || c2 > '\udfff') {
                ++l;
                ++n;
                continue;
            }
            l += 4L;
            n += 2;
        }
        return l;
    }
}

