/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.gigaspacewebconsole.core;

import com.github.terma.gigaspacewebconsole.core.ExecuteResponseStream;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class JsonExecuteResponseStream
implements ExecuteResponseStream {
    private final JsonWriter jsonWriter;

    public JsonExecuteResponseStream(Writer writer) {
        this.jsonWriter = new JsonWriter(writer);
    }

    @Override
    public void writeHeader(List<String> columns) throws IOException {
        this.jsonWriter.beginObject();
        this.jsonWriter.name("columns");
        this.writeArray(columns);
        this.jsonWriter.name("data");
        this.jsonWriter.beginArray();
    }

    @Override
    public void writeRow(List<String> values) throws IOException {
        this.writeArray(values);
    }

    @Override
    public void close() throws IOException {
        this.jsonWriter.endArray();
        this.jsonWriter.endObject();
    }

    private void writeArray(List<String> values) throws IOException {
        this.jsonWriter.beginArray();
        for (String value : values) {
            this.jsonWriter.value(value);
        }
        this.jsonWriter.endArray();
    }
}

