/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.gigaspacewebconsole.core.config;

import com.github.terma.gigaspacewebconsole.core.config.ConfigDatabase;
import com.github.terma.gigaspacewebconsole.core.config.InternalConfig;
import com.github.terma.gigaspacewebconsole.core.config.UserConfig;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminFactory;

public class Config {
    public static final String DEFAULT_GS_HOST = "localhost";
    public static final int DEFAULT_GS_PORT = 4176;
    public static final String CONFIG_PATH_SYSTEM_PROPERTY = "gigaspacewebconsoleConfig";
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String FILE_PREFIX = "file:";
    public static final String LOCAL = "local";
    public static final String NONE = "none";
    private static final String INTERNAL_CONFIG_PATH = "/internalConfig.json";
    public UserConfig user;
    public InternalConfig internal;

    public static Config read() {
        Config config = new Config();
        config.internal = Config.readInternal();
        config.user = Config.readUser();
        return config;
    }

    static InternalConfig readInternal() {
        InputStream versionStream = Config.class.getResourceAsStream(INTERNAL_CONFIG_PATH);
        InputStreamReader reader = new InputStreamReader(versionStream);
        return (InternalConfig)new Gson().fromJson((Reader)reader, InternalConfig.class);
    }

    static UserConfig readUser() {
        String configPath = System.getProperty(CONFIG_PATH_SYSTEM_PROPERTY);
        if (configPath == null) {
            throw new IllegalArgumentException("Add gigaspacewebconsoleConfig to system properties!");
        }
        if (configPath.startsWith(CLASSPATH_PREFIX)) {
            InputStream configStream = UserConfig.class.getResourceAsStream(configPath.substring(CLASSPATH_PREFIX.length()));
            if (configStream == null) {
                throw new IllegalArgumentException("Can't load config from: " + configPath);
            }
            InputStreamReader reader = new InputStreamReader(configStream);
            return (UserConfig)new Gson().fromJson((Reader)reader, UserConfig.class);
        }
        if (configPath.startsWith(FILE_PREFIX)) {
            try {
                return (UserConfig)new Gson().fromJson((Reader)new FileReader(configPath.substring(FILE_PREFIX.length())), UserConfig.class);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Can't load config from: " + configPath);
            }
        }
        if (configPath.equals(LOCAL)) {
            return Config.local();
        }
        if (configPath.equals(NONE)) {
            return new UserConfig();
        }
        throw new IllegalArgumentException("Unknown config path: " + configPath);
    }

    private static UserConfig local() {
        UserConfig userConfig = new UserConfig();
        if (Config.isPortOpen(DEFAULT_GS_HOST, 4176)) {
            AdminFactory adminFactory = new AdminFactory();
            adminFactory.useDaemonThreads(true);
            adminFactory.addLocator("localhost:4176");
            Admin admin = adminFactory.createAdmin();
            for (String space : Config.getSpaces(admin)) {
                ConfigDatabase configDatabase = new ConfigDatabase();
                configDatabase.name = space;
                configDatabase.url = "jini://localhost:4176/*/" + space;
                userConfig.gigaspaces.add(configDatabase);
            }
            admin.close();
        }
        ConfigDatabase local = new ConfigDatabase();
        local.name = "LOCAL";
        local.url = "/./local";
        userConfig.gigaspaces.add(local);
        return userConfig;
    }

    private static List<String> getSpaces(Admin admin) {
        ArrayList<Object> spaces = new ArrayList();
        for (int i = 1; i < 5 && (spaces = new ArrayList(admin.getSpaces().getNames().keySet())).size() <= 0; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (spaces.isEmpty()) {
            spaces = new ArrayList();
            spaces.add("mySpace");
        }
        Collections.sort(spaces);
        System.out.println(spaces);
        return spaces;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortOpen(String host, int port) {
        try (Socket ignored = new Socket(host, port);){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

