/*
 * Decompiled with CFR 0.152.
 */
package gcp4zio.dp;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.dataproc.v1.Cluster;
import com.google.cloud.dataproc.v1.ClusterConfig;
import com.google.cloud.dataproc.v1.ClusterControllerClient;
import com.google.cloud.dataproc.v1.DiskConfig;
import com.google.cloud.dataproc.v1.EndpointConfig;
import com.google.cloud.dataproc.v1.GceClusterConfig;
import com.google.cloud.dataproc.v1.InstanceGroupConfig;
import com.google.cloud.dataproc.v1.LifecycleConfig;
import com.google.cloud.dataproc.v1.SoftwareConfig;
import com.google.protobuf.Duration;
import gcp4zio.dp.DPCluster;
import gcp4zio.dp.DPClusterImpl$;
import gcp4zio.dp.package;
import gcp4zio.dp.package$;
import java.io.Serializable;
import java.util.concurrent.Future;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.ZIO;
import zio.ZIO$;

public class DPClusterImpl
implements DPCluster,
Product,
Serializable {
    private final ClusterControllerClient client;

    public static DPClusterImpl apply(ClusterControllerClient clusterControllerClient) {
        return DPClusterImpl$.MODULE$.apply(clusterControllerClient);
    }

    public static DPClusterImpl fromProduct(Product product) {
        return DPClusterImpl$.MODULE$.fromProduct(product);
    }

    public static DPClusterImpl unapply(DPClusterImpl dPClusterImpl) {
        return DPClusterImpl$.MODULE$.unapply(dPClusterImpl);
    }

    public DPClusterImpl(ClusterControllerClient client) {
        this.client = client;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DPClusterImpl)) return false;
        DPClusterImpl dPClusterImpl = (DPClusterImpl)object;
        ClusterControllerClient clusterControllerClient = this.client();
        ClusterControllerClient clusterControllerClient2 = dPClusterImpl.client();
        if (clusterControllerClient == null) {
            if (clusterControllerClient2 != null) {
                return false;
            }
        } else if (!clusterControllerClient.equals(clusterControllerClient2)) return false;
        if (!dPClusterImpl.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DPClusterImpl;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "DPClusterImpl";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "client";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ClusterControllerClient client() {
        return this.client;
    }

    @Override
    public ZIO<Object, Throwable, Cluster> createDataproc(String clusterName, String project, String region, package.ClusterProps props) {
        return ZIO$.MODULE$.fromFutureJava(() -> this.createDataproc$$anonfun$1(clusterName, project, region, props), (Object)"gcp4zio.dp.DPClusterImpl.createDataproc(DPClusterImpl.scala:81)").tapBoth((Function1 & Serializable)e -> ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$1 -> package$.MODULE$.logger().error(new StringBuilder(35).append("Cluster creation failed with error ").append(e.getMessage()).toString()), (Object)"gcp4zio.dp.DPClusterImpl.createDataproc(DPClusterImpl.scala:83)"), (Function1 & Serializable)res -> ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$2 -> package$.MODULE$.logger().info(new StringBuilder(29).append("Cluster ").append(res.getClusterName()).append(" created successfully").toString()), (Object)"gcp4zio.dp.DPClusterImpl.createDataproc(DPClusterImpl.scala:84)"), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"gcp4zio.dp.DPClusterImpl.createDataproc(DPClusterImpl.scala:85)");
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> deleteDataproc(String cluster, String project, String region) {
        return ZIO$.MODULE$.fromFutureJava(() -> this.deleteDataproc$$anonfun$1(cluster, project, region), (Object)"gcp4zio.dp.DPClusterImpl.deleteDataproc(DPClusterImpl.scala:91)").tapBoth((Function1 & Serializable)e -> ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$3 -> package$.MODULE$.logger().error(new StringBuilder(35).append("Cluster deletion failed with error ").append(e.getMessage()).toString()), (Object)"gcp4zio.dp.DPClusterImpl.deleteDataproc(DPClusterImpl.scala:93)"), (Function1 & Serializable)_$1 -> ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$4 -> package$.MODULE$.logger().info(new StringBuilder(29).append("Cluster ").append(cluster).append(" deleted successfully").toString()), (Object)"gcp4zio.dp.DPClusterImpl.deleteDataproc(DPClusterImpl.scala:94)"), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"gcp4zio.dp.DPClusterImpl.deleteDataproc(DPClusterImpl.scala:95)").unit((Object)"gcp4zio.dp.DPClusterImpl.deleteDataproc(DPClusterImpl.scala:96)");
    }

    public DPClusterImpl copy(ClusterControllerClient client) {
        return new DPClusterImpl(client);
    }

    public ClusterControllerClient copy$default$1() {
        return this.client();
    }

    public ClusterControllerClient _1() {
        return this.client();
    }

    private final Future createDataproc$$anonfun$1(String clusterName$1, String project$1, String region$1, package.ClusterProps props$1) {
        ClusterConfig clusterConfig;
        GceClusterConfig.Builder builder;
        GceClusterConfig.Builder builder2;
        EndpointConfig.Builder endPointConfig = EndpointConfig.newBuilder().setEnableHttpPortAccess(true);
        SoftwareConfig.Builder softwareConfig = SoftwareConfig.newBuilder().setImageVersion(props$1.imageVersion());
        DiskConfig.Builder diskConfigM = DiskConfig.newBuilder().setBootDiskType(props$1.bootDiskType()).setBootDiskSizeGb(props$1.masterBootDiskSizeGb());
        DiskConfig.Builder diskConfigW = DiskConfig.newBuilder().setBootDiskType(props$1.bootDiskType()).setBootDiskSizeGb(props$1.workerBootDiskSizeGb());
        Option<String> option = props$1.subnetUri();
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            builder2 = GceClusterConfig.newBuilder().setInternalIpOnly(props$1.internalIpOnly()).setSubnetworkUri(value).addAllTags((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava(props$1.networkTags()).asJava()).addServiceAccountScopes("https://www.googleapis.com/auth/cloud-platform");
        } else if (None$.MODULE$.equals(option)) {
            builder2 = GceClusterConfig.newBuilder().setInternalIpOnly(props$1.internalIpOnly()).addAllTags((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava(props$1.networkTags()).asJava()).addServiceAccountScopes("https://www.googleapis.com/auth/cloud-platform");
        } else {
            throw new MatchError(option);
        }
        GceClusterConfig.Builder gceClusterBuilder = builder2;
        Option<String> option2 = props$1.serviceAccount();
        if (option2 instanceof Some) {
            String value = (String)((Some)option2).value();
            builder = gceClusterBuilder.setServiceAccount(value);
        } else {
            builder = gceClusterBuilder;
        }
        GceClusterConfig.Builder gceClusterConfig = builder;
        InstanceGroupConfig masterConfig = InstanceGroupConfig.newBuilder().setMachineTypeUri(props$1.masterMachineType()).setNumInstances(props$1.masterNumInstance()).setDiskConfig(diskConfigM).build();
        InstanceGroupConfig workerConfig = InstanceGroupConfig.newBuilder().setMachineTypeUri(props$1.workerMachineType()).setNumInstances(props$1.workerNumInstance()).setDiskConfig(diskConfigW).build();
        ClusterConfig.Builder clusterConfigBuilder = ClusterConfig.newBuilder().setMasterConfig(masterConfig).setWorkerConfig(workerConfig).setSoftwareConfig(softwareConfig).setConfigBucket(props$1.bucketName()).setGceClusterConfig(gceClusterConfig).setEndpointConfig(endPointConfig);
        Option<Object> option3 = props$1.idleDeletionDurationSecs();
        if (option3 instanceof Some) {
            long value = BoxesRunTime.unboxToLong((Object)((Some)option3).value());
            clusterConfig = clusterConfigBuilder.setLifecycleConfig(LifecycleConfig.newBuilder().setIdleDeleteTtl(Duration.newBuilder().setSeconds(value))).build();
        } else {
            clusterConfig = clusterConfigBuilder.build();
        }
        ClusterConfig clusterConfig2 = clusterConfig;
        Cluster cluster = Cluster.newBuilder().setClusterName(clusterName$1).setConfig(clusterConfig2).build();
        OperationFuture createClusterAsyncRequest = this.client().createClusterAsync(project$1, region$1, cluster);
        package$.MODULE$.logger().info(new StringBuilder(40).append("Submitting cluster creation request for ").append(clusterName$1).toString());
        return createClusterAsyncRequest;
    }

    private final Future deleteDataproc$$anonfun$1(String cluster$1, String project$2, String region$2) {
        package$.MODULE$.logger().info(new StringBuilder(40).append("Submitting cluster deletion request for ").append(cluster$1).toString());
        return this.client().deleteClusterAsync(project$2, region$2, cluster$1);
    }
}

