/*
 * Decompiled with CFR 0.152.
 */
package gcp4zio.dp;

import com.google.cloud.dataproc.v1.HiveJob;
import com.google.cloud.dataproc.v1.Job;
import com.google.cloud.dataproc.v1.JobControllerClient;
import com.google.cloud.dataproc.v1.JobPlacement;
import com.google.cloud.dataproc.v1.QueryList;
import com.google.cloud.dataproc.v1.SparkJob;
import gcp4zio.dp.DPJob;
import gcp4zio.dp.DPJobImpl$;
import gcp4zio.dp.package$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;
import zio.CanFail$;
import zio.Schedule;
import zio.Schedule$;
import zio.ZIO;
import zio.ZIO$;
import zio.Zippable$;

public class DPJobImpl
implements DPJob,
Product,
Serializable {
    private final JobControllerClient client;
    private final Schedule<Object, Job, Job> recurWhile;

    public static DPJobImpl apply(JobControllerClient jobControllerClient) {
        return DPJobImpl$.MODULE$.apply(jobControllerClient);
    }

    public static DPJobImpl fromProduct(Product product) {
        return DPJobImpl$.MODULE$.fromProduct(product);
    }

    public static DPJobImpl unapply(DPJobImpl dPJobImpl) {
        return DPJobImpl$.MODULE$.unapply(dPJobImpl);
    }

    public DPJobImpl(JobControllerClient client) {
        this.client = client;
        this.recurWhile = Schedule$.MODULE$.recurWhile((Function1 & Serializable)x$1 -> {
            block3: {
                block2: {
                    Job job;
                    Job job2 = job = x$1;
                    String string = job2.getStatus().getState().name();
                    String string2 = "CANCELLED";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    String string3 = job2.getStatus().getState().name();
                    String string4 = "ERROR";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                }
                return false;
            }
            return true;
        }, (Object)"gcp4zio.dp.DPJobImpl.recurWhile(DPJobImpl.scala:16)");
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DPJobImpl)) return false;
        DPJobImpl dPJobImpl = (DPJobImpl)object;
        JobControllerClient jobControllerClient = this.client();
        JobControllerClient jobControllerClient2 = dPJobImpl.client();
        if (jobControllerClient == null) {
            if (jobControllerClient2 != null) {
                return false;
            }
        } else if (!jobControllerClient.equals(jobControllerClient2)) return false;
        if (!dPJobImpl.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DPJobImpl;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "DPJobImpl";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "client";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public JobControllerClient client() {
        return this.client;
    }

    private Schedule finalSchedule(Duration interval) {
        return this.recurWhile.$amp$amp(Schedule$.MODULE$.spaced(interval, (Object)"gcp4zio.dp.DPJobImpl.finalSchedule(DPJobImpl.scala:19)"), Zippable$.MODULE$.Zippable2()).onDecision((Function3 & Serializable)(x$1, x$2, x$3) -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, x$2, x$3);
            if (tuple3 != null) {
                Tuple2 tuple2 = (Tuple2)tuple3._2();
                Schedule.Decision decision = (Schedule.Decision)tuple3._3();
                Tuple2 out = tuple2;
                if (Schedule.Decision$.Done$.MODULE$.equals(decision)) {
                    return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$1 -> package$.MODULE$.logger().error(new StringBuilder(25).append("Job failed, JOB_STATE => ").append(((Job)out._1()).getStatus().getState().name()).toString()), (Object)"gcp4zio.dp.DPJobImpl.finalSchedule(DPJobImpl.scala:20)");
                }
                Tuple2 out2 = tuple2;
                if (decision instanceof Schedule.Decision$.Continue) {
                    Schedule.Decision$.Continue continue_ = Schedule.Decision$.Continue$.MODULE$.unapply((Schedule.Decision$.Continue)decision);
                    Schedule.Intervals intervals = continue_._1();
                    return ZIO$.MODULE$.succeed((Function1)(JProcedure1 & Serializable)evidence$2 -> package$.MODULE$.logger().info(new StringBuilder(32).append("Progress Check #").append(BoxesRunTime.unboxToLong((Object)out2._2()) + 1L).append(", JOB_STATE => ").append(((Job)out2._1()).getStatus().getState().name()).append(" ").toString()), (Object)"gcp4zio.dp.DPJobImpl.finalSchedule(DPJobImpl.scala:22)");
                }
            }
            throw new MatchError((Object)tuple3);
        });
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> trackJobProgress(String project, String region, Job job, Duration interval) {
        String jobId = job.getJobUuid();
        package$.MODULE$.logger().info(new StringBuilder(34).append("Started tracking progress for job ").append(jobId).toString());
        return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> this.client().getJob(project, region, jobId), (Object)"gcp4zio.dp.DPJobImpl.trackJobProgress(DPJobImpl.scala:29)").flatMap((Function1 & Serializable)jobResponse -> {
            String string = jobResponse.getStatus().getState().name();
            String string2 = "DONE";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> jobResponse, (Object)"gcp4zio.dp.DPJobImpl.trackJobProgress(DPJobImpl.scala:31)");
            }
            return ZIO$.MODULE$.fail(() -> DPJobImpl.trackJobProgress$$anonfun$2$$anonfun$2(jobResponse), (Object)"gcp4zio.dp.DPJobImpl.trackJobProgress(DPJobImpl.scala:32)");
        }, (Object)"gcp4zio.dp.DPJobImpl.trackJobProgress(DPJobImpl.scala:33)").retry(() -> this.trackJobProgress$$anonfun$3(interval), CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"gcp4zio.dp.DPJobImpl.trackJobProgress(DPJobImpl.scala:34)").mapBoth((Function1 & Serializable)errorJob -> {
            package$.MODULE$.logger().error(errorJob.toString());
            return new RuntimeException(new StringBuilder(12).append("Job failed, ").append(errorJob.getStatus().getDetails()).toString());
        }, (Function1)(JProcedure1 & Serializable)successJob -> {
            package$.MODULE$.logger().info(successJob.toString());
            package$.MODULE$.logger().info("Job completed successfully");
        }, CanFail$.MODULE$.canFail(NotGiven$.MODULE$.value()), (Object)"gcp4zio.dp.DPJobImpl.trackJobProgress(DPJobImpl.scala:44)");
    }

    @Override
    public ZIO<Object, Throwable, Job> submitSparkJob(List<String> args, String mainClass, List<String> libs, scala.collection.immutable.Map<String, String> conf, String cluster, String project, String region) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$5 -> {
            package$.MODULE$.logger().info(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(275).append("Submitting spark job on dataproc with below configurations:\n                   |region => ").append(region).append("\n                   |project => ").append(project).append("\n                   |cluster => ").append(cluster).append("\n                   |mainClass => ").append(mainClass).append("\n                   |args => ").append(args).append("\n                   |conf => ").append(conf).append("\n                   |libs => ").append(libs.mkString(",")).toString())));
            JobPlacement jobPlacement = JobPlacement.newBuilder().setClusterName(cluster).build();
            SparkJob sparkJob = SparkJob.newBuilder().addAllJarFileUris((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)libs).asJava()).putAllProperties(CollectionConverters$.MODULE$.MapHasAsJava((Map)conf).asJava()).setMainClass(mainClass).addAllArgs((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)args).asJava()).build();
            Job jobRequest = Job.newBuilder().setPlacement(jobPlacement).setSparkJob(sparkJob).build();
            Job jobResponse = this.client().submitJob(project, region, jobRequest);
            package$.MODULE$.logger().info(new StringBuilder(44).append("Spark job submitted successfully with JobId ").append(jobResponse.getJobUuid()).toString());
            return jobResponse;
        }, (Object)"gcp4zio.dp.DPJobImpl.submitSparkJob(DPJobImpl.scala:77)");
    }

    @Override
    public ZIO<Object, Throwable, Job> submitHiveJob(String query, String cluster, String project, String region) {
        return ZIO$.MODULE$.attempt((Function1 & Serializable)evidence$6 -> {
            package$.MODULE$.logger().info(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(183).append("Submitting hive job on dataproc with below configurations:\n                   |region => ").append(region).append("\n                   |project => ").append(project).append("\n                   |cluster => ").append(cluster).append("\n                   |query => ").append(query).toString())));
            JobPlacement jobPlacement = JobPlacement.newBuilder().setClusterName(cluster).build();
            QueryList.Builder queryList = QueryList.newBuilder().addQueries(query);
            HiveJob hiveJob = HiveJob.newBuilder().setQueryList(queryList).build();
            Job jobRequest = Job.newBuilder().setPlacement(jobPlacement).setHiveJob(hiveJob).build();
            Job jobResponse = this.client().submitJob(project, region, jobRequest);
            package$.MODULE$.logger().info(new StringBuilder(43).append("Hive job submitted successfully with JobId ").append(jobResponse.getJobUuid()).toString());
            return jobResponse;
        }, (Object)"gcp4zio.dp.DPJobImpl.submitHiveJob(DPJobImpl.scala:92)");
    }

    public DPJobImpl copy(JobControllerClient client) {
        return new DPJobImpl(client);
    }

    public JobControllerClient copy$default$1() {
        return this.client();
    }

    public JobControllerClient _1() {
        return this.client();
    }

    private static final Job trackJobProgress$$anonfun$2$$anonfun$2(Job jobResponse$2) {
        return jobResponse$2;
    }

    private final Schedule trackJobProgress$$anonfun$3(Duration interval$1) {
        return this.finalSchedule(interval$1);
    }
}

