/*
 * Decompiled with CFR 0.152.
 */
package gcp4zio;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.ExtractJobConfiguration;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import gcp4zio.BQ$;
import gcp4zio.BQApi;
import gcp4zio.package;
import gcp4zio.package$;
import gcp4zio.package$BQInputType$BQ$;
import gcp4zio.package$BQInputType$CSV$;
import gcp4zio.package$BQInputType$JSON$;
import gcp4zio.package$BQInputType$ORC$;
import gcp4zio.package$BQInputType$PARQUET$;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Has;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;

@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001\u0002\u0010 \u0001\nB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t'\u0002\u0011\t\u0012)A\u0005\u000f\")A\u000b\u0001C\u0001+\")\u0001\f\u0001C\u00053\")Q\r\u0001C\u0001M\")Q\u000f\u0001C\u0001m\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\ti\n\u0001C!\u0003?C\u0011\"!0\u0001#\u0003%\t!a0\t\u0013\u0005U\u0007!!A\u0005\u0002\u0005]\u0007\"CAn\u0001E\u0005I\u0011AAo\u0011%\t\t\u000fAA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002t\u0002\t\t\u0011\"\u0001\u0002v\"I\u0011q\u001f\u0001\u0002\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005\u000b\u0001\u0011\u0011!C!\u0005\u000fA\u0011B!\u0006\u0001\u0003\u0003%\tAa\u0006\t\u0013\t\u0005\u0002!!A\u0005B\t\r\u0002\"\u0003B\u0013\u0001\u0005\u0005I\u0011\tB\u0014\u0011%\u0011I\u0003AA\u0001\n\u0003\u0012YcB\u0004\u0003L}A\tA!\u0014\u0007\ryy\u0002\u0012\u0001B(\u0011\u0019!v\u0003\"\u0001\u0003R!9!1K\f\u0005\u0002\tU\u0003\"\u0003B4/E\u0005I\u0011\u0001B5\u0011%\u0011igFA\u0001\n\u0003\u0013y\u0007C\u0005\u0003t]\t\t\u0011\"!\u0003v!I!QP\f\u0002\u0002\u0013%!q\u0010\u0002\u0003\u0005FS\u0011\u0001I\u0001\bO\u000e\u0004HG_5p\u0007\u0001\u0019R\u0001A\u0012*\u007f\t\u0003\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007c\u0001\u0016/c9\u00111\u0006L\u0007\u0002?%\u0011QfH\u0001\u0006\u0005F\u000b\u0005/[\u0005\u0003_A\u0012qaU3sm&\u001cWM\u0003\u0002.?A\u0011!\u0007\u0010\b\u0003ger!\u0001N\u001c\u000e\u0003UR!AN\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014a\u0001>j_&\u0011!hO\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0014BA\u001f?\u0005\u0011!\u0016m]6\u000b\u0005iZ\u0004C\u0001\u0013A\u0013\t\tUEA\u0004Qe>$Wo\u0019;\u0011\u0005\u0011\u001a\u0015B\u0001#&\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019\u0019G.[3oiV\tq\t\u0005\u0002I#6\t\u0011J\u0003\u0002K\u0017\u0006A!-[4rk\u0016\u0014\u0018P\u0003\u0002M\u001b\u0006)1\r\\8vI*\u0011ajT\u0001\u0007O>|w\r\\3\u000b\u0003A\u000b1aY8n\u0013\t\u0011\u0016J\u0001\u0005CS\u001e\fV/\u001a:z\u0003\u001d\u0019G.[3oi\u0002\na\u0001P5oSRtDC\u0001,X!\tY\u0003\u0001C\u0003F\u0007\u0001\u0007q)\u0001\thKR4uN]7bi>\u0003H/[8ogR\u0011!,\u0018\t\u0003\u0011nK!\u0001X%\u0003\u001b\u0019{'/\\1u\u001fB$\u0018n\u001c8t\u0011\u0015qF\u00011\u0001`\u0003%Ig\u000e];u)f\u0004X\r\u0005\u0002aE:\u00111&Y\u0005\u0003u}I!a\u00193\u0003\u0017\t\u000b\u0016J\u001c9viRK\b/\u001a\u0006\u0003u}\tA\"\u001a=fGV$X-U;fef$\"aZ6\u0011\u0007Ib\u0004\u000e\u0005\u0002%S&\u0011!.\n\u0002\u0005+:LG\u000fC\u0003m\u000b\u0001\u0007Q.A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0002oe:\u0011q\u000e\u001d\t\u0003i\u0015J!!]\u0013\u0002\rA\u0013X\rZ3g\u0013\t\u0019HO\u0001\u0004TiJLgn\u001a\u0006\u0003c\u0016\nqaZ3u\t\u0006$\u0018\rF\u0002x\u0003\u000f\u00012A\r\u001fy!\u0011IX0!\u0001\u000f\u0005idhB\u0001\u001b|\u0013\u00051\u0013B\u0001\u001e&\u0013\tqxP\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tQT\u0005E\u0002I\u0003\u0007I1!!\u0002J\u000591\u0015.\u001a7e-\u0006dW/\u001a'jgRDQ\u0001\u001c\u0004A\u00025\fa\u0003\\8bIR\u000b'\r\\3Ge>lGj\\2bY\u001aKG.\u001a\u000b\nO\u00065\u00111EA\u0014\u0003WAq!a\u0004\b\u0001\u0004\t\t\"A\bt_V\u00148-\u001a'pG\u0006$\u0018n\u001c8t!\u0019I\u00181C7\u0002\u0018%\u0019\u0011QC@\u0003\r\u0015KG\u000f[3s!\u0015I\u0018\u0011DA\u000f\u0013\r\tYb \u0002\u0004'\u0016\f\b#\u0002\u0013\u0002 5l\u0017bAA\u0011K\t1A+\u001e9mKJBa!!\n\b\u0001\u0004y\u0016\u0001D:pkJ\u001cWMR8s[\u0006$\bBBA\u0015\u000f\u0001\u0007Q.\u0001\neKN$\u0018N\\1uS>tG)\u0019;bg\u0016$\bBBA\u0017\u000f\u0001\u0007Q.\u0001\teKN$\u0018N\\1uS>tG+\u00192mK\u0006!Bn\\1e!\u0006\u0014H/\u001b;j_:,G\rV1cY\u0016$B#a\r\u0002B\u0005\u0015\u0013qIA)\u0003'\n)&a\u001a\u0002r\u0005u\u0004\u0003\u0002\u001a=\u0003k\u0001bA\\A\u001c[\u0006m\u0012bAA\u001di\n\u0019Q*\u00199\u0011\u0007\u0011\ni$C\u0002\u0002@\u0015\u0012A\u0001T8oO\"9\u00111\t\u0005A\u0002\u0005]\u0011!F:pkJ\u001cW\rU1uQN\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007\u0003KA\u0001\u0019A0\t\u000f\u0005%\u0003\u00021\u0001\u0002L\u0005\u0011B-Z:uS:\fG/[8o!J|'.Z2u!\u0011!\u0013QJ7\n\u0007\u0005=SE\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003SA\u0001\u0019A7\t\r\u00055\u0002\u00021\u0001n\u0011\u001d\t9\u0006\u0003a\u0001\u00033\n\u0001c\u001e:ji\u0016$\u0015n\u001d9pg&$\u0018n\u001c8\u0011\t\u0005m\u0013\u0011\r\b\u0004\u0011\u0006u\u0013bAA0\u0013\u00069!j\u001c2J]\u001a|\u0017\u0002BA2\u0003K\u0012\u0001c\u0016:ji\u0016$\u0015n\u001d9pg&$\u0018n\u001c8\u000b\u0007\u0005}\u0013\nC\u0004\u0002j!\u0001\r!a\u001b\u0002#\r\u0014X-\u0019;f\t&\u001c\bo\\:ji&|g\u000e\u0005\u0003\u0002\\\u00055\u0014\u0002BA8\u0003K\u0012\u0011c\u0011:fCR,G)[:q_NLG/[8o\u0011\u001d\t\u0019\b\u0003a\u0001\u0003k\naa]2iK6\f\u0007#\u0002\u0013\u0002N\u0005]\u0004c\u0001%\u0002z%\u0019\u00111P%\u0003\rM\u001b\u0007.Z7b\u0011\u001d\ty\b\u0003a\u0001\u0003\u0003\u000b1\u0002]1sC2dW\r\\5t[B\u0019A%a!\n\u0007\u0005\u0015UEA\u0002J]R\f\u0011\u0002\\8bIR\u000b'\r\\3\u0015%\u0005M\u00121RAH\u0003#\u000b\u0019*!&\u0002\u0018\u0006e\u00151\u0014\u0005\u0007\u0003\u001bK\u0001\u0019A7\u0002\u0015M|WO]2f!\u0006$\b\u000e\u0003\u0004\u0002&%\u0001\ra\u0018\u0005\b\u0003\u0013J\u0001\u0019AA&\u0011\u0019\tI#\u0003a\u0001[\"1\u0011QF\u0005A\u00025Dq!a\u0016\n\u0001\u0004\tI\u0006C\u0004\u0002j%\u0001\r!a\u001b\t\u0013\u0005M\u0014\u0002%AA\u0002\u0005U\u0014aC3ya>\u0014H\u000fV1cY\u0016$rbZAQ\u0003K\u000bI+!,\u00022\u0006U\u0016\u0011\u0018\u0005\u0007\u0003GS\u0001\u0019A7\u0002\u001bM|WO]2f\t\u0006$\u0018m]3u\u0011\u0019\t9K\u0003a\u0001[\u0006Y1o\\;sG\u0016$\u0016M\u00197f\u0011\u001d\tYK\u0003a\u0001\u0003\u0017\nQb]8ve\u000e,\u0007K]8kK\u000e$\bBBAX\u0015\u0001\u0007Q.A\beKN$\u0018N\\1uS>t\u0007+\u0019;i\u0011\u001d\t\u0019L\u0003a\u0001\u0003\u0017\n1\u0003Z3ti&t\u0017\r^5p]\u001aKG.\u001a(b[\u0016Da!a.\u000b\u0001\u0004y\u0016!\u00053fgRLg.\u0019;j_:4uN]7bi\"A\u00111\u0018\u0006\u0011\u0002\u0003\u0007Q.\u0001\u000eeKN$\u0018N\\1uS>t7i\\7qe\u0016\u001c8/[8o)f\u0004X-A\u000bfqB|'\u000f\u001e+bE2,G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u0005\u0005'fA7\u0002D.\u0012\u0011Q\u0019\t\u0005\u0003\u000f\f\t.\u0004\u0002\u0002J*!\u00111ZAg\u0003%)hn\u00195fG.,GMC\u0002\u0002P\u0016\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019.!3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003d_BLHc\u0001,\u0002Z\"9Q\t\u0004I\u0001\u0002\u00049\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003?T3aRAb\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u001d\t\u0005\u0003O\f\t0\u0004\u0002\u0002j*!\u00111^Aw\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0018\u0001\u00026bm\u0006L1a]Au\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t)\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m(\u0011\u0001\t\u0004I\u0005u\u0018bAA\u0000K\t\u0019\u0011I\\=\t\u0013\t\r\u0001#!AA\u0002\u0005\u0005\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\nA1!1\u0002B\t\u0003wl!A!\u0004\u000b\u0007\t=Q%\u0001\u0006d_2dWm\u0019;j_:LAAa\u0005\u0003\u000e\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011IBa\b\u0011\u0007\u0011\u0012Y\"C\u0002\u0003\u001e\u0015\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0003\u0004I\t\t\u00111\u0001\u0002|\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0002\u0006AAo\\*ue&tw\r\u0006\u0002\u0002f\u00061Q-];bYN$BA!\u0007\u0003.!I!1A\u000b\u0002\u0002\u0003\u0007\u00111 \u0015\b\u0001\tE\"q\u0007B\u001d!\u0011\t9Oa\r\n\t\tU\u0012\u0011\u001e\u0002\u0011'V\u0004\bO]3tg^\u000b'O\\5oON\fQA^1mk\u0016d\u0003Ba\u000f\u0003@\t\r#qI\u0011\u0003\u0005{\t\u0011d\u001c:h]]\f'\u000f\u001e:f[>4XM\u001d\u0018xCJ$8O\f,be\u0006\u0012!\u0011I\u0001\u001f_J<gf^1siJ,Wn\u001c<fe::\u0018M\u001d;t]Q{7\u000b\u001e:j]\u001e\f#A!\u0012\u00027=\u0014xML<beR\u0014X-\\8wKJts/\u0019:ug:\"\u0006N]8xC\t\u0011I%A\u0013pe\u001ets/\u0019:ue\u0016lwN^3s]]\f'\u000f^:/!2\fGOZ8s[\u0012+g-Y;mi\u0006\u0011!)\u0015\t\u0003W]\u00192aF\u0012C)\t\u0011i%\u0001\u0003mSZ,G\u0003\u0002B,\u0005G\u0002RA\rB-\u0005;J1Aa\u0017?\u0005%!\u0016m]6MCf,'\u000fE\u0002a\u0005?J1A!\u0019e\u0005\u0015\u0011\u0015+\u00128w\u0011%\u0011)'\u0007I\u0001\u0002\u0004\tY%A\u0006de\u0016$WM\u001c;jC2\u001c\u0018A\u00047jm\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0005WRC!a\u0013\u0002D\u0006)\u0011\r\u001d9msR\u0019aK!\u001d\t\u000b\u0015[\u0002\u0019A$\u0002\u000fUt\u0017\r\u001d9msR!!q\u000fB=!\u0011!\u0013QJ$\t\u0011\tmD$!AA\u0002Y\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0005\u0005\u0003BAt\u0005\u0007KAA!\"\u0002j\n1qJ\u00196fGR\u0004")
public class BQ
implements BQApi.Service<ZIO>,
Product,
scala.Serializable {
    private final BigQuery client;

    public static Option<BigQuery> unapply(BQ bQ) {
        return BQ$.MODULE$.unapply(bQ);
    }

    public static BQ apply(BigQuery bigQuery) {
        return BQ$.MODULE$.apply(bigQuery);
    }

    public static Option<String> live$default$1() {
        return BQ$.MODULE$.live$default$1();
    }

    public static ZLayer<Object, Throwable, Has<BQApi.Service<ZIO>>> live(Option<String> option) {
        return BQ$.MODULE$.live(option);
    }

    @Override
    public Option<Schema> loadTable$default$8() {
        return BQApi.Service.loadTable$default$8$(this);
    }

    public BigQuery client() {
        return this.client;
    }

    private FormatOptions getFormatOptions(package.BQInputType inputType) {
        FormatOptions formatOptions;
        package.BQInputType bQInputType = inputType;
        if (package$BQInputType$PARQUET$.MODULE$.equals(bQInputType)) {
            formatOptions = FormatOptions.parquet();
        } else if (package$BQInputType$ORC$.MODULE$.equals(bQInputType)) {
            formatOptions = FormatOptions.orc();
        } else if (bQInputType instanceof package.BQInputType.CSV) {
            package.BQInputType.CSV cSV = (package.BQInputType.CSV)bQInputType;
            String field_delimiter = cSV.delimiter();
            boolean header_present = cSV.header_present();
            formatOptions = CsvOptions.newBuilder().setSkipLeadingRows(header_present ? 1L : 0L).setFieldDelimiter(field_delimiter).build();
        } else {
            formatOptions = FormatOptions.parquet();
        }
        return formatOptions;
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> executeQuery(String query) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)query).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).build();
            JobId jobId = JobId.of((String)UUID.randomUUID().toString());
            Job queryJob = this.client().create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
            try {
                queryJob = queryJob.waitFor(new RetryOption[0]);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (queryJob == null) {
                throw new RuntimeException("Job no longer exists");
            }
            if (queryJob.getStatus().getError() != null) {
                package$.MODULE$.logger().error(queryJob.getStatus().getState().toString());
                throw new RuntimeException(new StringBuilder(6).append("Error ").append(queryJob.getStatus().getError().getMessage()).toString());
            }
            package$.MODULE$.logger().info(new StringBuilder(11).append("Job State: ").append(queryJob.getStatus().getState()).toString());
        });
    }

    @Override
    public ZIO<Object, Throwable, Iterable<FieldValueList>> getData(String query) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            QueryJobConfiguration queryConfig = QueryJobConfiguration.newBuilder((String)query).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).build();
            JobId jobId = JobId.of((String)UUID.randomUUID().toString());
            Job queryJob = this.client().create(JobInfo.newBuilder((JobConfiguration)queryConfig).setJobId(jobId).build(), new BigQuery.JobOption[0]);
            Job job = queryJob.waitFor(new RetryOption[0]);
            TableResult result = job.getQueryResults(new BigQuery.QueryResultsOption[0]);
            return (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(result.iterateAll()).asScala();
        });
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> loadTableFromLocalFile(Either<String, Seq<Tuple2<String, String>>> sourceLocations, package.BQInputType sourceFormat, String destinationDataset, String destinationTable) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Either either = sourceLocations;
            if (either instanceof Left) {
                Left left = (Left)either;
                String path = (String)left.value();
                package$.MODULE$.logger().info(new StringBuilder(14).append("BQ file path: ").append(path).toString());
                String fullTableName = new StringBuilder(1).append(destinationDataset).append(".").append(destinationTable).toString();
                String bqLoadCmd = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(36).append("bq load --replace --source_format=").append(sourceFormat.toString()).append(" ").append(fullTableName).append(" ").append(path).toString())).stripMargin();
                package$.MODULE$.logger().info(new StringBuilder(24).append("Loading data from path: ").append(path).toString());
                package$.MODULE$.logger().info(new StringBuilder(19).append("Destination table: ").append(fullTableName).toString());
                package$.MODULE$.logger().info(new StringBuilder(20).append("BQ Load command is: ").append(bqLoadCmd).toString());
                int x = scala.sys.process.package$.MODULE$.stringToProcess(String.valueOf(bqLoadCmd)).$bang();
                package$.MODULE$.logger().info(new StringBuilder(18).append("Output exit code: ").append(x).toString());
                if (x != 0) {
                    throw new package.BQLoadException("Error executing BQ load command");
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (either instanceof Right) {
                Right right = (Right)either;
                Seq list = (Seq)right.value();
                package$.MODULE$.logger().info(new StringBuilder(21).append("No of BQ partitions: ").append(list.length()).toString());
                list.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    BQ.$anonfun$loadTableFromLocalFile$2(destinationTable, destinationDataset, sourceFormat, x0$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        });
    }

    @Override
    public ZIO<Object, Throwable, Map<String, Object>> loadPartitionedTable(Seq<Tuple2<String, String>> sourcePathsPartitions, package.BQInputType sourceFormat, Option<String> destinationProject, String destinationDataset, String destinationTable, JobInfo.WriteDisposition writeDisposition, JobInfo.CreateDisposition createDisposition, Option<Schema> schema, int parallelism) {
        package$.MODULE$.logger().info(new StringBuilder(21).append("No of BQ partitions: ").append(sourcePathsPartitions.length()).toString());
        return ZIO$.MODULE$.foreachParN(parallelism, sourcePathsPartitions, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String src_path = (String)tuple2._1();
            String partition = (String)tuple2._2();
            ZIO<Object, Throwable, Map<String, Object>> zIO = this.loadTable(src_path, sourceFormat, destinationProject, destinationDataset, new StringBuilder(1).append(destinationTable).append("$").append(partition).toString(), writeDisposition, createDisposition, this.loadTable$default$8());
            return zIO;
        }, Seq$.MODULE$.canBuildFrom()).map((Function1 & Serializable & scala.Serializable)x -> ((TraversableOnce)x.flatten((Function1)Predef$.MODULE$.$conforms())).toMap(Predef$.MODULE$.$conforms()));
    }

    @Override
    public ZIO<Object, Throwable, Map<String, Object>> loadTable(String sourcePath, package.BQInputType sourceFormat, Option<String> destinationProject, String destinationDataset, String destinationTable, JobInfo.WriteDisposition writeDisposition, JobInfo.CreateDisposition createDisposition, Option<Schema> schema) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            QueryJobConfiguration queryJobConfiguration;
            TableId tableId;
            Option option = destinationProject;
            if (option instanceof Some) {
                Some some = (Some)option;
                String project = (String)some.value();
                tableId = TableId.of((String)project, (String)destinationDataset, (String)destinationTable);
            } else if (None$.MODULE$.equals(option)) {
                tableId = TableId.of((String)destinationDataset, (String)destinationTable);
            } else {
                throw new MatchError((Object)option);
            }
            TableId tableId2 = tableId;
            package.BQInputType bQInputType = sourceFormat;
            if (package$BQInputType$BQ$.MODULE$.equals(bQInputType)) {
                queryJobConfiguration = QueryJobConfiguration.newBuilder((String)sourcePath).setUseLegacySql(Predef$.MODULE$.boolean2Boolean(false)).setDestinationTable(tableId2).setWriteDisposition(writeDisposition).setCreateDisposition(createDisposition).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true)).build();
            } else {
                boolean bl = package$BQInputType$ORC$.MODULE$.equals(bQInputType) ? true : (package$BQInputType$PARQUET$.MODULE$.equals(bQInputType) ? true : bQInputType instanceof package.BQInputType.CSV);
                if (bl) {
                    LoadJobConfiguration loadJobConfiguration;
                    Option option2 = schema;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        Schema s = (Schema)some.value();
                        loadJobConfiguration = LoadJobConfiguration.builder((TableId)tableId2, (String)sourcePath).setFormatOptions(this.getFormatOptions(sourceFormat)).setSchema(s).setWriteDisposition(writeDisposition).setCreateDisposition(createDisposition).build();
                    } else if (None$.MODULE$.equals(option2)) {
                        loadJobConfiguration = LoadJobConfiguration.builder((TableId)tableId2, (String)sourcePath).setFormatOptions(this.getFormatOptions(sourceFormat)).setWriteDisposition(writeDisposition).setCreateDisposition(createDisposition).build();
                    } else {
                        throw new MatchError((Object)option2);
                    }
                    queryJobConfiguration = loadJobConfiguration;
                } else {
                    throw new package.BQLoadException("Unsupported Input Type");
                }
            }
            QueryJobConfiguration jobConfiguration = queryJobConfiguration;
            JobId jobId = JobId.of((String)UUID.randomUUID().toString());
            Job job = this.client().create(JobInfo.newBuilder((JobConfiguration)jobConfiguration).setJobId(jobId).build(), new BigQuery.JobOption[0]);
            Job completedJob = job.waitFor(new RetryOption[0]);
            StandardTableDefinition destinationTableDef = (StandardTableDefinition)this.client().getTable(tableId2, new BigQuery.TableOption[0]).getDefinition();
            if (completedJob.getStatus().getError() != null) {
                throw new package.BQLoadException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(55).append("Could not load data in ").append(sourceFormat.toString()).append(" format in table ").append(destinationDataset).append(".").append(destinationTable).append(" due to error ").append(completedJob.getStatus().getError().getMessage()).toString())).stripMargin());
            }
            package$.MODULE$.logger().info(new StringBuilder(13).append("Source path: ").append(sourcePath).toString());
            package$.MODULE$.logger().info(new StringBuilder(20).append("Destination table: ").append(destinationDataset).append(".").append(destinationTable).toString());
            package$.MODULE$.logger().info(new StringBuilder(11).append("Job State: ").append(completedJob.getStatus().getState()).toString());
            package$.MODULE$.logger().info(new StringBuilder(13).append("Loaded rows: ").append(destinationTableDef.getNumRows()).toString());
            package$.MODULE$.logger().info(new StringBuilder(21).append("Loaded rows size: ").append((double)Predef$.MODULE$.Long2long(destinationTableDef.getNumBytes()) / 1000000.0).append(" MB").toString());
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)destinationTable), (Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(destinationTableDef.getNumRows())))}));
        });
    }

    @Override
    public ZIO<Object, Throwable, BoxedUnit> exportTable(String sourceDataset, String sourceTable, Option<String> sourceProject, String destinationPath, Option<String> destinationFileName, package.BQInputType destinationFormat, String destinationCompressionType) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExtractJobConfiguration extractJobConfiguration;
            String string;
            TableId tableId;
            Option option = sourceProject;
            if (option instanceof Some) {
                Some some = (Some)option;
                String project = (String)some.value();
                tableId = TableId.of((String)project, (String)sourceDataset, (String)sourceTable);
            } else if (None$.MODULE$.equals(option)) {
                tableId = TableId.of((String)sourceDataset, (String)sourceTable);
            } else {
                throw new MatchError((Object)option);
            }
            TableId tableId2 = tableId;
            package.BQInputType bQInputType = destinationFormat;
            if (bQInputType instanceof package.BQInputType.CSV) {
                string = "CSV";
            } else if (package$BQInputType$PARQUET$.MODULE$.equals(bQInputType)) {
                string = "PARQUET";
            } else {
                throw new package.BQLoadException(new StringBuilder(31).append("Unsupported destination format ").append(bQInputType).toString());
            }
            String destinationFormatStr = string;
            String destinationUri = new StringBuilder(1).append(destinationPath).append("/").append(destinationFileName.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("part-*.").append(destinationFormatStr.toLowerCase()).toString())).toString();
            package.BQInputType bQInputType2 = destinationFormat;
            if (bQInputType2 instanceof package.BQInputType.CSV) {
                package.BQInputType.CSV cSV = (package.BQInputType.CSV)bQInputType2;
                String delimiter = cSV.delimiter();
                extractJobConfiguration = ExtractJobConfiguration.newBuilder((TableId)tableId2, (String)destinationUri).setFormat(package$BQInputType$CSV$.MODULE$.toString()).setFieldDelimiter(delimiter).build();
            } else if (package$BQInputType$PARQUET$.MODULE$.equals(bQInputType2)) {
                extractJobConfiguration = ExtractJobConfiguration.newBuilder((TableId)tableId2, (String)destinationUri).setFormat(package$BQInputType$PARQUET$.MODULE$.toString()).setCompression(destinationCompressionType).build();
            } else if (bQInputType2 instanceof package.BQInputType.JSON) {
                extractJobConfiguration = ExtractJobConfiguration.newBuilder((TableId)tableId2, (String)destinationUri).setFormat(package$BQInputType$JSON$.MODULE$.toString()).setCompression(destinationCompressionType).build();
            } else {
                throw new package.BQLoadException("Unsupported Destination Format");
            }
            ExtractJobConfiguration extractJobConfiguration2 = extractJobConfiguration;
            Job job = this.client().create(JobInfo.of((JobConfiguration)extractJobConfiguration2), new BigQuery.JobOption[0]);
            Job completedJob = job.waitFor(new RetryOption[0]);
            if (completedJob.getStatus().getError() == null) {
                package$.MODULE$.logger().info(new StringBuilder(15).append("Source table: ").append(sourceDataset).append(".").append(sourceTable).toString());
                package$.MODULE$.logger().info(new StringBuilder(18).append("Destination path: ").append(destinationPath).toString());
                package$.MODULE$.logger().info(new StringBuilder(11).append("Job State: ").append(completedJob.getStatus().getState()).toString());
            } else if (completedJob.getStatus().getError() != null) {
                package$.MODULE$.logger().error(new StringBuilder(47).append("BigQuery was unable to extract due to an error:").append(job.getStatus().getError()).toString());
            } else {
                throw new package.BQLoadException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("Could not load data from bq table ").append(sourceDataset).append(".").append(sourceTable).append(" to  location  ").append(destinationFileName).append(" due to error ").append(completedJob.getStatus().getError().getMessage()).toString())).stripMargin());
            }
        });
    }

    @Override
    public String exportTable$default$7() {
        return "gzip";
    }

    public BQ copy(BigQuery client) {
        return new BQ(client);
    }

    public BigQuery copy$default$1() {
        return this.client();
    }

    public String productPrefix() {
        return "BQ";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.client();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BQ;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BQ)) return false;
        boolean bl = true;
        if (!bl) return false;
        BQ bQ = (BQ)x$1;
        BigQuery bigQuery = this.client();
        BigQuery bigQuery2 = bQ.client();
        if (bigQuery == null) {
            if (bigQuery2 != null) {
                return false;
            }
        } else if (!bigQuery.equals(bigQuery2)) return false;
        if (!bQ.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$loadTableFromLocalFile$2(String destinationTable$1, String destinationDataset$1, package.BQInputType sourceFormat$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String src_path = (String)tuple2._1();
            String partition = (String)tuple2._2();
            String tablePartition = new StringBuilder(1).append(destinationTable$1).append("$").append(partition).toString();
            String fullTableName = new StringBuilder(1).append(destinationDataset$1).append(".").append(tablePartition).toString();
            String bqLoadCmd = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(100).append("bq load --replace --time_partitioning_field date --require_partition_filter=false --source_format=").append(sourceFormat$1.toString()).append(" ").append(fullTableName).append(" ").append(src_path).toString())).stripMargin();
            package$.MODULE$.logger().info(new StringBuilder(24).append("Loading data from path: ").append(src_path).toString());
            package$.MODULE$.logger().info(new StringBuilder(19).append("Destination table: ").append(fullTableName).toString());
            package$.MODULE$.logger().info(new StringBuilder(20).append("BQ Load command is: ").append(bqLoadCmd).toString());
            int x = scala.sys.process.package$.MODULE$.stringToProcess(String.valueOf(bqLoadCmd)).$bang();
            package$.MODULE$.logger().info(new StringBuilder(18).append("Output exit code: ").append(x).toString());
            if (x != 0) {
                throw new package.BQLoadException("Error executing BQ load command");
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BQ(BigQuery client) {
        this.client = client;
        Product.$init$((Product)this);
    }
}

