/*
 * Decompiled with CFR 0.152.
 */
package gcp4zio;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.dataproc.v1.Cluster;
import com.google.cloud.dataproc.v1.ClusterConfig;
import com.google.cloud.dataproc.v1.ClusterControllerClient;
import com.google.cloud.dataproc.v1.DiskConfig;
import com.google.cloud.dataproc.v1.EndpointConfig;
import com.google.cloud.dataproc.v1.GceClusterConfig;
import com.google.cloud.dataproc.v1.InstanceGroupConfig;
import com.google.cloud.dataproc.v1.LifecycleConfig;
import com.google.cloud.dataproc.v1.SoftwareConfig;
import com.google.protobuf.Duration;
import gcp4zio.DP$;
import gcp4zio.DPApi;
import gcp4zio.package;
import gcp4zio.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Has;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.blocking.package;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\f\u0019\u0001nA\u0001\u0002\r\u0001\u0003\u0016\u0004%\t!\r\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005e!)\u0011\t\u0001C\u0001\u0005\")Q\t\u0001C\u0001\r\")q\r\u0001C\u0001Q\"9\u0001\u000fAA\u0001\n\u0003\t\bbB:\u0001#\u0003%\t\u0001\u001e\u0005\t\u007f\u0002\t\t\u0011\"\u0011\u0002\u0002!I\u0011\u0011\u0003\u0001\u0002\u0002\u0013\u0005\u00111\u0003\u0005\n\u00037\u0001\u0011\u0011!C\u0001\u0003;A\u0011\"!\u000b\u0001\u0003\u0003%\t%a\u000b\t\u0013\u0005e\u0002!!A\u0005\u0002\u0005m\u0002\"CA#\u0001\u0005\u0005I\u0011IA$\u0011%\tI\u0005AA\u0001\n\u0003\nY\u0005C\u0005\u0002N\u0001\t\t\u0011\"\u0011\u0002P\u001d9\u00111\u000b\r\t\u0002\u0005UcAB\f\u0019\u0011\u0003\t9\u0006\u0003\u0004B#\u0011\u0005\u0011\u0011\f\u0005\b\u00037\nB\u0011AA/\u0011%\ti(EA\u0001\n\u0003\u000by\bC\u0005\u0002\u0004F\t\t\u0011\"!\u0002\u0006\"I\u0011\u0011S\t\u0002\u0002\u0013%\u00111\u0013\u0002\u0003\tBS\u0011!G\u0001\bO\u000e\u0004HG_5p\u0007\u0001\u0019R\u0001\u0001\u000f#U5\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012(\u001d\t!S%D\u0001\u0019\u0013\t1\u0003$A\u0003E!\u0006\u0003\u0018.\u0003\u0002)S\t91+\u001a:wS\u000e,'B\u0001\u0014\u0019!\ti2&\u0003\u0002-=\t9\u0001K]8ek\u000e$\bCA\u000f/\u0013\tycD\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004dY&,g\u000e^\u000b\u0002eA\u00111GP\u0007\u0002i)\u0011QGN\u0001\u0003mFR!a\u000e\u001d\u0002\u0011\u0011\fG/\u00199s_\u000eT!!\u000f\u001e\u0002\u000b\rdw.\u001e3\u000b\u0005mb\u0014AB4p_\u001edWMC\u0001>\u0003\r\u0019w.\\\u0005\u0003\u007fQ\u0012qc\u00117vgR,'oQ8oiJ|G\u000e\\3s\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u00051A(\u001b8jiz\"\"a\u0011#\u0011\u0005\u0011\u0002\u0001\"\u0002\u0019\u0004\u0001\u0004\u0011\u0014AD2sK\u0006$X\rR1uCB\u0014xn\u0019\u000b\u0006\u000fFs\u0006M\u0019\t\u0004\u0011.seB\u0001\u0013J\u0013\tQ\u0005$A\u0004qC\u000e\\\u0017mZ3\n\u00051k%\u0001\u0004\"m_\u000e\\\u0017N\\4UCN\\'B\u0001&\u0019!\t\u0019t*\u0003\u0002Qi\t91\t\\;ti\u0016\u0014\b\"\u0002*\u0005\u0001\u0004\u0019\u0016aC2mkN$XM\u001d(b[\u0016\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,\u001f\u001b\u00059&B\u0001-\u001b\u0003\u0019a$o\\8u}%\u0011!LH\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[=!)q\f\u0002a\u0001'\u00069\u0001O]8kK\u000e$\b\"B1\u0005\u0001\u0004\u0019\u0016A\u0002:fO&|g\u000eC\u0003d\t\u0001\u0007A-A\u0003qe>\u00048\u000f\u0005\u0002IK&\u0011a-\u0014\u0002\u0013\t\u0006$\u0018\r\u001d:pGB\u0013x\u000e]3si&,7/\u0001\beK2,G/\u001a#bi\u0006\u0004(o\\2\u0015\t%lgn\u001c\t\u0004\u0011.S\u0007CA\u000fl\u0013\tagD\u0001\u0003V]&$\b\"\u0002*\u0006\u0001\u0004\u0019\u0006\"B0\u0006\u0001\u0004\u0019\u0006\"B1\u0006\u0001\u0004\u0019\u0016\u0001B2paf$\"a\u0011:\t\u000fA2\u0001\u0013!a\u0001e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A;+\u0005I28&A<\u0011\u0005alX\"A=\u000b\u0005i\\\u0018!C;oG\",7m[3e\u0015\tah$\u0001\u0006b]:|G/\u0019;j_:L!A`=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003mC:<'BAA\u0007\u0003\u0011Q\u0017M^1\n\u0007q\u000b9!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0016A\u0019Q$a\u0006\n\u0007\u0005eaDA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002 \u0005\u0015\u0002cA\u000f\u0002\"%\u0019\u00111\u0005\u0010\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002()\t\t\u00111\u0001\u0002\u0016\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\f\u0011\r\u0005=\u0012QGA\u0010\u001b\t\t\tDC\u0002\u00024y\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9$!\r\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\t\u0019\u0005E\u0002\u001e\u0003\u007fI1!!\u0011\u001f\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\n\r\u0003\u0003\u0005\r!a\b\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0006\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0001\u0002\r\u0015\fX/\u00197t)\u0011\ti$!\u0015\t\u0013\u0005\u001dr\"!AA\u0002\u0005}\u0011A\u0001#Q!\t!\u0013cE\u0002\u001295\"\"!!\u0016\u0002\t1Lg/\u001a\u000b\u0005\u0003?\nI\b\u0005\u0004\u0002b\u00055\u00141\u000f\b\u0005\u0003G\nIGD\u0002W\u0003KJ!!a\u001a\u0002\u0007iLw.C\u0002K\u0003WR!!a\u001a\n\t\u0005=\u0014\u0011\u000f\u0002\n)\u0006\u001c8\u000eT1zKJT1ASA6!\rA\u0015QO\u0005\u0004\u0003oj%!\u0002#Q\u000b:4\bBBA>'\u0001\u00071+\u0001\u0005f]\u0012\u0004x.\u001b8u\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0019\u0015\u0011\u0011\u0005\u0006aQ\u0001\rAM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9)!$\u0011\tu\tIIM\u0005\u0004\u0003\u0017s\"AB(qi&|g\u000e\u0003\u0005\u0002\u0010V\t\t\u00111\u0001D\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0016B!\u0011QAAL\u0013\u0011\tI*a\u0002\u0003\r=\u0013'.Z2u\u0001")
public class DP
implements DPApi.Service,
Product,
scala.Serializable {
    private final ClusterControllerClient client;

    public static Option<ClusterControllerClient> unapply(DP dP) {
        return DP$.MODULE$.unapply(dP);
    }

    public static DP apply(ClusterControllerClient clusterControllerClient) {
        return DP$.MODULE$.apply(clusterControllerClient);
    }

    public static ZLayer<Object, Throwable, Has<DPApi.Service>> live(String string) {
        return DP$.MODULE$.live(string);
    }

    public ClusterControllerClient client() {
        return this.client;
    }

    @Override
    public ZIO<Has<package.Blocking.Service>, Throwable, Cluster> createDataproc(String clusterName, String project, String region, package.DataprocProperties props) {
        return ZIO$.MODULE$.fromFutureJava((Function0 & Serializable & scala.Serializable)() -> {
            ClusterConfig clusterConfig;
            GceClusterConfig.Builder builder;
            GceClusterConfig.Builder builder2;
            EndpointConfig.Builder endPointConfig = EndpointConfig.newBuilder().setEnableHttpPortAccess(true);
            SoftwareConfig.Builder softwareConfig = SoftwareConfig.newBuilder().setImageVersion(props.image_version());
            DiskConfig.Builder diskConfigM = DiskConfig.newBuilder().setBootDiskType(props.boot_disk_type()).setBootDiskSizeGb(props.master_boot_disk_size_gb());
            DiskConfig.Builder diskConfigW = DiskConfig.newBuilder().setBootDiskType(props.boot_disk_type()).setBootDiskSizeGb(props.worker_boot_disk_size_gb());
            Option<String> option = props.subnet_uri();
            if (option instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                builder2 = GceClusterConfig.newBuilder().setInternalIpOnly(props.internal_ip_only()).setSubnetworkUri(value).addAllTags((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter(props.network_tags()).asJava()).addServiceAccountScopes("https://www.googleapis.com/auth/cloud-platform");
            } else if (None$.MODULE$.equals(option)) {
                builder2 = GceClusterConfig.newBuilder().setInternalIpOnly(props.internal_ip_only()).addAllTags((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter(props.network_tags()).asJava()).addServiceAccountScopes("https://www.googleapis.com/auth/cloud-platform");
            } else {
                throw new MatchError(option);
            }
            GceClusterConfig.Builder gceClusterBuilder = builder2;
            Option<String> option2 = props.service_account();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String value = (String)some.value();
                builder = gceClusterBuilder.setServiceAccount(value);
            } else {
                builder = gceClusterBuilder;
            }
            GceClusterConfig.Builder gceClusterConfig = builder;
            InstanceGroupConfig masterConfig = InstanceGroupConfig.newBuilder().setMachineTypeUri(props.master_machine_type_uri()).setNumInstances(props.master_num_instance()).setDiskConfig(diskConfigM).build();
            InstanceGroupConfig workerConfig = InstanceGroupConfig.newBuilder().setMachineTypeUri(props.worker_machine_type_uri()).setNumInstances(props.worker_num_instance()).setDiskConfig(diskConfigW).build();
            ClusterConfig.Builder clusterConfigBuilder = ClusterConfig.newBuilder().setMasterConfig(masterConfig).setWorkerConfig(workerConfig).setSoftwareConfig(softwareConfig).setConfigBucket(props.bucket_name()).setGceClusterConfig(gceClusterConfig).setEndpointConfig(endPointConfig);
            Option<Object> option3 = props.idle_deletion_duration_sec();
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                long value = BoxesRunTime.unboxToLong((Object)some.value());
                clusterConfig = clusterConfigBuilder.setLifecycleConfig(LifecycleConfig.newBuilder().setIdleDeleteTtl(Duration.newBuilder().setSeconds(value))).build();
            } else {
                clusterConfig = clusterConfigBuilder.build();
            }
            ClusterConfig clusterConfig2 = clusterConfig;
            Cluster cluster = Cluster.newBuilder().setClusterName(clusterName).setConfig(clusterConfig2).build();
            OperationFuture createClusterAsyncRequest = this.client().createClusterAsync(project, region, cluster);
            package$.MODULE$.logger().info(new StringBuilder(40).append("Submitting cluster creation request for ").append(clusterName).toString());
            return createClusterAsyncRequest;
        }).tapBoth((Function1 & Serializable & scala.Serializable)e -> UIO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.logger().error(new StringBuilder(35).append("Cluster creation failed with error ").append(e.getMessage()).toString())), (Function1 & Serializable & scala.Serializable)res -> UIO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.logger().info(new StringBuilder(29).append("Cluster ").append(res.getClusterName()).append(" created successfully").toString())), CanFail$.MODULE$.canFail());
    }

    @Override
    public ZIO<Has<package.Blocking.Service>, Throwable, BoxedUnit> deleteDataproc(String clusterName, String project, String region) {
        return ZIO$.MODULE$.fromFutureJava((Function0 & Serializable & scala.Serializable)() -> {
            package$.MODULE$.logger().info(new StringBuilder(40).append("Submitting cluster deletion request for ").append(clusterName).toString());
            return this.client().deleteClusterAsync(project, region, clusterName);
        }).tapBoth((Function1 & Serializable & scala.Serializable)e -> UIO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.logger().error(new StringBuilder(35).append("Cluster deletion failed with error ").append(e.getMessage()).toString())), (Function1 & Serializable & scala.Serializable)x$1 -> UIO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package$.MODULE$.logger().info(new StringBuilder(29).append("Cluster ").append(clusterName).append(" deleted successfully").toString())), CanFail$.MODULE$.canFail()).unit();
    }

    public DP copy(ClusterControllerClient client) {
        return new DP(client);
    }

    public ClusterControllerClient copy$default$1() {
        return this.client();
    }

    public String productPrefix() {
        return "DP";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.client();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DP;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DP)) return false;
        boolean bl = true;
        if (!bl) return false;
        DP dP = (DP)x$1;
        ClusterControllerClient clusterControllerClient = this.client();
        ClusterControllerClient clusterControllerClient2 = dP.client();
        if (clusterControllerClient == null) {
            if (clusterControllerClient2 != null) {
                return false;
            }
        } else if (!clusterControllerClient.equals(clusterControllerClient2)) return false;
        if (!dP.canEqual(this)) return false;
        return true;
    }

    public DP(ClusterControllerClient client) {
        this.client = client;
        Product.$init$((Product)this);
    }
}

