/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.templates;

import com.github.sanctum.templates.SimpleMetaTemplate;
import com.github.sanctum.templates.Template;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="SanctumMetaTemplate")
@DelegateDeserialization(value=SimpleMetaTemplate.class)
public interface MetaTemplate
extends ConfigurationSerializable {
    @NotNull
    public Material getType();

    @NotNull
    public ItemMeta getBaseMeta();

    @NotNull
    default public ItemStack compose(@NotNull Template template) {
        ItemStack item = new ItemStack(this.getType());
        if (!item.setItemMeta(this.getBaseMeta())) {
            throw new IllegalStateException("Unable to map BaseMeta!");
        }
        return template.produce(() -> item);
    }

    @NotNull
    default public Map<String, Object> serialize() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"material", (Object)this.getType().name());
        builder.put((Object)"meta", (Object)this.getBaseMeta());
        return builder.build();
    }
}

