/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.templates;

import com.github.sanctum.templates.MetaTemplate;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="SanctumMetaTemplate")
public class SimpleMetaTemplate
implements MetaTemplate {
    private final Material type;
    private final ItemMeta baseMeta;

    public SimpleMetaTemplate(@NotNull ItemStack original) {
        this(original.getType(), Optional.ofNullable(original.getItemMeta()).map(ItemMeta::clone).orElseThrow(IllegalStateException::new));
    }

    protected SimpleMetaTemplate(@NotNull Material type, @NotNull ItemMeta baseMeta) {
        this.type = type;
        this.baseMeta = baseMeta;
    }

    private SimpleMetaTemplate(@NotNull Map<String, Object> serialized) throws IllegalArgumentException {
        this(Optional.ofNullable(serialized.get("material")).filter(String.class::isInstance).map(String.class::cast).map(Material::valueOf).orElseThrow(IllegalArgumentException::new), Optional.ofNullable(serialized.get("meta")).filter(ItemMeta.class::isInstance).map(ItemMeta.class::cast).orElseThrow(IllegalStateException::new));
        if (!Bukkit.getItemFactory().isApplicable(this.baseMeta, this.type)) {
            throw new IllegalArgumentException("This meta cannot be applied to the item type specified.");
        }
    }

    @Override
    @NotNull
    public Material getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ItemMeta getBaseMeta() {
        return this.baseMeta;
    }

    public static MetaTemplate deserialize(@NotNull Map<String, Object> map) throws IllegalArgumentException {
        return new SimpleMetaTemplate(map);
    }

    public static MetaTemplate valueOf(@NotNull Map<String, Object> map) throws IllegalArgumentException {
        return new SimpleMetaTemplate(map);
    }
}

