/*
 * Decompiled with CFR 0.152.
 */
package com.github.sanctum.templates;

import com.github.sanctum.templates.Template;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializableAs(value="SanctumTemplate")
public class SimpleTemplate
implements Template {
    private final String name;
    private final List<String> lore;
    private final Integer count;
    private final Map<Enchantment, Integer> enchants;
    private final List<ItemFlag> flags;
    private final List<ItemFlag> removeFlags;

    private SimpleTemplate(@NotNull Map<String, Object> serialized) {
        this(Optional.ofNullable(serialized.get("name")).filter(String.class::isInstance).map(String.class::cast).orElse(null), Optional.ofNullable(serialized.get("lore")).filter(String.class::isInstance).map(String.class::cast).orElse(null), Optional.ofNullable(serialized.get("count")).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(null), Optional.ofNullable(serialized.get("enchantments")).filter(Map.class::isInstance).map(map -> {
            Map enchantsSection;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            try {
                enchantsSection = (Map)map;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid enchants section!", e);
            }
            enchantsSection.forEach((enchantName, level) -> {
                int levelInt;
                try {
                    levelInt = (Integer)level;
                }
                catch (ClassCastException e) {
                    return;
                }
                builder.put(enchantName, (Object)levelInt);
            });
            return builder.build();
        }).orElse(null), Optional.ofNullable(serialized.get("flags")).filter(List.class::isInstance).map(list -> {
            List flagsList;
            ImmutableList.Builder builder = ImmutableList.builder();
            try {
                flagsList = (List)list;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid flags section!", e);
            }
            flagsList.forEach(flagName -> {
                ItemFlag flag;
                try {
                    flag = ItemFlag.valueOf((String)flagName);
                }
                catch (IllegalArgumentException ignored) {
                    return;
                }
                builder.add((Object)flag);
            });
            return builder.build();
        }).orElse(null), Optional.ofNullable(serialized.get("remove-flags")).filter(List.class::isInstance).map(list -> {
            List removeFlagsSection;
            ImmutableList.Builder builder = ImmutableList.builder();
            try {
                removeFlagsSection = (List)list;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid remove-flags section!", e);
            }
            removeFlagsSection.forEach(flagName -> {
                ItemFlag flag;
                try {
                    flag = ItemFlag.valueOf((String)flagName);
                }
                catch (IllegalArgumentException ignored) {
                    return;
                }
                builder.add((Object)flag);
            });
            return builder.build();
        }).orElse(null));
    }

    protected SimpleTemplate(@Nullable String name, @Nullable String lore, @Nullable Integer count, @Nullable Map<String, Integer> enchants, @Nullable List<ItemFlag> flags, @Nullable List<ItemFlag> removeFlags) {
        this.name = name;
        this.lore = Optional.ofNullable(lore).map(encoded -> lore.split("\\n")).map(Arrays::asList).orElse(null);
        this.count = count;
        this.enchants = Optional.ofNullable(enchants).map(map -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.forEach((key, value) -> {
                NamespacedKey enchantmentKey;
                if (key.contains(":")) {
                    String[] split = key.split(":");
                    if (split.length != 2) {
                        return;
                    }
                    enchantmentKey = new NamespacedKey(split[0], split[1]);
                } else {
                    enchantmentKey = NamespacedKey.minecraft((String)key);
                }
                Arrays.stream(Enchantment.values()).filter(enchantment -> enchantment.getKey().equals((Object)enchantmentKey)).findAny().ifPresent(validEnchant -> {
                    int level = value;
                    if (level < 1) {
                        throw new IllegalArgumentException("Level cannot be less than 1!");
                    }
                    builder.put(validEnchant, (Object)level);
                });
            });
            return builder.build();
        }).orElse(null);
        this.flags = flags;
        this.removeFlags = removeFlags;
    }

    @Override
    @NotNull
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @NotNull
    public Optional<List<String>> getLore() {
        return Optional.ofNullable(this.lore);
    }

    @Override
    @NotNull
    public Optional<Integer> getCount() {
        return Optional.ofNullable(this.count);
    }

    @Override
    @NotNull
    public Optional<Map<Enchantment, Integer>> getEnchantments() {
        return Optional.ofNullable(this.enchants);
    }

    @Override
    @NotNull
    public Optional<List<ItemFlag>> getItemFlagsToAdd() {
        return Optional.ofNullable(this.flags);
    }

    @Override
    @NotNull
    public Optional<List<ItemFlag>> getItemFlagsToRemove() {
        return Optional.ofNullable(this.removeFlags);
    }

    public static Template deserialize(@NotNull Map<String, Object> map) throws IllegalArgumentException {
        return new SimpleTemplate(map);
    }

    public static Template valueOf(@NotNull Map<String, Object> map) throws IllegalArgumentException {
        return new SimpleTemplate(map);
    }
}

