/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.autoconfigure;

import com.github.tocrhz.mqtt.autoconfigure.MqttClientManager;
import com.github.tocrhz.mqtt.autoconfigure.PayloadJacksonAutoConfiguration;
import com.github.tocrhz.mqtt.convert.MqttConversionService;
import com.github.tocrhz.mqtt.properties.MqttConfigAdapter;
import com.github.tocrhz.mqtt.properties.MqttProperties;
import com.github.tocrhz.mqtt.publisher.MqttPublisher;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Order
@AutoConfigureAfter(value={PayloadJacksonAutoConfiguration.class})
@ConditionalOnClass(value={MqttAsyncClient.class})
@ConditionalOnProperty(prefix="mqtt", name={"disable"}, havingValue="false", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttProperties.class})
@Configuration
public class MqttAutoConfiguration {
    public MqttAutoConfiguration(ListableBeanFactory beanFactory) {
        MqttConversionService.addBeans(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={MqttConfigAdapter.class})
    public MqttConfigAdapter mqttConfigAdapter() {
        return MqttConfigAdapter.defaultAdapter();
    }

    @Bean
    @Order
    public MqttClientManager mqttClientManager(MqttProperties properties, MqttConfigAdapter adapter, ConfigurableBeanFactory factory) {
        return new MqttClientManager(properties, adapter, factory);
    }

    @Bean
    @Order
    @ConditionalOnMissingBean(value={MqttPublisher.class})
    public MqttPublisher mqttPublisher(MqttClientManager manager) {
        return new MqttPublisher(manager);
    }
}

