/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.autoconfigure;

import com.github.tocrhz.mqtt.autoconfigure.MqttSubscribeProcessor;
import com.github.tocrhz.mqtt.convert.MqttConversionService;
import com.github.tocrhz.mqtt.properties.MqttConfigAdapter;
import com.github.tocrhz.mqtt.properties.MqttConnectionProperties;
import com.github.tocrhz.mqtt.properties.MqttProperties;
import com.github.tocrhz.mqtt.publisher.SimpleMqttClient;
import com.github.tocrhz.mqtt.subscriber.MqttSubscriber;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MqttClientManager
implements DisposableBean,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(MqttClientManager.class);
    private final LinkedHashMap<String, SimpleMqttClient> clients = new LinkedHashMap();
    private final LinkedList<MqttSubscriber> subscribers;
    private final MqttProperties properties;
    private final MqttConfigAdapter adapter;
    private final ConfigurableBeanFactory factory;
    private String defaultClientId = null;

    public MqttClientManager(MqttProperties properties, MqttConfigAdapter adapter, ConfigurableBeanFactory factory) {
        this.properties = properties;
        this.adapter = adapter;
        this.subscribers = MqttSubscribeProcessor.subscribers();
        this.factory = factory;
        adapter.setProperties(properties);
    }

    public SimpleMqttClient clientNew(MqttConnectionProperties properties) {
        String clientId = properties.getClientId();
        Assert.hasText((String)clientId, (String)"property clientId is required.");
        Assert.notEmpty((Object[])properties.getUri(), (String)"property uri cannot be empty.");
        Assert.hasText((String)properties.getUri()[0], (String)"property uri is required.");
        if (this.clients.containsKey(clientId)) {
            this.clientClose(clientId);
        }
        this.properties.merge(properties);
        MqttConnectOptions options = this.properties.toOptions(properties);
        return this.clientNew(clientId, options, properties.getDefaultPublishQos());
    }

    void clientNew(String clientId, MqttConnectOptions options) {
        this.clientNew(clientId, options, null);
    }

    public SimpleMqttClient clientNew(String clientId, MqttConnectOptions options, Integer defaultPublishQos) {
        IMqttAsyncClient client;
        Assert.hasText((String)clientId, (String)"clientId is required.");
        if (this.clients.containsKey(clientId)) {
            this.clientClose(clientId);
        }
        try {
            client = this.adapter.postCreate(clientId, options.getServerURIs());
        }
        catch (MqttException e) {
            log.error("create mqtt client error: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        boolean enableShared = this.properties.isEnableSharedSubscription(clientId);
        int qos = defaultPublishQos != null ? defaultPublishQos.intValue() : this.properties.getDefaultPublishQos(clientId);
        SimpleMqttClient smc = new SimpleMqttClient(clientId, client, options, enableShared, qos, this.subscribers, this.adapter);
        this.clients.put(clientId, smc);
        return smc;
    }

    public void clientClose(String clientId) {
        if (this.clients.containsKey(clientId)) {
            if (this.defaultClientId != null && this.defaultClientId.equals(clientId)) {
                String oldDefault = this.defaultClientId;
                String newDefault = null;
                for (SimpleMqttClient value : this.clients.values()) {
                    if (value.id().equals(clientId)) continue;
                    newDefault = value.id();
                }
                if (newDefault != null) {
                    this.defaultClientId = newDefault;
                    log.warn("default mqtt client '{}' closed, changed to '{}' ", (Object)oldDefault, newDefault);
                } else {
                    log.warn("default mqtt client '{}' closed, other client not exists. ", (Object)oldDefault);
                }
            }
            SimpleMqttClient client = (SimpleMqttClient)this.clients.remove(clientId);
            client.close();
        }
    }

    public SimpleMqttClient clientGetOrDefault(String clientId) {
        if (StringUtils.hasText((String)clientId) && this.clients.containsKey(clientId)) {
            return this.clients.get(clientId);
        }
        return this.clients.get(this.defaultClientId);
    }

    public boolean setDefaultClientId(String clientId) {
        if (StringUtils.hasText((String)clientId) && this.clients.containsKey(clientId)) {
            this.defaultClientId = clientId;
            return true;
        }
        return false;
    }

    void afterInit() {
        this.clients.forEach((id, client) -> {
            try {
                if (this.defaultClientId == null) {
                    this.defaultClientId = id;
                }
                client.connect();
            }
            catch (Exception e) {
                log.error("mqtt client '{}' close error: {}", new Object[]{id, e.getMessage(), e});
            }
        });
    }

    public void destroy() {
        log.info("shutting down all mqtt client.");
        this.clients.forEach((id, client) -> {
            try {
                client.close();
            }
            catch (Exception e) {
                log.error("mqtt client '{}' close error: {}", new Object[]{id, e.getMessage(), e});
            }
        });
        this.clients.clear();
        this.subscribers.clear();
        MqttConversionService.destroy();
    }

    void resolveEmbeddedValueTopic() {
        this.adapter.beforeResolveEmbeddedValue(this.subscribers);
        for (MqttSubscriber subscriber : this.subscribers) {
            subscriber.resolveEmbeddedValue(this.factory);
        }
        this.adapter.afterResolveEmbeddedValue(this.subscribers);
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.resolveEmbeddedValueTopic();
        this.properties.forEach(this::clientNew);
        this.afterInit();
    }
}

