/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.autoconfigure;

import com.github.tocrhz.mqtt.annotation.MqttSubscribe;
import com.github.tocrhz.mqtt.subscriber.MqttSubscriber;
import com.github.tocrhz.mqtt.subscriber.SubscriberModel;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="mqtt", name={"disable"}, havingValue="false", matchIfMissing=true)
public class MqttSubscribeProcessor
implements BeanPostProcessor {
    private static final LinkedList<MqttSubscriber> subscribers = new LinkedList();

    public static LinkedList<MqttSubscriber> subscribers() {
        return subscribers;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods;
        for (Method method : methods = bean.getClass().getMethods()) {
            if (!method.isAnnotationPresent(MqttSubscribe.class)) continue;
            SubscriberModel model = SubscriberModel.of(method.getAnnotation(MqttSubscribe.class));
            subscribers.add(MqttSubscriber.of(model, bean, method));
        }
        return bean;
    }
}

