/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.convert.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tocrhz.mqtt.convert.PayloadSerialize;
import com.github.tocrhz.mqtt.convert.jackson.JacksonPayloadDeserialize;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonPayloadSerialize
implements PayloadSerialize {
    private static final Logger log = LoggerFactory.getLogger(JacksonPayloadDeserialize.class);
    private final ObjectMapper objectMapper;

    public JacksonPayloadSerialize(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public byte[] convert(Object source) {
        try {
            if (source instanceof byte[]) {
                return (byte[])source;
            }
            if (source instanceof String) {
                return ((String)source).getBytes(StandardCharsets.UTF_8);
            }
            return this.objectMapper.writeValueAsBytes(source);
        }
        catch (JsonProcessingException e) {
            log.warn("Payload serialize error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

