/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.convert.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public class JacksonStringDeserialize
implements ConverterFactory<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(JacksonStringDeserialize.class);
    private final ObjectMapper objectMapper;

    public JacksonStringDeserialize(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> Converter<String, T> getConverter(Class<T> targetType) {
        return source -> {
            try {
                if (targetType == byte[].class) {
                    return source.getBytes(StandardCharsets.UTF_8);
                }
                if (targetType == String.class) {
                    return source;
                }
                return this.objectMapper.readValue(source, targetType);
            }
            catch (IOException e) {
                log.warn("Payload deserialize error: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        };
    }
}

