/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.convert.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class JacksonStringSerialize
implements Converter<Object, String> {
    private static final Logger log = LoggerFactory.getLogger(JacksonStringSerialize.class);
    private final ObjectMapper objectMapper;

    public JacksonStringSerialize(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String convert(Object source) {
        try {
            if (source instanceof String) {
                return (String)source;
            }
            return this.objectMapper.writeValueAsString(source);
        }
        catch (JsonProcessingException e) {
            log.warn("Payload serialize error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

