/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.properties;

import com.github.tocrhz.mqtt.properties.MqttConnectionProperties;
import com.github.tocrhz.mqtt.properties.MqttProperties;
import org.springframework.util.Assert;

public class MqttClientRegistry {
    private final MqttProperties mqttProperties;

    public MqttClientRegistry(MqttProperties mqttProperties) {
        this.mqttProperties = mqttProperties;
    }

    public MqttClientRegistry disable() {
        this.mqttProperties.setDisable(true);
        return this;
    }

    public MqttClientRegistry add(String clientId, String ... uri) {
        Assert.notNull((Object)clientId, (String)"clientId can not be null.");
        MqttConnectionProperties properties = new MqttConnectionProperties();
        if (uri != null && uri.length > 0) {
            properties.setUri(uri);
        } else {
            properties.setUri(null);
        }
        properties.setClientId(clientId);
        this.mqttProperties.getClients().put(clientId, properties);
        this.resetClientId(clientId);
        return this;
    }

    public MqttClientRegistry add(String clientId, MqttConnectionProperties properties) {
        Assert.notNull((Object)clientId, (String)"clientId can not be null.");
        Assert.notNull((Object)properties, (String)"properties can not be null.");
        properties.setClientId(clientId);
        this.mqttProperties.getClients().put(clientId, properties);
        this.resetClientId(clientId);
        return this;
    }

    public MqttClientRegistry remove(String clientId) {
        Assert.notNull((Object)clientId, (String)"clientId can not be null.");
        this.mqttProperties.getClients().remove(clientId);
        this.resetClientId(clientId);
        return this;
    }

    public MqttClientRegistry clear() {
        this.mqttProperties.setClientId(null);
        this.mqttProperties.getClients().clear();
        return this;
    }

    public MqttClientRegistry setDefault(MqttConnectionProperties properties) {
        this.mqttProperties.setClientId(properties.getClientId());
        this.mqttProperties.setUsername(properties.getUsername());
        this.mqttProperties.setWill(properties.getWill());
        this.mqttProperties.setAutomaticReconnect(properties.getAutomaticReconnect());
        this.mqttProperties.setCleanSession(properties.getCleanSession());
        this.mqttProperties.setConnectionTimeout(properties.getConnectionTimeout());
        this.mqttProperties.setExecutorServiceTimeout(properties.getExecutorServiceTimeout());
        this.mqttProperties.setKeepAliveInterval(properties.getKeepAliveInterval());
        this.mqttProperties.setMaxReconnectDelay(properties.getMaxReconnectDelay());
        this.mqttProperties.setPassword(properties.getPassword());
        this.mqttProperties.setUri(properties.getUri());
        this.mqttProperties.setEnableSharedSubscription(properties.getEnableSharedSubscription());
        this.mqttProperties.setDefaultPublishQos(properties.getDefaultPublishQos());
        return this;
    }

    private void resetClientId(String clientId) {
        if (this.mqttProperties.getClientId() != null && clientId.equals(this.mqttProperties.getClientId())) {
            this.mqttProperties.setClientId(null);
        }
    }
}

