/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.properties;

import com.github.tocrhz.mqtt.properties.MqttClientRegistry;
import com.github.tocrhz.mqtt.properties.MqttProperties;
import com.github.tocrhz.mqtt.subscriber.MqttSubscriber;
import com.github.tocrhz.mqtt.subscriber.TopicPair;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public abstract class MqttConfigAdapter {
    protected MqttProperties mqttProperties;

    public static MqttConfigAdapter defaultAdapter() {
        return new MqttConfigAdapter(){};
    }

    public final void setProperties(MqttProperties mqttProperties) {
        this.mqttProperties = mqttProperties;
        MqttClientRegistry clientRegistry = new MqttClientRegistry(mqttProperties);
        this.beforeCreate(clientRegistry);
    }

    public void beforeResolveEmbeddedValue(LinkedList<MqttSubscriber> subscribers) {
    }

    public void afterResolveEmbeddedValue(LinkedList<MqttSubscriber> subscribers) {
    }

    public void beforeCreate(MqttClientRegistry registry) {
    }

    public IMqttAsyncClient postCreate(String clientId, String[] serverURIs) throws MqttException {
        return new MqttAsyncClient(serverURIs[0], clientId, (MqttClientPersistence)new MemoryPersistence());
    }

    public void beforeConnect(String clientId, MqttConnectOptions options) {
    }

    public void beforeSubscribe(String clientId, Set<TopicPair> topicPairs) {
    }
}

