/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.publisher;

import com.github.tocrhz.mqtt.autoconfigure.MqttClientManager;
import com.github.tocrhz.mqtt.publisher.SimpleMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;

public class MqttPublisher {
    private final MqttClientManager manager;

    public MqttPublisher(MqttClientManager manager) {
        this.manager = manager;
    }

    public SimpleMqttClient client() {
        return this.manager.clientGetOrDefault(null);
    }

    public SimpleMqttClient client(String clientId) {
        return this.manager.clientGetOrDefault(clientId);
    }

    public void send(String topic, Object payload) {
        this.client().send(topic, payload);
    }

    public void send(String topic, Object payload, boolean retained) {
        this.client().send(topic, payload, retained);
    }

    public void send(String topic, Object payload, IMqttActionListener callback) {
        this.client().send(topic, payload, callback);
    }

    public void send(String topic, Object payload, boolean retained, IMqttActionListener callback) {
        this.client().send(topic, payload, retained, callback);
    }

    public void send(String topic, Object payload, int qos) {
        this.client().send(topic, payload, qos);
    }

    public void send(String topic, Object payload, int qos, boolean retained) {
        this.client().send(topic, payload, qos, retained);
    }

    public void send(String topic, Object payload, int qos, IMqttActionListener callback) {
        this.client().send(topic, payload, qos, callback);
    }

    public void send(String topic, Object payload, int qos, boolean retained, IMqttActionListener callback) {
        this.client().send(topic, payload, qos, retained, callback);
    }
}

