/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.subscriber;

import com.github.tocrhz.mqtt.convert.MqttConversionService;
import com.github.tocrhz.mqtt.exception.NullParameterException;
import com.github.tocrhz.mqtt.subscriber.IMessageHandler;
import com.github.tocrhz.mqtt.subscriber.ParameterModel;
import com.github.tocrhz.mqtt.subscriber.SubscriberModel;
import com.github.tocrhz.mqtt.subscriber.TopicPair;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.convert.converter.Converter;

public class MqttSubscriber {
    private static final Logger log = LoggerFactory.getLogger(MqttSubscriber.class);
    private SubscriberModel subscribe;
    private String[] clientIds;
    private IMessageHandler handler;
    private LinkedList<ParameterModel> parameters;
    private final LinkedList<TopicPair> topics = new LinkedList();
    private boolean hasResolveEmbeddedValue;

    public void accept(String clientId, String topic, MqttMessage mqttMessage) {
        Optional<TopicPair> matched = this.matched(clientId, topic);
        if (matched.isPresent()) {
            try {
                Object[] parameters = this.fillParameters(matched.get(), topic, mqttMessage);
                this.handler.receive(parameters);
            }
            catch (NullParameterException e) {
                log.debug("message params error: {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                log.error("message handler error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static MqttSubscriber of(SubscriberModel subscribe, Object bean, Method method) {
        LinkedList<ParameterModel> parameters = ParameterModel.of(method);
        IMessageHandler handler = params -> method.invoke(bean, params);
        return MqttSubscriber.of(subscribe, parameters, handler);
    }

    public static MqttSubscriber of(SubscriberModel subscribe, LinkedList<ParameterModel> parameters, IMessageHandler handler) {
        MqttSubscriber subscriber = new MqttSubscriber();
        subscriber.subscribe = subscribe;
        subscriber.handler = handler;
        subscriber.parameters = parameters;
        return subscriber;
    }

    private void setTopics(SubscriberModel subscribe, HashMap<String, Class<?>> paramTypeMap) {
        String[] topics = subscribe.value();
        int[] qos = this.fillQos(topics, subscribe.qos());
        String[] groups = this.fillGroups(topics, subscribe.groups());
        LinkedHashSet<TopicPair> temps = new LinkedHashSet<TopicPair>();
        for (int i = 0; i < topics.length; ++i) {
            temps.add(TopicPair.of(topics[i], qos[i], groups[i], paramTypeMap));
        }
        this.topics.addAll(temps);
        this.topics.sort(Comparator.comparingInt(TopicPair::order));
    }

    private int[] fillQos(String[] topics, int[] qos) {
        int topic_len = topics.length;
        int qos_len = qos.length;
        if (topic_len > qos_len) {
            int[] temp = new int[topic_len];
            System.arraycopy(qos, 0, temp, 0, qos_len);
            Arrays.fill(temp, qos_len, topic_len, qos[qos_len - 1]);
            return temp;
        }
        if (qos_len > topic_len) {
            int[] temp = new int[topic_len];
            System.arraycopy(qos, 0, temp, 0, topic_len);
            return temp;
        }
        return qos;
    }

    private String[] fillGroups(String[] topics, String[] groups) {
        int topic_len = topics.length;
        int qos_len = groups.length;
        if (topic_len > qos_len) {
            Object[] temp = new String[topic_len];
            System.arraycopy(groups, 0, temp, 0, qos_len);
            Arrays.fill(temp, qos_len, topic_len, groups[qos_len - 1]);
            return temp;
        }
        if (qos_len > topic_len) {
            String[] temp = new String[topic_len];
            System.arraycopy(groups, 0, temp, 0, topic_len);
            return temp;
        }
        return groups;
    }

    private Optional<TopicPair> matched(String clientId, String topic) {
        if (this.clientIds == null || this.clientIds.length == 0 || Arrays.binarySearch(this.clientIds, clientId) >= 0) {
            return this.topics.stream().filter(pair -> pair.isMatched(topic)).findFirst();
        }
        return Optional.empty();
    }

    private Object[] fillParameters(TopicPair topicPair, String topic, MqttMessage mqttMessage) {
        HashMap<String, String> pathValueMap = topicPair.getPathValueMap(topic);
        LinkedList<MqttMessage> objects = new LinkedList<MqttMessage>();
        for (ParameterModel parameter : this.parameters) {
            Class<?> target = parameter.getType();
            String name = parameter.getName();
            LinkedList<Converter<Object, Object>> converters = parameter.getConverters();
            Object value = null;
            if (target == MqttMessage.class) {
                value = mqttMessage;
            } else if (parameter.isPayload() && mqttMessage != null) {
                value = MqttConversionService.getSharedInstance().fromBytes(mqttMessage.getPayload(), target, converters);
            } else if (name != null) {
                if (pathValueMap.containsKey(name)) {
                    value = this.fromTopic(pathValueMap.get(name), target);
                }
            } else if (target == String.class) {
                value = topic;
            } else if (target.getClassLoader() != null && mqttMessage != null) {
                value = MqttConversionService.getSharedInstance().fromBytes(mqttMessage.getPayload(), target, converters);
            }
            if (value == null) {
                if (parameter.isRequired()) {
                    throw new NullParameterException(parameter);
                }
                value = parameter.getDefaultValue();
            }
            objects.add((MqttMessage)value);
        }
        return objects.toArray();
    }

    private Object fromTopic(String value, Class<?> target) {
        if (MqttConversionService.getSharedInstance().canConvert(String.class, target)) {
            return MqttConversionService.getSharedInstance().convert(value, target);
        }
        log.warn("Unsupported covert from {} to {}", (Object)String.class.getName(), (Object)target.getName());
        return null;
    }

    public LinkedList<TopicPair> getTopics() {
        return this.topics;
    }

    public boolean containsClientId(String clientId) {
        if (this.clientIds == null || this.clientIds.length == 0) {
            return true;
        }
        for (String id : this.clientIds) {
            if (!id.equals(clientId)) continue;
            return true;
        }
        return false;
    }

    public void resolveEmbeddedValue(ConfigurableBeanFactory factory) {
        if (this.hasResolveEmbeddedValue) {
            return;
        }
        this.hasResolveEmbeddedValue = true;
        if (factory != null) {
            String[] clients = this.subscribe.clients();
            for (int i = 0; i < clients.length; ++i) {
                clients[i] = factory.resolveEmbeddedValue(clients[i]);
            }
            String[] value = this.subscribe.value();
            for (int i = 0; i < value.length; ++i) {
                value[i] = factory.resolveEmbeddedValue(value[i]);
            }
        }
        HashMap paramTypeMap = new HashMap();
        this.parameters.stream().filter(param -> param.getName() != null).forEach(param -> paramTypeMap.put(param.getName(), param.getType()));
        this.clientIds = this.subscribe.clients();
        this.setTopics(this.subscribe, paramTypeMap);
    }
}

