/*
 * Decompiled with CFR 0.152.
 */
package com.github.tocrhz.mqtt.subscriber;

import com.github.tocrhz.mqtt.subscriber.TopicParam;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.springframework.util.Assert;

public class TopicPair {
    private static final Pattern TO_PATTERN = Pattern.compile("\\{(\\w+)}");
    private static final Pattern TO_TOPIC = Pattern.compile("[^/]*\\{\\w+}[^/]*");
    private static final String STRING_PARAM = "([^/]+)";
    private static final String NUMBER_PARAM = "(\\\\d+(:?\\\\.\\\\d+)?)";
    private String topic;
    private Pattern pattern;
    private TopicParam[] params;
    private int qos;
    private String group;

    public static TopicPair of(String topic, int qos) {
        return TopicPair.of(topic, qos, null, new HashMap());
    }

    public static TopicPair of(String topic, int qos, String group, HashMap<String, Class<?>> paramTypeMap) {
        Assert.isTrue((topic != null && !topic.isEmpty() ? 1 : 0) != 0, (String)"topic cannot be blank");
        Assert.isTrue((qos >= 0 ? 1 : 0) != 0, (String)"qos min value is 0");
        Assert.isTrue((qos <= 2 ? 1 : 0) != 0, (String)"qos max value is 2");
        TopicPair topicPair = new TopicPair();
        if (topic.contains("{")) {
            LinkedList<TopicParam> params = new LinkedList<TopicParam>();
            topicPair.pattern = TopicPair.toPattern(topic, params, paramTypeMap);
            topicPair.params = params.toArray(new TopicParam[0]);
            topicPair.topic = TO_TOPIC.matcher(topic).replaceAll("+");
        } else {
            topicPair.topic = topic;
        }
        MqttTopic.validate((String)topicPair.topic, (boolean)true);
        topicPair.qos = qos;
        topicPair.group = group;
        return topicPair;
    }

    private static Pattern toPattern(String topic, LinkedList<TopicParam> params, HashMap<String, Class<?>> paramTypeMap) {
        String pattern = TopicPair.replaceSymbols(topic);
        Matcher matcher = TO_PATTERN.matcher(pattern);
        StringBuilder builder = new StringBuilder("^");
        int group = 1;
        while (matcher.find()) {
            String paramName = matcher.group(1);
            params.add(new TopicParam(paramName, group));
            if (paramTypeMap.containsKey(paramName)) {
                Class<?> paramType = paramTypeMap.get(paramName);
                if (Number.class.isAssignableFrom(paramType)) {
                    matcher.appendReplacement(builder, NUMBER_PARAM);
                    ++group;
                } else {
                    matcher.appendReplacement(builder, STRING_PARAM);
                }
            } else {
                matcher.appendReplacement(builder, STRING_PARAM);
            }
            ++group;
        }
        matcher.appendTail(builder);
        builder.append("$");
        return Pattern.compile(builder.toString());
    }

    public String getTopic(boolean enableShare) {
        if (enableShare && this.group != null && !this.group.isBlank()) {
            return "$share/" + this.group + "/" + this.topic;
        }
        return this.topic;
    }

    public int getQos() {
        return this.qos;
    }

    public boolean isMatched(String topic) {
        if (this.pattern != null) {
            return this.pattern.matcher(topic).matches();
        }
        return MqttTopic.isMatched((String)this.topic, (String)topic);
    }

    public HashMap<String, String> getPathValueMap(String topic) {
        Matcher matcher;
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.pattern != null && (matcher = this.pattern.matcher(topic)).find()) {
            for (TopicParam param : this.params) {
                String group = matcher.group(param.getAt());
                map.put(param.getName(), group);
            }
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPair topicPair = (TopicPair)o;
        return Objects.equals(this.topic, topicPair.topic);
    }

    public int hashCode() {
        return Objects.hash(this.topic);
    }

    public int order() {
        return this.pattern == null ? 1 : -this.params.length;
    }

    private static String replaceSymbols(String topic) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        block5: for (char ch : chars = topic.toCharArray()) {
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    sb.append('\\').append(ch);
                    continue block5;
                }
                case '+': {
                    sb.append("[^/]+");
                    continue block5;
                }
                case '#': {
                    sb.append(".*");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

