/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.CheckedRunnable;
import com.github.tonivade.purefun.Consumer1;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.Higher2;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.ZIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.MonadDefer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;

@HigherKind
public final class EIO<E, T>
implements Higher2<\u00b5, E, T> {
    private final ZIO<Nothing, E, T> value;

    EIO(ZIO<Nothing, E, T> value) {
        this.value = Objects.requireNonNull(value);
    }

    public <R> ZIO<R, E, T> toZIO() {
        return this.value;
    }

    public Either<E, T> safeRunSync() {
        return this.value.provide(Nothing.nothing());
    }

    public Future<Either<E, T>> toFuture() {
        return this.value.toFuture(Nothing.nothing());
    }

    public void async(Executor executor, Consumer1<Try<Either<E, T>>> callback) {
        this.value.provideAsync(executor, Nothing.nothing(), callback);
    }

    public void async(Consumer1<Try<Either<E, T>>> callback) {
        this.async(Future.DEFAULT_EXECUTOR, callback);
    }

    public <F extends Kind> Higher1<F, Either<E, T>> foldMap(MonadDefer<F> monad) {
        return this.value.foldMap(Nothing.nothing(), monad);
    }

    public <B> EIO<E, B> map(Function1<T, B> map) {
        return new EIO<E, B>(this.value.map(map));
    }

    public <B> EIO<E, B> flatMap(Function1<T, EIO<E, B>> map) {
        return new EIO(this.value.flatMap(value -> ((EIO)map.apply((Object)value)).value));
    }

    public EIO<T, E> swap() {
        return new EIO<T, E>(this.value.swap());
    }

    public <B> EIO<B, T> mapError(Function1<E, B> map) {
        return new EIO<B, T>(this.value.mapError(map));
    }

    public <F> EIO<F, T> flatMapError(Function1<E, EIO<F, T>> map) {
        return new EIO(this.value.flatMapError(error -> ((EIO)map.apply((Object)error)).value));
    }

    public <B, F> EIO<F, B> bimap(Function1<E, F> mapError, Function1<T, B> map) {
        return new EIO<F, B>(this.value.bimap(mapError, map));
    }

    public <B> EIO<E, B> andThen(EIO<E, B> next) {
        return new EIO<E, T>(this.value.andThen(next.value));
    }

    public <B, F> EIO<F, B> foldM(Function1<E, EIO<F, B>> mapError, Function1<T, EIO<F, B>> map) {
        return new EIO(this.value.foldM(error -> ((EIO)mapError.apply((Object)error)).value, value -> ((EIO)map.apply((Object)value)).value));
    }

    public <B> UIO<B> fold(Function1<E, B> mapError, Function1<T, B> map) {
        return new UIO<B>(this.value.fold(mapError, map));
    }

    public UIO<T> recover(Function1<E, T> mapError) {
        return new UIO<T>(this.value.recover(mapError));
    }

    public EIO<E, T> orElse(Producer<EIO<E, T>> other) {
        return new EIO<E, T>(this.value.orElse(() -> ((EIO)other.get()).value));
    }

    public EIO<E, T> repeat() {
        return this.repeat(1);
    }

    public EIO<E, T> repeat(int times) {
        return this.repeat(UIO.unit(), times);
    }

    public EIO<E, T> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    public EIO<E, T> repeat(Duration delay, int times) {
        return this.repeat(UIO.sleep(delay), times);
    }

    public EIO<E, T> retry() {
        return this.retry(1);
    }

    public EIO<E, T> retry(int maxRetries) {
        return this.retry(UIO.unit(), maxRetries);
    }

    public EIO<E, T> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    public EIO<E, T> retry(Duration delay, int maxRetries) {
        return this.retry(UIO.sleep(delay), maxRetries);
    }

    private EIO<E, T> repeat(UIO<Unit> pause, int times) {
        return this.foldM(EIO::raiseError, value -> {
            if (times > 0) {
                return pause.toEIO().andThen(this.repeat(pause, times - 1));
            }
            return EIO.pure(value);
        });
    }

    private EIO<E, T> retry(UIO<Unit> pause, int maxRetries) {
        return this.foldM(error -> {
            if (maxRetries > 0) {
                return pause.toEIO().andThen(this.retry(pause.repeat(), maxRetries - 1));
            }
            return EIO.raiseError(error);
        }, EIO::pure);
    }

    public static <E, A, B, C> EIO<E, C> map2(EIO<E, A> za, EIO<E, B> zb, Function2<A, B, C> mapper) {
        return new EIO<E, C>(ZIO.map2(za.value, zb.value, mapper));
    }

    public static <E, A> EIO<E, A> absorb(EIO<E, Either<E, A>> value) {
        return new EIO(ZIO.absorb(value.value));
    }

    public static <A, B> Function1<A, EIO<Throwable, B>> lift(Function1<A, B> function) {
        return ZIO.lift(function).andThen(EIO::new);
    }

    public static <E, A> EIO<E, A> fromEither(Producer<Either<E, A>> task) {
        return new EIO<E, A>(ZIO.fromEither(task));
    }

    public static EIO<Throwable, Unit> exec(CheckedRunnable task) {
        return new EIO<Throwable, Unit>(ZIO.exec(task));
    }

    public static <E, A> EIO<E, A> pure(A value) {
        return new EIO(ZIO.pure(value));
    }

    public static <E, A> EIO<E, A> defer(Producer<EIO<E, A>> lazy) {
        return new EIO(ZIO.defer(() -> ((EIO)lazy.get()).value));
    }

    public static <A> EIO<Throwable, A> task(Producer<A> task) {
        return new EIO<Throwable, A>(ZIO.task(task));
    }

    public static <E, A> EIO<E, A> raiseError(E error) {
        return new EIO(ZIO.raiseError(error));
    }

    public static <A extends AutoCloseable, B> EIO<Throwable, B> bracket(EIO<Throwable, A> acquire, Function1<A, EIO<Throwable, B>> use) {
        return new EIO(ZIO.bracket(acquire.value, resource -> ((EIO)use.apply((Object)resource)).value));
    }

    public static <A, B> EIO<Throwable, B> bracket(EIO<Throwable, A> acquire, Function1<A, EIO<Throwable, B>> use, Consumer1<A> release) {
        return new EIO(ZIO.bracket(acquire.value, resource -> ((EIO)use.apply((Object)resource)).value, release));
    }

    public static <E> EIO<E, Unit> unit() {
        return new EIO(ZIO.unit());
    }

    public static <E, T> EIO<E, T> narrowK(Higher1<Higher1<\u00b5, E>, T> hkt) {
        return (EIO)hkt;
    }

    public static <E, T> EIO<E, T> narrowK(Higher2<\u00b5, E, T> hkt) {
        return (EIO)hkt;
    }

    public static final class \u00b5
    implements Kind {
    }
}

