/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.Operator1;
import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.effect.UIO;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class Ref<A> {
    private final AtomicReference<A> value;

    private Ref(AtomicReference<A> value) {
        this.value = Objects.requireNonNull(value);
    }

    public UIO<A> get() {
        return UIO.task(this.value::get);
    }

    public UIO<Unit> set(A newValue) {
        return UIO.task(() -> {
            this.value.set(newValue);
            return Unit.unit();
        });
    }

    public UIO<Unit> lazySet(A newValue) {
        return UIO.task(() -> {
            this.value.lazySet(newValue);
            return Unit.unit();
        });
    }

    public UIO<A> getAndSet(A newValue) {
        return UIO.task(() -> this.value.getAndSet(newValue));
    }

    public UIO<A> updateAndGet(Operator1<A> update) {
        return UIO.task(() -> this.value.updateAndGet(arg_0 -> ((Operator1)update).apply(arg_0)));
    }

    public UIO<A> getAndUpdate(Operator1<A> update) {
        return UIO.task(() -> this.value.getAndUpdate(arg_0 -> ((Operator1)update).apply(arg_0)));
    }

    public static <A> Ref<A> of(A value) {
        return new Ref<A>(new AtomicReference<A>(value));
    }

    public String toString() {
        return "Ref(" + this.value.get() + ")";
    }
}

