/*
 * Decompiled with CFR 0.152.
 */
package com.github.tonivade.purefun.effect;

import com.github.tonivade.purefun.CheckedRunnable;
import com.github.tonivade.purefun.Consumer1;
import com.github.tonivade.purefun.Function1;
import com.github.tonivade.purefun.Function2;
import com.github.tonivade.purefun.Higher1;
import com.github.tonivade.purefun.HigherKind;
import com.github.tonivade.purefun.Kind;
import com.github.tonivade.purefun.Nothing;
import com.github.tonivade.purefun.Producer;
import com.github.tonivade.purefun.Recoverable;
import com.github.tonivade.purefun.Unit;
import com.github.tonivade.purefun.concurrent.Future;
import com.github.tonivade.purefun.effect.EIO;
import com.github.tonivade.purefun.effect.UIO;
import com.github.tonivade.purefun.effect.ZIO;
import com.github.tonivade.purefun.type.Either;
import com.github.tonivade.purefun.type.Try;
import com.github.tonivade.purefun.typeclasses.MonadDefer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;

@HigherKind
public final class Task<T>
implements Recoverable,
Higher1<\u00b5, T> {
    private final ZIO<Nothing, Throwable, T> value;

    Task(ZIO<Nothing, Throwable, T> value) {
        this.value = Objects.requireNonNull(value);
    }

    public <R> ZIO<R, Throwable, T> toZIO() {
        return this.value;
    }

    public EIO<Throwable, T> toEIO() {
        return new EIO<Throwable, T>(this.value);
    }

    public Try<T> safeRunSync() {
        return this.absorb(this.value.provide(Nothing.nothing()));
    }

    public Future<Try<T>> toFuture() {
        return this.value.toFuture(Nothing.nothing()).map(this::absorb);
    }

    public void async(Executor executor, Consumer1<Try<T>> callback) {
        this.value.provideAsync(executor, Nothing.nothing(), result -> callback.accept(this.flatAbsorb((Try<Either<Throwable, T>>)result)));
    }

    public void async(Consumer1<Try<T>> callback) {
        this.async(Future.DEFAULT_EXECUTOR, callback);
    }

    public <F extends Kind> Higher1<F, T> foldMap(MonadDefer<F> monad) {
        return monad.flatMap(this.value.foldMap(Nothing.nothing(), monad), arg_0 -> monad.fromEither(arg_0));
    }

    public <B> Task<B> map(Function1<T, B> map) {
        return new Task<B>(this.value.map(map));
    }

    public <B> Task<B> flatMap(Function1<T, Task<B>> map) {
        return new Task(this.value.flatMap(value -> ((Task)map.apply((Object)value)).value));
    }

    public <B> Task<B> andThen(Task<B> next) {
        return new Task<T>(this.value.andThen(next.value));
    }

    public <B> Task<B> foldM(Function1<Throwable, Task<B>> mapError, Function1<T, Task<B>> map) {
        return new Task(this.value.foldM(error -> ((Task)mapError.apply((Object)error)).value, value -> ((Task)map.apply((Object)value)).value));
    }

    public <B> UIO<B> fold(Function1<Throwable, B> mapError, Function1<T, B> map) {
        return new UIO<B>(this.value.fold(mapError, map));
    }

    public UIO<T> recover(Function1<Throwable, T> mapError) {
        return new UIO<T>(this.value.recover(mapError));
    }

    public Task<T> orElse(Producer<Task<T>> other) {
        return new Task<T>(this.value.orElse(() -> ((Task)other.get()).value));
    }

    public Task<T> repeat() {
        return this.repeat(1);
    }

    public Task<T> repeat(int times) {
        return this.repeat(Task.unit(), times);
    }

    public Task<T> repeat(Duration delay) {
        return this.repeat(delay, 1);
    }

    public Task<T> repeat(Duration delay, int times) {
        return this.repeat(Task.sleep(delay), times);
    }

    public Task<T> retry() {
        return this.retry(1);
    }

    public Task<T> retry(int maxRetries) {
        return this.retry(Task.unit(), maxRetries);
    }

    public Task<T> retry(Duration delay) {
        return this.retry(delay, 1);
    }

    public Task<T> retry(Duration delay, int maxRetries) {
        return this.retry(Task.sleep(delay), maxRetries);
    }

    private Task<T> repeat(Task<Unit> pause, int times) {
        return this.foldM(Task::raiseError, value -> {
            if (times > 0) {
                return pause.andThen(this.repeat(pause, times - 1));
            }
            return Task.pure(value);
        });
    }

    private Task<T> retry(Task<Unit> pause, int maxRetries) {
        return this.foldM(error -> {
            if (maxRetries > 0) {
                return pause.andThen(this.retry(pause.repeat(), maxRetries - 1));
            }
            return Task.raiseError(error);
        }, Task::pure);
    }

    public static <A, B, C> Task<C> map2(Task<A> za, Task<B> zb, Function2<A, B, C> mapper) {
        return new Task<C>(ZIO.map2(za.value, zb.value, mapper));
    }

    public static <A> Task<A> absorb(Task<Either<Throwable, A>> value) {
        return new Task(ZIO.absorb(value.value));
    }

    public static <A, B> Function1<A, Task<B>> lift(Function1<A, B> function) {
        return ZIO.lift(function).andThen(Task::new);
    }

    public static <A> Task<A> fromEither(Producer<Either<Throwable, A>> task) {
        return new Task<A>(ZIO.fromEither(task));
    }

    public static Task<Unit> sleep(Duration delay) {
        return Task.exec(() -> Thread.sleep(delay.toMillis()));
    }

    public static Task<Unit> exec(CheckedRunnable task) {
        return new Task<Unit>(ZIO.exec(task));
    }

    public static <A> Task<A> pure(A value) {
        return new Task<A>(ZIO.pure(value));
    }

    public static <A> Task<A> defer(Producer<Task<A>> lazy) {
        return new Task(ZIO.defer(() -> ((Task)lazy.get()).value));
    }

    public static <A> Task<A> task(Producer<A> task) {
        return new Task<A>(ZIO.task(task));
    }

    public static <A> Task<A> raiseError(Throwable error) {
        return new Task(ZIO.raiseError(error));
    }

    public static <A extends AutoCloseable, B> Task<B> bracket(Task<A> acquire, Function1<A, Task<B>> use) {
        return new Task(ZIO.bracket(acquire.value, resource -> ((Task)use.apply((Object)resource)).value));
    }

    public static <A, B> Task<B> bracket(Task<A> acquire, Function1<A, Task<B>> use, Consumer1<A> release) {
        return new Task(ZIO.bracket(acquire.value, resource -> ((Task)use.apply((Object)resource)).value, release));
    }

    public static Task<Unit> unit() {
        return new Task<Unit>(ZIO.unit());
    }

    private Try<T> flatAbsorb(Try<Either<Throwable, T>> result) {
        return result.map(this::absorb).flatMap(Function1.identity());
    }

    private Try<T> absorb(Either<Throwable, T> either) {
        return (Try)either.fold(Try::failure, Try::success);
    }

    public static <T> Task<T> narrowK(Higher1<\u00b5, T> hkt) {
        return (Task)hkt;
    }

    public static final class \u00b5
    implements Kind {
    }
}

